/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;

public final class LinkedHashCollectionHelper {
    private static final Class SET_CLASS;
    private static final Class MAP_CLASS;

    public static Set createLinkedHashSet() {
        try {
            return (Set)SET_CLASS.newInstance();
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not instantiate LinkedHashSet", e);
        }
    }

    public static Map createLinkedHashMap() {
        try {
            return (Map)MAP_CLASS.newInstance();
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not instantiate LinkedHashMap", e);
        }
    }

    private LinkedHashCollectionHelper() {
    }

    static {
        Class<?> mapClass;
        Class<?> setClass;
        try {
            setClass = Class.forName("java.util.LinkedHashSet");
            mapClass = Class.forName("java.util.LinkedHashMap");
        }
        catch (ClassNotFoundException cnfe) {
            setClass = null;
            mapClass = null;
        }
        SET_CLASS = setClass;
        MAP_CLASS = mapClass;
    }
}

