/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;

public abstract class GenericsHelper {
    public static Class getCollectionParameterType(MethodParameter methodParam) {
        return GenericsHelper.getGenericParameterType(methodParam, 0);
    }

    public static Class getMapKeyParameterType(MethodParameter methodParam) {
        return GenericsHelper.getGenericParameterType(methodParam, 0);
    }

    public static Class getMapValueParameterType(MethodParameter methodParam) {
        return GenericsHelper.getGenericParameterType(methodParam, 1);
    }

    public static Class getCollectionReturnType(Method method) {
        return GenericsHelper.getGenericReturnType(method, 0);
    }

    public static Class getMapKeyReturnType(Method method) {
        return GenericsHelper.getGenericReturnType(method, 0);
    }

    public static Class getMapValueReturnType(Method method) {
        return GenericsHelper.getGenericReturnType(method, 1);
    }

    private static Class getGenericParameterType(MethodParameter methodParam, int typeIndex) {
        if (methodParam.getConstructor() != null) {
            return GenericsHelper.extractType(methodParam.getConstructor().getGenericParameterTypes()[methodParam.getParameterIndex()], typeIndex);
        }
        return GenericsHelper.extractType(methodParam.getMethod().getGenericParameterTypes()[methodParam.getParameterIndex()], typeIndex);
    }

    private static Class getGenericReturnType(Method method, int typeIndex) {
        return GenericsHelper.extractType(method.getGenericReturnType(), typeIndex);
    }

    private static Class extractType(Type type, int typeIndex) {
        Type[] paramTypes;
        if (type instanceof ParameterizedType && (paramTypes = ((ParameterizedType)type).getActualTypeArguments())[typeIndex] instanceof Class) {
            return (Class)paramTypes[typeIndex];
        }
        return null;
    }
}

