/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class FlushMode
implements Serializable {
    private final int level;
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final FlushMode NEVER = new FlushMode(0, "NEVER");
    public static final FlushMode COMMIT = new FlushMode(5, "COMMIT");
    public static final FlushMode AUTO = new FlushMode(10, "AUTO");
    public static final FlushMode ALWAYS = new FlushMode(20, "ALWAYS");

    private FlushMode(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean lessThan(FlushMode other) {
        return this.level < other.level;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    static {
        INSTANCES.put(FlushMode.NEVER.name, NEVER);
        INSTANCES.put(FlushMode.AUTO.name, AUTO);
        INSTANCES.put(FlushMode.ALWAYS.name, ALWAYS);
        INSTANCES.put(FlushMode.COMMIT.name, COMMIT);
    }
}

