/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import javax.swing.JLabel;

/**
 *
 * @author  gtoffoli
 */
public class BasicInputControlUI extends javax.swing.JPanel implements InputControlUI {
    
    /** Creates new form BasicInputControlUI */
    public BasicInputControlUI() {
        initComponents();
    }
    
    public Object getValue()
    {
        return getJComboBoxValue().getSelectedItem();
    }
    
    public void setValue(Object v)
    {
        for (int i=0; i<getJComboBoxValue().getItemCount(); ++i)
        {
            Object val = getJComboBoxValue().getItemAt(i);
            if (val.equals( v))
            {
                getJComboBoxValue().setSelectedIndex(i);
                return;
            }
        }
        
        getJComboBoxValue().setSelectedItem(v);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelName = new javax.swing.JLabel();
        jComboBoxValue = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(250, 40));
        jLabelName.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabelName, gridBagConstraints);

        jComboBoxValue.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 14, 0, 4);
        add(jComboBoxValue, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    public void setLabel(String lbl)
    {
        this.jLabelName.setText(lbl);
    }
    
    public void setHistory(java.util.List values){
        
        getJComboBoxValue().removeAllItems();
        if (values == null) return;
        for (int i=0; i<values.size(); ++i)
        {
            getJComboBoxValue().addItem( values.get(i));
        }
        
        if (getJComboBoxValue().getItemCount() > 0)
        {
            getJComboBoxValue().setSelectedIndex(0);
        }
        
        getJComboBoxValue().updateUI();
    }
    
    public void setComboEditable(boolean b)
    {
        getJComboBoxValue().setEditable(b);
    }
    
    public boolean getComboEditable()
    {
        return getJComboBoxValue().isEditable();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxValue;
    private javax.swing.JLabel jLabelName;
    // End of variables declaration//GEN-END:variables
    
    public void setReadOnly( boolean b )
    {
        jLabelName.setEnabled(!b);
        getJComboBoxValue().setEnabled(!b);
    }

    public javax.swing.JComboBox getJComboBoxValue() {
        return jComboBoxValue;
    }

    public void setJComboBoxValue(javax.swing.JComboBox jComboBoxValue) {
        this.jComboBoxValue = jComboBoxValue;
    }
}
