/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ServerChildren;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class DeleteServerAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DeleteServerAction.class, (String)"CTL_DeleteServerAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            ResourceNode node = (ResourceNode)activatedNodes[i];
            JServer server = node.getRepositoryObject().getServer();
            if (JOptionPane.showConfirmDialog(Misc.getMainFrame(), "Are you sure you want to delete the server '" + server + "' ?", "Deleting server", 1, 2) != 0) continue;
            JasperServerManager.getMainInstance().saveConfiguration();
            Node root = activatedNodes[0].getParentNode();
            while (root.getParentNode() != null) {
                root = root.getParentNode();
            }
            JasperServerManager.getMainInstance().getJServers().remove(server);
            if (!(root.getChildren() instanceof ServerChildren)) continue;
            ((ServerChildren)root.getChildren()).recalculateKeys();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof ResourceNode) continue;
            return false;
        }
        return true;
    }
}

