/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.codetemplates;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplatesStorage {
    private static final Logger LOG = Logger.getLogger(CodeTemplatesStorage.class.getName());
    private static final String E_ROOT = "codetemplates";
    private static final String E_CODETEMPLATE = "codetemplate";
    private static final String E_DESCRIPTION = "description";
    private static final String E_CODE = "code";
    private static final String A_ABBREV = "abbreviation";
    private static final String A_DESCRIPTION_ID = "descriptionId";
    private static final String A_CONTEXTS = "contexts";
    private static final String A_UUID = "uuid";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Code Templates settings 1.0//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorCodeTemplates-1_0.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-codetemplatesettings";

    public static Map<String, CodeTemplateDescription> load(MimePath mimePath, boolean bl) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.CODETEMPLATES.getLocator().scan(fileObject, mimePath.getPath(), null, true, true, !bl, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        List list = (List)hashMap.get(null);
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap hashMap2 = new HashMap();
        for (Object[] objectArray : list) {
            FileObject fileObject2 = (FileObject)objectArray[0];
            FileObject fileObject3 = (FileObject)objectArray[1];
            boolean bl2 = (Boolean)objectArray[2];
            XMLStorage.Handler handler = MIME_TYPE.equals(fileObject3.getMIMEType()) ? new Reader() : new LegacyReader();
            Object[] objectArray2 = (Object[])XMLStorage.load(fileObject3, handler);
            Map map = (Map)objectArray2[0];
            Collection collection = (Collection)objectArray2[1];
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Loading codetemplates from: '" + fileObject3.getPath() + "'");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("--- Removing codetemplates: " + collection);
            }
            for (String string : collection) {
                hashMap2.remove(string);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("--- Adding codetemplates: " + map);
            }
            hashMap2.putAll(map);
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("-------------------------------------");
        }
        return Collections.unmodifiableMap(hashMap2);
    }

    public static void save(MimePath mimePath, boolean bl, final Collection<CodeTemplateDescription> collection, final Collection<String> collection2) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        final FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        final String string = SettingsType.CODETEMPLATES.getLocator().getWritableFileName(mimePath.getPath(), null, null, bl);
        try {
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject = fileSystem.findResource("Editors");
                    FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
                    CodeTemplatesStorage.saveCodeTemplates(fileObject2, collection, collection2);
                }
            });
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't save editor codetempaltes for " + mimePath.getPath(), iOException);
        }
    }

    public static void delete(MimePath mimePath, boolean bl) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors");
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.CODETEMPLATES.getLocator().scan(fileObject, mimePath.getPath(), null, true, bl, !bl, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        final List list = (List)hashMap.get(null);
        if (list != null) {
            try {
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() {
                        for (Object[] objectArray : list) {
                            FileObject fileObject = (FileObject)objectArray[1];
                            try {
                                fileObject.delete();
                            }
                            catch (IOException iOException) {
                                LOG.log(Level.WARNING, "Can't delete editor settings file " + fileObject.getPath(), iOException);
                            }
                        }
                    }
                });
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't delete editor codetemplates for " + mimePath.getPath(), iOException);
            }
        }
    }

    private CodeTemplatesStorage() {
    }

    private static void saveCodeTemplates(FileObject fileObject, Collection<CodeTemplateDescription> collection, Collection<String> collection2) {
        Element element;
        Document document = XMLUtil.createDocument((String)E_ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node node = document.getElementsByTagName(E_ROOT).item(0);
        for (CodeTemplateDescription object : collection) {
            Object object2;
            CharSequence charSequence;
            element = document.createElement(E_CODETEMPLATE);
            node.appendChild(element);
            element.setAttribute(A_ABBREV, object.getAbbreviation());
            List list = object.getContexts();
            if (list != null && !list.isEmpty()) {
                charSequence = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    object2 = (String)list.get(i);
                    if (object2 == null || ((String)(object2 = ((String)object2).trim())).length() <= 0) continue;
                    if (i > 0) {
                        ((StringBuilder)charSequence).append(",");
                    }
                    ((StringBuilder)charSequence).append((String)object2);
                }
                if (((StringBuilder)charSequence).length() > 0) {
                    element.setAttribute(A_CONTEXTS, ((StringBuilder)charSequence).toString());
                }
            }
            if ((charSequence = object.getUniqueId()) != null) {
                element.setAttribute(A_UUID, (String)charSequence);
            }
            element.setAttribute(A_XML_SPACE, V_PRESERVE);
            String string = object.getParametrizedText();
            if (string.length() > 0) {
                object2 = document.createElement(E_CODE);
                object2.appendChild(document.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)string)));
                element.appendChild((Node)object2);
            }
            if ((object2 = object.getDescription()) == null || ((String)object2).length() <= 0) continue;
            Element element2 = document.createElement(E_DESCRIPTION);
            element2.appendChild(document.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)object2)));
            element.appendChild(element2);
        }
        for (String string : collection2) {
            element = document.createElement(E_CODETEMPLATE);
            node.appendChild(element);
            element.setAttribute(A_ABBREV, string);
            element.setAttribute(A_REMOVE, Boolean.TRUE.toString());
        }
        XMLStorage.save(fileObject, document);
    }

    private static final class LegacyReader
    extends XMLStorage.Handler {
        private static final String EL_ROOT = "abbrevs";
        private static final String EL_CODETEMPLATE = "abbrev";
        private static final String AL_ABBREV = "key";
        private static final String AL_REMOVE = "remove";
        private Map<String, CodeTemplateDescription> codeTemplatesMap = new HashMap<String, CodeTemplateDescription>();
        private Collection<String> removedTemplates = new ArrayList<String>();
        private String abbreviation = null;
        private StringBuilder text = null;

        private LegacyReader() {
        }

        public Object getResult() {
            return new Object[]{this.codeTemplatesMap, this.removedTemplates};
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_CODETEMPLATE)) {
                boolean bl = Boolean.valueOf(attributes.getValue("remove"));
                if (bl) {
                    String string4 = attributes.getValue(AL_ABBREV);
                    this.removedTemplates.add(string4);
                    this.abbreviation = null;
                    this.text = null;
                } else {
                    this.abbreviation = attributes.getValue(AL_ABBREV);
                    this.text = new StringBuilder();
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_CODETEMPLATE) && this.abbreviation != null) {
                String string4 = this.text.toString().replaceFirst("([^|]+)[|]([^|]+)", "$1\\${cursor}$2");
                CodeTemplateDescription codeTemplateDescription = new CodeTemplateDescription(this.abbreviation, null, CharacterConversions.lineSeparatorToLineFeed((CharSequence)string4), null, null);
                this.codeTemplatesMap.put(this.abbreviation, codeTemplateDescription);
            }
        }
    }

    private static final class Reader
    extends XMLStorage.Handler {
        private Map<String, CodeTemplateDescription> codeTemplatesMap = new HashMap<String, CodeTemplateDescription>();
        private Collection<String> removedTemplates = new ArrayList<String>();
        private String abbreviation = null;
        private String description = null;
        private String code = null;
        private List<String> contexts = null;
        private String uuid = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;

        private Reader() {
        }

        public Object getResult() {
            return new Object[]{this.codeTemplatesMap, this.removedTemplates};
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
                if (this.insideCdata) {
                    this.cdataText.append(cArray, n, n2);
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(CodeTemplatesStorage.E_ROOT)) {
                if (string3.equals(CodeTemplatesStorage.E_CODETEMPLATE)) {
                    boolean bl = Boolean.valueOf(attributes.getValue(CodeTemplatesStorage.A_REMOVE));
                    if (bl) {
                        String string4 = attributes.getValue(CodeTemplatesStorage.A_ABBREV);
                        this.removedTemplates.add(string4);
                        this.abbreviation = null;
                        this.description = null;
                        this.contexts = null;
                        this.uuid = null;
                        this.text = null;
                        this.cdataText = null;
                    } else {
                        String string5;
                        this.abbreviation = attributes.getValue(CodeTemplatesStorage.A_ABBREV);
                        this.description = attributes.getValue(CodeTemplatesStorage.A_DESCRIPTION_ID);
                        if (this.description != null && (string5 = Utils.getLocalizedName(this.getProcessedFile(), this.description, null)) != null) {
                            this.description = string5;
                        }
                        if ((string5 = attributes.getValue(CodeTemplatesStorage.A_CONTEXTS)) != null) {
                            String[] stringArray = string5.split(",");
                            this.contexts = new ArrayList<String>(stringArray.length);
                            for (String string6 : stringArray) {
                                if ((string6 = string6.trim()).length() <= 0) continue;
                                this.contexts.add(string6);
                            }
                        } else {
                            this.contexts = null;
                        }
                        this.uuid = attributes.getValue(CodeTemplatesStorage.A_UUID);
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_CODE)) {
                    if (this.abbreviation != null) {
                        this.text = new StringBuilder();
                        this.cdataText = new StringBuilder();
                        this.insideCdata = false;
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_DESCRIPTION) && this.abbreviation != null) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(CodeTemplatesStorage.E_ROOT)) {
                if (string3.equals(CodeTemplatesStorage.E_CODETEMPLATE)) {
                    if (this.abbreviation != null) {
                        CodeTemplateDescription codeTemplateDescription = new CodeTemplateDescription(this.abbreviation, this.description == null ? null : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.description), this.code == null ? "" : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.code), this.contexts, this.uuid);
                        this.codeTemplatesMap.put(this.abbreviation, codeTemplateDescription);
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_CODE)) {
                    if (this.text != null) {
                        this.code = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_DESCRIPTION) && this.text != null) {
                    if (this.cdataText.length() > 0) {
                        this.description = this.cdataText.toString();
                    } else if (this.text.length() > 0) {
                        this.description = this.text.toString();
                    }
                }
            }
        }

        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }
    }
}

