/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.themes;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.SortedSet;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillPiePlot;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.DefaultChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class SimpleChartTheme
extends DefaultChartTheme {
    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot, byte evaluation) throws JRException {
        super.configureChart(jfreeChart, jrPlot, evaluation);
        LegendTitle legend = jfreeChart.getLegend();
        if (legend != null) {
            jfreeChart.getLegend().setBorder(BlockBorder.NONE);
        }
    }

    protected void configurePlot(Plot plot, JRChartPlot jrPlot) {
        XYPlot xyPlot;
        CategoryPlot categoryPlot;
        super.configurePlot(plot, jrPlot);
        SortedSet seriesColors = this.getPlot().getSeriesColors();
        if (seriesColors == null || seriesColors.size() == 0) {
            Paint[] colors = new Color[]{new Color(66, 138, 247, 180), new Color(206, 77, 24, 180), new Color(123, 207, 24, 180), new Color(247, 207, 57, 180), new Color(90, 186, 206, 180)};
            plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        }
        CategoryPlot categoryPlot2 = categoryPlot = plot instanceof CategoryPlot ? (CategoryPlot)plot : null;
        if (categoryPlot != null) {
            if (this.getPlot().getOwnBackcolor() == null) {
                categoryPlot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(222, 231, 247), 0.0f, this.getChart().getHeight() / 2, Color.white, true));
                categoryPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            }
            CategoryDataset categoryDataset = categoryPlot.getDataset();
            CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                categoryRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
            }
        }
        XYPlot xYPlot = xyPlot = plot instanceof XYPlot ? (XYPlot)plot : null;
        if (xyPlot != null) {
            xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
            xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
            xyPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        }
    }

    protected JFreeChart createPieChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createPieChart(evaluation);
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        if (this.getPlot().getOwnBackcolor() == null) {
            piePlot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(222, 231, 247), 0.0f, this.getChart().getHeight() / 2, Color.white, true));
        }
        piePlot.setLabelBackgroundPaint((Paint)TRANSPARENT_PAINT);
        piePlot.setLabelShadowPaint((Paint)TRANSPARENT_PAINT);
        piePlot.setLabelOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (((JRFillPieDataset)this.getDataset()).getLabelGenerator() == null && ((JRFillPiePlot)this.getPlot()).getLabelFormat() == null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({2})"));
        }
        if (((JRFillPiePlot)this.getPlot()).getLegendLabelFormat() == null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        }
        return jfreeChart;
    }

    protected JFreeChart createPie3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createPie3DChart(evaluation);
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        if (this.getPlot().getOwnBackcolor() == null) {
            piePlot3D.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(222, 231, 247), 0.0f, this.getChart().getHeight() / 2, Color.white, true));
        }
        piePlot3D.setLabelBackgroundPaint((Paint)TRANSPARENT_PAINT);
        piePlot3D.setLabelShadowPaint((Paint)TRANSPARENT_PAINT);
        piePlot3D.setLabelOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (((JRFillPieDataset)this.getDataset()).getLabelGenerator() == null && ((JRFillPie3DPlot)this.getPlot()).getLabelFormat() == null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({2})"));
        }
        if (((JRFillPie3DPlot)this.getPlot()).getLegendLabelFormat() == null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        }
        return jfreeChart;
    }

    protected JFreeChart createBarChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createBarChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createBar3DChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        if (this.getPlot().getOwnBackcolor() == null) {
            categoryPlot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(222, 231, 247), 0.0f, this.getChart().getHeight(), Color.white, true));
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            categoryRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
        }
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createBubbleChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        XYItemRenderer itemRenderer = xyPlot.getRenderer();
        itemRenderer.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createXYBarChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        XYBarRenderer renderer = (XYBarRenderer)xyPlot.getRenderer();
        renderer.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        renderer.setMargin(0.1);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createXyAreaChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        return jfreeChart;
    }

    protected JFreeChart createScatterChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createScatterChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createXyLineChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createTimeSeriesChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createHighLowChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createCandlestickChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setBackgroundPaint((Paint)new Color(222, 231, 247));
        xyPlot.setRangeTickBandPaint((Paint)new Color(231, 243, 255));
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createStackedBar3DChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        if (this.getPlot().getOwnBackcolor() == null) {
            categoryPlot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(222, 231, 247), 0.0f, this.getChart().getHeight(), Color.white, true));
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            categoryRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
        }
        return jfreeChart;
    }
}

