/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class AttachWindowAction
extends AbstractAction
implements Presenter.Menu {
    private static final String PROP_ACTION_CHANGED = "actionChanged";
    private final PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("activated".equals(string) || "modes".equals(string) || "editorAreaState".equals(string)) {
                AttachWindowAction.this.updateState();
            }
        }
    };

    public AttachWindowAction() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)WindowManagerImpl.getInstance())));
        this.updateState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void updateState() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        String string = topComponent == null ? "" : topComponent.getName();
        this.putValue("Name", NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_AttachWindowAction", (Object)string));
        if (WindowManagerImpl.getInstance().getEditorAreaState() == 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(topComponent != null);
        }
        this.firePropertyChange(PROP_ACTION_CHANGED, null, null);
    }

    public JMenuItem getMenuPresenter() {
        LazyPopup lazyPopup = new LazyPopup(this);
        Actions.connect((JMenuItem)((Object)lazyPopup), (Action)this, (boolean)false);
        return lazyPopup;
    }

    private static class AttachAction
    extends AbstractAction {
        private final ModeImpl mode;
        private final String side;

        public AttachAction(ModeImpl modeImpl, String string) {
            String string2;
            this.mode = modeImpl;
            this.side = string;
            if (string == null) {
                string2 = "CTL_SideAsLastTab";
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (modeImpl.getOpenedTopComponents().contains(topComponent)) {
                    this.setEnabled(false);
                }
            } else if (string == "top") {
                string2 = "CTL_SideTop";
            } else if (string == "left") {
                string2 = "CTL_SideLeft";
            } else if (string == "bottom") {
                string2 = "CTL_SideBottom";
            } else if (string == "right") {
                string2 = "CTL_SideRight";
            } else {
                return;
            }
            this.putValue("Name", NbBundle.getMessage(AttachWindowAction.class, (String)string2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
            ModeImpl modeImpl = windowManagerImpl.getActiveMode();
            if (modeImpl == null) {
                return;
            }
            TopComponent topComponent = modeImpl.getSelectedTopComponent();
            if (topComponent == null || !this.mode.canContain(topComponent)) {
                return;
            }
            if (this.side == null) {
                this.mode.dockInto(topComponent);
                topComponent.open();
                topComponent.requestActive();
            } else {
                windowManagerImpl.attachTopComponentToSide(topComponent, this.mode, this.side);
            }
        }
    }

    private static class ModeMenu
    extends JMenu {
        public ModeMenu(ModeImpl modeImpl, String string, boolean bl) {
            super(string);
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (modeImpl.canContain(topComponent)) {
                if (!bl) {
                    this.add(new AttachAction(modeImpl, null));
                    this.add(new JSeparator());
                }
                this.add(new AttachAction(modeImpl, "top"));
                this.add(new AttachAction(modeImpl, "left"));
                this.add(new AttachAction(modeImpl, "bottom"));
                this.add(new AttachAction(modeImpl, "right"));
            } else {
                this.setEnabled(false);
            }
        }
    }

    private static class LazyPopup
    extends JMenuPlus
    implements PropertyChangeListener {
        private boolean created = false;

        public LazyPopup(Action action) {
            this.setText((String)action.getValue("Name"));
            action.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action));
        }

        public JPopupMenu getPopupMenu() {
            if (!this.created) {
                this.createMenuItems();
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.created = true;
            this.removeAll();
            ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
            if (modeImpl != null) {
                this.add(new ModeMenu(modeImpl, NbBundle.getMessage(AttachWindowAction.class, (String)"CTL_Documents"), true));
                this.add(new JSeparator());
            }
            Set<? extends ModeImpl> set = WindowManagerImpl.getInstance().getModes();
            for (ModeImpl modeImpl2 : set) {
                TopComponent topComponent;
                if ("editor".equals(modeImpl2.getName()) || modeImpl2.getOpenedTopComponents().isEmpty() || (topComponent = modeImpl2.getSelectedTopComponent()) == null) continue;
                String string = topComponent.getName();
                this.add(new ModeMenu(modeImpl2, string == null ? "null" : string, false));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("Name".equals(propertyChangeEvent.getPropertyName())) {
                this.setText((String)propertyChangeEvent.getNewValue());
            } else if (AttachWindowAction.PROP_ACTION_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
                this.created = false;
            }
        }
    }
}

