/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.editor.options.ScrollInsetsEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class ScrollInsetsCustomEditor
extends JPanel
implements DocumentListener {
    static final long serialVersionUID = -1472891501739636852L;
    private ScrollInsetsEditor editor;
    private PropertyEnv env;
    private JTextField bottomField;
    private JLabel bottomLabel;
    private JPanel jPanel2;
    private JTextField leftField;
    private JLabel leftLabel;
    private JTextField rightField;
    private JLabel rightLabel;
    private JTextField topField;
    private JLabel topLabel;

    public ScrollInsetsCustomEditor(ScrollInsetsEditor scrollInsetsEditor, PropertyEnv propertyEnv) {
        this.initComponents();
        this.editor = scrollInsetsEditor;
        this.env = propertyEnv;
        Insets insets = (Insets)scrollInsetsEditor.getValue();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE"));
        this.topLabel.setDisplayedMnemonic(this.getBundleString("SICE_Top_Mnemonic").charAt(0));
        this.bottomLabel.setDisplayedMnemonic(this.getBundleString("SICE_Bottom_Mnemonic").charAt(0));
        this.leftLabel.setDisplayedMnemonic(this.getBundleString("SICE_Left_Mnemonic").charAt(0));
        this.rightLabel.setDisplayedMnemonic(this.getBundleString("SICE_Right_Mnemonic").charAt(0));
        this.topField.setText(ScrollInsetsCustomEditor.int2percent(insets.top));
        this.leftField.setText(ScrollInsetsCustomEditor.int2percent(insets.left));
        this.bottomField.setText(ScrollInsetsCustomEditor.int2percent(insets.bottom));
        this.rightField.setText(ScrollInsetsCustomEditor.int2percent(insets.right));
        this.topField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Top"));
        this.leftField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Left"));
        this.bottomField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Bottom"));
        this.rightField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Right"));
        this.setPreferredSize(new Dimension(320, this.getPreferredSize().height));
        this.env.setState(PropertyEnv.STATE_VALID);
        this.topField.getDocument().addDocumentListener(this);
        this.leftField.getDocument().addDocumentListener(this);
        this.bottomField.getDocument().addDocumentListener(this);
        this.rightField.getDocument().addDocumentListener(this);
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage(ScrollInsetsCustomEditor.class, (String)string);
    }

    public static String int2percent(int n) {
        if (n < 0) {
            return "" + -n + "%";
        }
        return "" + n;
    }

    private int percent2int(String string) throws NumberFormatException {
        if ((string = string.trim()).endsWith("%")) {
            return -Math.abs(Integer.parseInt(string.substring(0, string.length() - 1)));
        }
        return Integer.parseInt(string);
    }

    Insets getValue() throws NumberFormatException {
        int n = this.percent2int(this.topField.getText());
        int n2 = this.percent2int(this.leftField.getText());
        int n3 = this.percent2int(this.bottomField.getText());
        int n4 = this.percent2int(this.rightField.getText());
        return new Insets(n, n2, n3, n4);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.topLabel = new JLabel();
        this.topField = new JTextField();
        this.leftLabel = new JLabel();
        this.leftField = new JTextField();
        this.bottomLabel = new JLabel();
        this.bottomField = new JTextField();
        this.rightLabel = new JLabel();
        this.rightField = new JTextField();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.topLabel.setLabelFor(this.topField);
        this.topLabel.setText(this.getBundleString("SICE_Top"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.jPanel2.add((Component)this.topLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.topField, gridBagConstraints);
        this.leftLabel.setLabelFor(this.leftField);
        this.leftLabel.setText(this.getBundleString("SICE_Left"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.jPanel2.add((Component)this.leftLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.leftField, gridBagConstraints);
        this.bottomLabel.setLabelFor(this.bottomField);
        this.bottomLabel.setText(this.getBundleString("SICE_Bottom"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.jPanel2.add((Component)this.bottomLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.bottomField, gridBagConstraints);
        this.rightLabel.setLabelFor(this.rightField);
        this.rightLabel.setText(this.getBundleString("SICE_Right"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.jPanel2.add((Component)this.rightLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.rightField, gridBagConstraints);
        this.add(this.jPanel2);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateInsets();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateInsets();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateInsets();
    }

    private void updateInsets() {
        try {
            this.editor.setValue(this.getValue());
            this.env.setState(PropertyEnv.STATE_VALID);
        }
        catch (NumberFormatException numberFormatException) {
            this.env.setState(PropertyEnv.STATE_INVALID);
        }
    }
}

