/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.palette.actions.CreateReportElementAction;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CreateImageAction
extends CreateReportElementAction {
    public JRDesignElement createReportElement(JasperDesign jd) {
        JrxmlVisualView view;
        FileObject obj;
        File f;
        File parent = new File(IReportManager.getInstance().getCurrentDirectory());
        if (IReportManager.getInstance().getActiveVisualView() != null && (f = FileUtil.toFile((FileObject)(obj = (view = IReportManager.getInstance().getActiveVisualView()).getEditorSupport().getDataObject().getPrimaryFile()))) != null && f.getParentFile().exists()) {
            parent = f.getParentFile();
        }
        final JFileChooser jfc = new JFileChooser(parent);
        jfc.setDialogTitle("Select an image file....");
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".gif") || file.isDirectory();
            }

            public String getDescription() {
                return "Image *.gif|*.jpg";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        final JRDesignImage element = new JRDesignImage((JRDefaultStyleProvider)jd);
        element.setWidth(100);
        element.setHeight(50);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(null) == 0) {
            element.setExpression((JRExpression)Misc.createExpression("java.lang.String", "\"" + Misc.string_replace("\\\\", "\\", jfc.getSelectedFile().getPath() + "\"")));
            IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile().getParent(), true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ImageIcon image = new ImageIcon(jfc.getSelectedFile().getPath());
                        element.setWidth(image.getIconWidth());
                        element.setHeight(image.getIconHeight());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return element;
    }
}

