/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;

public class AddTableColumnDDL {
    private Specification spec;
    private DriverSpecification drvSpec;
    private String schema;
    private String tablename;
    private Map indexMap;
    private Map uniqueIndexMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AddTableColumnDDL(Specification specification, DriverSpecification driverSpecification, String string, String string2) {
        this.spec = specification;
        this.drvSpec = driverSpecification;
        this.schema = string;
        this.tablename = string2;
    }

    public Map getIndexMap() throws DatabaseException {
        if (this.indexMap == null) {
            this.buildIndexMaps();
        }
        return this.indexMap;
    }

    public Map getUniqueIndexMap() throws DatabaseException {
        if (this.uniqueIndexMap == null) {
            this.buildIndexMaps();
        }
        return this.uniqueIndexMap;
    }

    private void buildIndexMaps() throws DatabaseException {
        try {
            this.drvSpec.getIndexInfo(this.tablename, false, true);
            ResultSet resultSet = this.drvSpec.getResultSet();
            HashMap hashMap = new HashMap();
            this.indexMap = new HashMap();
            this.uniqueIndexMap = new HashMap();
            while (resultSet.next()) {
                hashMap = this.drvSpec.getRow();
                String string = (String)hashMap.get(new Integer(6));
                if (string != null) {
                    Vector<String> vector = (Vector<String>)this.indexMap.get(string);
                    if (vector == null) {
                        boolean bl;
                        vector = new Vector<String>();
                        this.indexMap.put(string, vector);
                        boolean bl2 = bl = Boolean.valueOf((String)hashMap.get(new Integer(4))) == false;
                        if (bl) {
                            this.uniqueIndexMap.put(string, "unique");
                        }
                    }
                    vector.add((String)hashMap.get(new Integer(9)));
                }
                hashMap.clear();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = new DatabaseException(sQLException.getMessage());
            databaseException.initCause(sQLException);
            throw databaseException;
        }
    }

    private boolean useIndex(ColumnItem columnItem) {
        return columnItem.isIndexed() && !columnItem.isUnique() && !columnItem.isPrimaryKey();
    }

    public boolean execute(String string, ColumnItem columnItem, String string2) throws Exception {
        if (!$assertionsDisabled && columnItem == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.useIndex(columnItem) && string2 != null || !this.useIndex(columnItem))) {
            throw new AssertionError();
        }
        CommandBuffer commandBuffer = new CommandBuffer();
        AddColumn addColumn = this.spec.createCommandAddColumn(this.tablename);
        addColumn.setObjectOwner(this.schema);
        TableColumn tableColumn = null;
        tableColumn = columnItem.isPrimaryKey() ? addColumn.createPrimaryKeyColumn(string) : (columnItem.isUnique() ? addColumn.createUniqueColumn(string) : (TableColumn)addColumn.createColumn(string));
        tableColumn.setColumnType(Specification.getType(columnItem.getType().getType()));
        tableColumn.setColumnSize(columnItem.getSize());
        tableColumn.setDecimalSize(columnItem.getScale());
        tableColumn.setNullAllowed(columnItem.allowsNull());
        if (columnItem.hasDefaultValue()) {
            tableColumn.setDefaultValue(columnItem.getDefaultValue());
        }
        if (columnItem.hasCheckConstraint()) {
            tableColumn.setCheckCondition(columnItem.getCheckConstraint());
        }
        commandBuffer.add(addColumn);
        if (this.useIndex(columnItem)) {
            if (!$assertionsDisabled && string2 == null) {
                throw new AssertionError();
            }
            this.addIndex(commandBuffer, columnItem, string2);
        }
        commandBuffer.execute();
        return commandBuffer.wasException();
    }

    private void addIndex(CommandBuffer commandBuffer, ColumnItem columnItem, String string) throws Exception {
        AbstractCommand abstractCommand;
        this.buildIndexMaps();
        String string2 = new String();
        if (this.indexMap.containsKey(string)) {
            if (this.uniqueIndexMap.containsKey(string)) {
                string2 = "unique";
            }
            abstractCommand = this.spec.createCommandDropIndex(string);
            ((DropIndex)abstractCommand).setTableName(this.tablename);
            abstractCommand.setObjectOwner(this.schema);
            commandBuffer.add(abstractCommand);
        }
        abstractCommand = this.spec.createCommandCreateIndex(this.tablename);
        ((CreateIndex)abstractCommand).setIndexName(string);
        ((CreateIndex)abstractCommand).setIndexType(string2);
        abstractCommand.setObjectOwner(this.schema);
        Enumeration enumeration = ((Vector)this.indexMap.get(string)).elements();
        while (enumeration.hasMoreElements()) {
            ((CreateIndex)abstractCommand).specifyColumn((String)enumeration.nextElement());
        }
        ((CreateIndex)abstractCommand).specifyNewColumn(columnItem.getName());
        commandBuffer.add(abstractCommand);
    }

    static {
        $assertionsDisabled = !AddTableColumnDDL.class.desiredAssertionStatus();
    }
}

