/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynaMenuModel {
    private static final Icon BLANK_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/empty.gif"));
    private List<JComponent> menuItems;
    private HashMap<DynamicMenuContent, JComponent[]> actionToMenuMap = new HashMap();
    private boolean isWithIcons = false;

    /*
     * WARNING - void declaration
     */
    public void loadSubmenu(List list, JMenu jMenu) {
        boolean bl = false;
        Object var4_4 = null;
        Iterator iterator = list.iterator();
        this.menuItems = new ArrayList<JComponent>(list.size());
        this.actionToMenuMap.clear();
        while (iterator.hasNext()) {
            Actions.MenuItem menuItem;
            Object object;
            void object3;
            Object e = iterator.next();
            if (e instanceof Presenter.Menu) {
                JMenuItem jMenuItem = ((Presenter.Menu)e).getMenuPresenter();
            }
            if (object3 instanceof DynamicMenuContent) {
                if (bl) {
                    this.menuItems.add(null);
                    bl = false;
                }
                object = (DynamicMenuContent)object3;
                menuItem = this.convertArray(object.getMenuPresenters());
                this.actionToMenuMap.put((DynamicMenuContent)object, (JComponent[])menuItem);
                for (JComponent jComponent : Arrays.asList(menuItem)) {
                    this.menuItems.add(jComponent);
                    this.isWithIcons = this.checkIcon(jComponent, this.isWithIcons);
                }
                continue;
            }
            if (object3 instanceof JMenuItem) {
                if (bl) {
                    this.menuItems.add(null);
                    bl = false;
                }
                this.isWithIcons = this.checkIcon(object3, this.isWithIcons);
                this.menuItems.add((JMenuItem)object3);
                continue;
            }
            if (object3 instanceof JSeparator) {
                bl = this.menuItems.size() > 0;
                continue;
            }
            if (!(object3 instanceof Action)) continue;
            if (bl) {
                this.menuItems.add(null);
                bl = false;
            }
            object = (Action)object3;
            menuItem = new Actions.MenuItem((Action)object, true);
            this.isWithIcons = this.checkIcon(menuItem, this.isWithIcons);
            this.actionToMenuMap.put((DynamicMenuContent)menuItem, new JComponent[]{menuItem});
            this.menuItems.add((JComponent)menuItem);
        }
        if (this.isWithIcons) {
            this.menuItems = this.alignVertically(this.menuItems);
        }
        Object var6_9 = null;
        boolean bl2 = false;
        for (JComponent jComponent : this.menuItems) {
            void var6_13;
            if (jComponent == null) {
                JSeparator jSeparator = DynaMenuModel.createSeparator();
            }
            jMenu.add((Component)var6_13);
            boolean bl3 = var6_13 instanceof JSeparator;
            if (bl3 && bl2) {
                var6_13.setVisible(false);
            }
            if (var6_13 instanceof InvisibleMenuItem) continue;
            bl2 = bl3;
        }
    }

    private boolean checkIcon(Object object, boolean bl) {
        if (bl) {
            return bl;
        }
        return object instanceof JMenuItem && ((JMenuItem)object).getIcon() != null && !BLANK_ICON.equals(((JMenuItem)object).getIcon());
    }

    public void checkSubmenu(JMenu jMenu) {
        boolean bl = this.isWithIcons;
        boolean bl2 = false;
        for (Map.Entry<DynamicMenuContent, JComponent[]> componentArray2 : this.actionToMenuMap.entrySet()) {
            int n;
            int n2;
            DynamicMenuContent i = componentArray2.getKey();
            JComponent[] jComponentArray = componentArray2.getValue();
            boolean bl3 = false;
            Component[] componentArray = jMenu.getPopupMenu().getComponents();
            int n3 = n2 = jComponentArray.length > 0 ? this.findFirstItemIndex(jComponentArray[0], componentArray) : -1;
            JComponent[] jComponentArray2 = this.convertArray(i.synchMenuPresenters(this.unconvertArray(jComponentArray)));
            if (this.compareEqualArrays(jComponentArray, jComponentArray2)) continue;
            if (n2 < 0) {
                n2 = 0;
            } else {
                for (n = 0; n < jComponentArray.length; ++n) {
                    if (jComponentArray[n] == null) continue;
                    jMenu.getPopupMenu().remove(jComponentArray[n]);
                    this.menuItems.remove(jComponentArray[n]);
                }
            }
            for (n = 0; n < jComponentArray2.length; ++n) {
                JComponent jComponent = jComponentArray2[n];
                jMenu.getPopupMenu().add((Component)jComponent, n + n2);
                bl2 = true;
                this.menuItems.add(jComponent);
                boolean bl4 = this.checkIcon(jComponent, false);
                if (!bl4 && this.isWithIcons) {
                    this.alignVertically(Collections.singletonList(jComponent));
                }
                if (!bl4 || this.isWithIcons) continue;
                this.isWithIcons = true;
            }
            componentArray2.setValue(jComponentArray2);
        }
        boolean bl5 = false;
        Component[] componentArray = jMenu.getPopupMenu().getComponents();
        for (int i = 0; !(i >= componentArray.length || componentArray[i] != null && (bl5 = this.checkIcon(componentArray[i], bl5))); ++i) {
        }
        DynaMenuModel.checkSeparators(componentArray, jMenu.getPopupMenu());
        if (!bl5 && this.isWithIcons) {
            this.isWithIcons = false;
        }
        if (bl != this.isWithIcons) {
            this.menuItems = this.alignVertically(this.menuItems);
        }
        if (bl2 && Utilities.isWindows()) {
            jMenu.getPopupMenu().revalidate();
        }
    }

    static void checkSeparators(Component[] componentArray, JPopupMenu jPopupMenu) {
        boolean bl = false;
        for (int i = 0; i < componentArray.length; ++i) {
            boolean bl2;
            Component component = componentArray[i];
            if (component == null) continue;
            boolean bl3 = component instanceof JSeparator;
            if (bl3 && (bl2 = component.isVisible()) != !bl) {
                jPopupMenu.remove(i);
                JSeparator jSeparator = DynaMenuModel.createSeparator();
                jSeparator.setVisible(!bl);
                jPopupMenu.add((Component)jSeparator, i);
            }
            if (component instanceof InvisibleMenuItem) continue;
            bl = bl3;
        }
    }

    private JComponent[] convertArray(JComponent[] jComponentArray) {
        if (jComponentArray == null || jComponentArray.length == 0) {
            return new JComponent[]{new InvisibleMenuItem()};
        }
        JComponent[] jComponentArray2 = new JComponent[jComponentArray.length];
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray2[i] = jComponentArray[i] == null ? DynaMenuModel.createSeparator() : jComponentArray[i];
        }
        return jComponentArray2;
    }

    private JComponent[] unconvertArray(JComponent[] jComponentArray) {
        if (jComponentArray.length == 1 && jComponentArray[0] instanceof InvisibleMenuItem) {
            return new JComponent[0];
        }
        return jComponentArray;
    }

    private int findFirstItemIndex(JComponent jComponent, Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (jComponent != componentArray[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean compareEqualArrays(JComponent[] jComponentArray, JComponent[] jComponentArray2) {
        if (jComponentArray.length != jComponentArray2.length) {
            return false;
        }
        for (int i = 0; i < jComponentArray.length; ++i) {
            if (jComponentArray[i] == jComponentArray2[i]) continue;
            return false;
        }
        return true;
    }

    private List<JComponent> alignVertically(List<JComponent> list) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(list.size());
        JMenuItem jMenuItem = null;
        for (JComponent jComponent : list) {
            if (jComponent instanceof JMenuItem) {
                jMenuItem = (JMenuItem)jComponent;
                if (this.isWithIcons && jMenuItem != null && jMenuItem.getIcon() == null) {
                    jMenuItem.setIcon(BLANK_ICON);
                } else if (!this.isWithIcons && jMenuItem != null) {
                    jMenuItem.setIcon(null);
                }
            }
            arrayList.add(jComponent);
        }
        return arrayList;
    }

    private static JSeparator createSeparator() {
        JMenu jMenu = new JMenu();
        jMenu.addSeparator();
        return (JSeparator)jMenu.getPopupMenu().getComponent(0);
    }

    static final class InvisibleMenuItem
    extends JMenuItem {
        InvisibleMenuItem() {
        }

        public boolean isVisible() {
            return false;
        }
    }
}

