/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;

public final class RoundedBorder
implements Border {
    private int arcWidth;
    private int arcHeight;
    private int insetWidth;
    private int insetHeight;
    private Color fillColor;
    private Color drawColor;

    public RoundedBorder(int n, int n2, int n3, int n4, Color color, Color color2) {
        this.arcWidth = n;
        this.arcHeight = n2;
        this.insetWidth = n3;
        this.insetHeight = n4;
        this.fillColor = color;
        this.drawColor = color2;
    }

    public Insets getInsets() {
        return new Insets(this.insetHeight, this.insetWidth, this.insetHeight, this.insetWidth);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.fillColor != null) {
            graphics2D.setColor(this.fillColor);
            graphics2D.fill(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.arcWidth, this.arcHeight));
        }
        if (this.drawColor != null) {
            graphics2D.setColor(this.drawColor);
            graphics2D.draw(new RoundRectangle2D.Float((float)rectangle.x + 0.5f, (float)rectangle.y + 0.5f, rectangle.width - 1, rectangle.height - 1, this.arcWidth, this.arcHeight));
        }
    }

    public boolean isOpaque() {
        return false;
    }
}

