/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.formatting.actions.AbstractFormattingToolAction;
import com.jaspersoft.ireport.designer.formatting.actions.AlignMarginTopAction;
import com.jaspersoft.ireport.designer.formatting.actions.IncreaseHSpaceAction;
import com.jaspersoft.ireport.designer.formatting.actions.SameHeightMinAction;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class OrganizeAsTableAction
extends AbstractFormattingToolAction {
    public OrganizeAsTableAction() {
        this.putValue("Name", this.getName());
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 3));
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/organize.png";
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        JasperDesign jd = (JasperDesign)nodes[0].getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        List<JRDesignElement> elements = this.getSelectedElements(nodes);
        IReportManager.getInstance().setForceAggregateUndo(true);
        ((AlignMarginTopAction)SystemAction.get(AlignMarginTopAction.class)).performAction(nodes);
        int currentX = 0;
        for (JRDesignElement element : elements) {
            Rectangle oldBounds = this.getElementBounds(element);
            element.setX(currentX);
            currentX += element.getWidth();
            this.addTransformationUndo(element, oldBounds, true);
        }
        ((SameHeightMinAction)SystemAction.get(SameHeightMinAction.class)).performAction(nodes);
        ((IncreaseHSpaceAction)SystemAction.get(IncreaseHSpaceAction.class)).performAction(nodes);
        IReportManager.getInstance().setForceAggregateUndo(false);
    }

    public String getName() {
        return I18n.getString("formatting.tools.organizeAsTable");
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem item = super.getPopupPresenter();
        item.setIcon(this.getIcon());
        return item;
    }
}

