/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DeleteBandUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignBand band = null;
    private JasperDesign jasperDesign = null;

    public DeleteBandUndoableEdit(JRDesignBand band, JasperDesign jasperDesign) {
        this.band = band;
        this.jasperDesign = jasperDesign;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        JROrigin origin = this.getBand().getOrigin();
        if (origin != null) {
            switch (origin.getBandType()) {
                case 1: {
                    this.jasperDesign.setBackground((JRBand)this.band);
                    break;
                }
                case 2: {
                    this.jasperDesign.setTitle((JRBand)this.band);
                    break;
                }
                case 3: {
                    this.jasperDesign.setPageHeader((JRBand)this.band);
                    break;
                }
                case 4: {
                    this.jasperDesign.setColumnHeader((JRBand)this.band);
                    break;
                }
                case 6: {
                    this.jasperDesign.setDetail((JRBand)this.band);
                    break;
                }
                case 8: {
                    this.jasperDesign.setColumnFooter((JRBand)this.band);
                    break;
                }
                case 9: {
                    this.jasperDesign.setPageFooter((JRBand)this.band);
                    break;
                }
                case 10: {
                    this.jasperDesign.setLastPageFooter((JRBand)this.band);
                    break;
                }
                case 11: {
                    this.jasperDesign.setSummary((JRBand)this.band);
                    break;
                }
                case 12: {
                    this.jasperDesign.setNoData((JRBand)this.band);
                    break;
                }
                case 5: {
                    ((JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName())).setGroupHeader((JRBand)this.band);
                    break;
                }
                case 7: {
                    ((JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName())).setGroupFooter((JRBand)this.band);
                }
            }
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        JROrigin origin = this.getBand().getOrigin();
        if (origin != null) {
            switch (origin.getBandType()) {
                case 1: {
                    this.jasperDesign.setBackground(null);
                    break;
                }
                case 2: {
                    this.jasperDesign.setTitle(null);
                    break;
                }
                case 3: {
                    this.jasperDesign.setPageHeader(null);
                    break;
                }
                case 4: {
                    this.jasperDesign.setColumnHeader(null);
                    break;
                }
                case 6: {
                    this.jasperDesign.setDetail(null);
                    break;
                }
                case 8: {
                    this.jasperDesign.setColumnFooter(null);
                    break;
                }
                case 9: {
                    this.jasperDesign.setPageFooter(null);
                    break;
                }
                case 10: {
                    this.jasperDesign.setLastPageFooter(null);
                    break;
                }
                case 11: {
                    this.jasperDesign.setSummary(null);
                    break;
                }
                case 12: {
                    this.jasperDesign.setNoData(null);
                    break;
                }
                case 5: {
                    ((JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName())).setGroupHeader(null);
                    break;
                }
                case 7: {
                    ((JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName())).setGroupFooter(null);
                }
            }
        }
    }

    public String getPresentationName() {
        return "Delete Band " + ModelUtils.nameOf(this.getBand().getOrigin());
    }

    public JRDesignBand getBand() {
        return this.band;
    }

    public void setBand(JRDesignBand band) {
        this.band = band;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }
}

