/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.utils.ExpressionInterpreter;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.FileResolver;

public class ImageExpressionFileResolver
implements FileResolver {
    private JRDesignImage imageElement = null;
    private JRDesignExpression imageExpression = null;
    private JasperDesign jasperDesign = null;
    private String reportFolder = null;
    private File file = null;
    private boolean resolveFile = true;

    public ImageExpressionFileResolver(JRDesignImage imageElement, String reportFolder, JasperDesign jd) {
        this.imageElement = imageElement;
        this.imageExpression = (JRDesignExpression)imageElement.getExpression();
        this.reportFolder = reportFolder;
        this.jasperDesign = jd;
    }

    public File resolveFile(String arg0) {
        if (this.resolveFile) {
            if (this.imageElement.getExpression() == null || this.imageElement.getExpression().getValueClassName() == null || !this.imageElement.getExpression().getValueClassName().equals("java.lang.String")) {
                return null;
            }
            JRDesignDataset dataset = ModelUtils.getElementDataset((JRDesignElement)this.imageElement, this.jasperDesign);
            ClassLoader classLoader = IReportManager.getReportClassLoader();
            try {
                ExpressionInterpreter interpreter = new ExpressionInterpreter(dataset, classLoader);
                Object ret = interpreter.interpretExpression(this.imageElement.getExpression().getText());
                System.out.println("Resolved: " + ret);
                if (ret != null) {
                    String resourceName = ret + "";
                    File f = new File(resourceName);
                    if (!f.exists()) {
                        URLClassLoader urlClassLoader;
                        URL url;
                        URL[] urls = new URL[]{};
                        if (this.reportFolder != null) {
                            urls = new URL[]{new File(this.reportFolder).toURI().toURL()};
                        }
                        if ((url = (urlClassLoader = new URLClassLoader(urls, classLoader)).findResource(resourceName)) != null && (f = new File(url.getPath())).exists()) {
                            this.file = f;
                        }
                    } else {
                        this.file = f;
                    }
                    this.resolveFile = false;
                }
            }
            catch (Exception ex) {
                this.resolveFile = false;
                ex.printStackTrace();
            }
        }
        return this.getFile();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JRDesignImage getImageElement() {
        return this.imageElement;
    }

    public void setImageElement(JRDesignImage imageElement) {
        if (this.imageElement != imageElement || this.imageExpression != imageElement.getExpression()) {
            this.imageElement = imageElement;
            this.imageExpression = (JRDesignExpression)imageElement.getExpression();
            this.file = null;
            this.resolveFile = true;
        }
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        if (this.jasperDesign != jasperDesign) {
            this.jasperDesign = jasperDesign;
            this.file = null;
            this.resolveFile = true;
        }
    }

    public String getReportFolder() {
        return this.reportFolder;
    }

    public void setReportFolder(String reportFolder) {
        if (reportFolder == null && this.reportFolder == null) {
            return;
        }
        if (reportFolder != null && this.reportFolder == null || reportFolder == null && this.reportFolder != null || !reportFolder.equals(this.reportFolder)) {
            this.reportFolder = reportFolder;
            this.file = null;
            this.resolveFile = true;
        }
    }
}

