/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SpecialSearchGroup;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openidex.search.SearchType;

public final class ResultModel {
    private static final int COUNT_LIMIT = 500;
    private static final int DETAILS_COUNT_LIMIT = 5000;
    private final long creationTime;
    private int size = 0;
    private int totalDetailsCount = 0;
    private ResultTreeModel treeModel;
    private ResultView resultView;
    private boolean limitReached = false;
    private SpecialSearchGroup searchGroup;
    final boolean isBasicCriteriaOnly;
    final BasicSearchCriteria basicCriteria;
    private final boolean isFullText;
    final String replaceString;
    final boolean searchAndReplace;
    final List<MatchingObject> matchingObjects = new ArrayList<MatchingObject>();
    private final Set<MatchingObject> matchingObjectsSet = new HashSet<MatchingObject>(40);
    private String finishMessage;
    private MatchingObject infoCacheMatchingObject;
    private Boolean infoCacheHasDetails;
    private int infoCacheDetailsCount;
    private Node[] infoCacheDetailNodes;
    private final Node[] EMPTY_NODES_ARRAY = new Node[0];

    ResultModel(SpecialSearchGroup specialSearchGroup, String string) {
        this.searchGroup = specialSearchGroup;
        this.replaceString = string;
        this.searchAndReplace = string != null;
        this.basicCriteria = specialSearchGroup.basicCriteria;
        this.isFullText = this.basicCriteria != null && this.basicCriteria.isFullText();
        this.isBasicCriteriaOnly = specialSearchGroup.getSearchTypes().length == 0;
        this.creationTime = System.currentTimeMillis();
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setObserver(ResultTreeModel resultTreeModel) {
        this.treeModel = resultTreeModel;
    }

    void setObserver(ResultView resultView) {
        this.resultView = resultView;
    }

    void close() {
        if (this.matchingObjects != null && !this.matchingObjects.isEmpty()) {
            for (MatchingObject matchingObject : this.matchingObjects) {
                matchingObject.cleanup();
            }
        }
        this.searchGroup = null;
    }

    synchronized boolean objectFound(Object object) {
        MatchingObject matchingObject = new MatchingObject(this, object);
        if (!this.matchingObjectsSet.add(matchingObject)) {
            return true;
        }
        this.matchingObjects.add(matchingObject);
        assert (!this.limitReached);
        assert (this.treeModel != null);
        assert (this.resultView != null);
        this.totalDetailsCount += this.getDetailsCount(matchingObject);
        this.treeModel.objectFound(matchingObject, this.size++);
        this.resultView.objectFound(matchingObject, this.totalDetailsCount);
        return this.size < 500 && this.totalDetailsCount < 5000;
    }

    void objectBecameInvalid(MatchingObject matchingObject) {
        int n = this.matchingObjects.indexOf(matchingObject);
        assert (n != -1);
        this.treeModel.objectBecameInvalid(matchingObject);
    }

    synchronized int getTotalDetailsCount() {
        return this.totalDetailsCount;
    }

    synchronized MatchingObject[] getMatchingObjects() {
        return this.matchingObjects.toArray(new MatchingObject[this.matchingObjects.size()]);
    }

    synchronized Object[] getFoundObjects() {
        Object[] objectArray = new Object[this.matchingObjects.size()];
        int n = 0;
        for (MatchingObject matchingObject : this.matchingObjects) {
            objectArray[n++] = matchingObject.object;
        }
        return objectArray;
    }

    public void run() {
    }

    boolean hasDetails() {
        return this.totalDetailsCount != 0;
    }

    Boolean canHaveDetails() {
        Boolean bl = this.isFullText ? Boolean.TRUE : (this.isBasicCriteriaOnly ? Boolean.FALSE : null);
        return bl;
    }

    private void prepareCacheFor(MatchingObject matchingObject) {
        if (matchingObject != this.infoCacheMatchingObject) {
            this.infoCacheHasDetails = null;
            this.infoCacheDetailsCount = -1;
            this.infoCacheDetailNodes = null;
            this.infoCacheMatchingObject = matchingObject;
        }
    }

    boolean hasDetails(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheHasDetails != null) {
            return this.infoCacheHasDetails;
        }
        boolean bl = this.hasDetailsReal(matchingObject);
        this.infoCacheHasDetails = bl;
        assert (this.infoCacheHasDetails == Boolean.TRUE || this.infoCacheHasDetails == Boolean.FALSE);
        return bl;
    }

    private boolean hasDetailsReal(MatchingObject matchingObject) {
        boolean bl;
        if (this.isFullText) {
            bl = true;
        } else if (this.isBasicCriteriaOnly) {
            bl = false;
        } else {
            bl = false;
            Object object = matchingObject.object;
            for (SearchType searchType : this.searchGroup.getSearchTypes()) {
                Node[] nodeArray = searchType.getDetails(object);
                if (nodeArray == null || nodeArray.length == 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    int getDetailsCount(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailsCount == -1) {
            this.infoCacheDetailsCount = this.getDetailsCountReal(matchingObject);
            if (this.infoCacheDetailsCount == 0) {
                this.infoCacheDetailNodes = this.EMPTY_NODES_ARRAY;
            }
        }
        assert (this.infoCacheDetailsCount >= 0);
        return this.infoCacheDetailsCount;
    }

    private int getDetailsCountReal(MatchingObject matchingObject) {
        int n;
        int n2 = n = this.isFullText ? this.basicCriteria.getDetailsCount(matchingObject.object) : 0;
        if (this.isBasicCriteriaOnly) {
            return n;
        }
        Object object = matchingObject.object;
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            Node[] nodeArray = searchType.getDetails(object);
            n += nodeArray != null ? nodeArray.length : 0;
        }
        return n;
    }

    Node[] getDetails(MatchingObject matchingObject) {
        Node[] nodeArray;
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailNodes == null) {
            nodeArray = this.getDetailsReal(matchingObject);
            this.infoCacheDetailNodes = nodeArray != null ? nodeArray : this.EMPTY_NODES_ARRAY;
            this.infoCacheDetailsCount = this.infoCacheDetailNodes.length;
        } else {
            Node[] nodeArray2 = nodeArray = this.infoCacheDetailNodes != this.EMPTY_NODES_ARRAY ? this.infoCacheDetailNodes : null;
        }
        assert (this.infoCacheDetailNodes != null && (this.infoCacheDetailNodes == this.EMPTY_NODES_ARRAY || this.infoCacheDetailNodes.length > 0));
        assert (nodeArray == null || nodeArray.length > 0);
        return nodeArray;
    }

    private Node[] getDetailsReal(MatchingObject matchingObject) {
        Node[] nodeArray = null;
        if (this.basicCriteria != null) {
            Node[] nodeArray2 = nodeArray = this.basicCriteria.isFullText() ? this.basicCriteria.getDetails(matchingObject.object) : null;
        }
        if (this.isBasicCriteriaOnly) {
            return nodeArray;
        }
        Object object = matchingObject.object;
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            Node[] nodeArray3 = searchType.getDetails(object);
            if (nodeArray3 == null || nodeArray3.length == 0) continue;
            if (nodeArray == null) {
                nodeArray = nodeArray3;
                continue;
            }
            Node[] nodeArray4 = nodeArray;
            nodeArray = new Node[nodeArray.length + nodeArray3.length];
            System.arraycopy(nodeArray4, 0, nodeArray, 0, nodeArray4.length);
            System.arraycopy(nodeArray3, 0, nodeArray, nodeArray4.length, nodeArray3.length);
        }
        return nodeArray;
    }

    synchronized int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    SpecialSearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    SearchType[] getQueriedSearchTypes() {
        return this.searchGroup.getSearchTypes();
    }

    boolean wasLimitReached() {
        return this.limitReached;
    }

    void searchException(RuntimeException runtimeException) {
        ErrorManager.Annotation[] annotationArray = ErrorManager.getDefault().findAnnotations((Throwable)runtimeException);
        for (int i = 0; i < annotationArray.length; ++i) {
            ErrorManager.Annotation annotation = annotationArray[i];
            if (annotation.getSeverity() != 256) continue;
            this.finishMessage = annotation.getLocalizedMessage();
            if (this.finishMessage == null) continue;
            return;
        }
        this.finishMessage = runtimeException.getLocalizedMessage();
    }

    String getExceptionMsg() {
        return this.finishMessage;
    }
}

