/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.CategoryButton;
import org.netbeans.modules.palette.ui.CategoryList;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.openide.util.Utilities;

class CategoryDescriptor
implements CategoryListener {
    private PalettePanel palettePanel;
    private Category category;
    private JPanel wholePanel;
    private CategoryButton categoryButton;
    private CategoryList itemsList;
    private DefaultListModel itemsListModel;
    private boolean opened;
    private boolean resetItems = true;
    private Settings settings;

    CategoryDescriptor(PalettePanel palettePanel, Category category) {
        assert (palettePanel != null) : "No palette panel";
        assert (category != null) : "No category node";
        this.palettePanel = palettePanel;
        this.category = category;
        this.settings = palettePanel.getSettings();
        this.wholePanel = new JPanel(){

            public void addNotify() {
                super.addNotify();
                CategoryDescriptor.this.category.addCategoryListener(CategoryDescriptor.this);
            }

            public void removeNotify() {
                super.removeNotify();
                CategoryDescriptor.this.category.removeCategoryListener(CategoryDescriptor.this);
            }
        };
        this.wholePanel.setLayout(new GridBagLayout());
        this.wholePanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        MouseListener mouseListener = this.createMouseListener();
        this.categoryButton = new CategoryButton(this, category);
        this.categoryButton.addMouseListener(mouseListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(1, 0, 0, 0), 0, 0);
        this.wholePanel.add((Component)this.categoryButton, gridBagConstraints);
        this.itemsList = new CategoryList(category, palettePanel);
        this.itemsListModel = new DefaultListModel();
        this.itemsList.setModel(this.itemsListModel);
        this.itemsList.setShowNames(palettePanel.getSettings().getShowItemNames());
        this.itemsList.setIconSize(palettePanel.getSettings().getIconSize());
        this.itemsList.addMouseListener(mouseListener);
        this.itemsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CategoryDescriptor.this.palettePanel.select(CategoryDescriptor.this.category, (Item)CategoryDescriptor.this.itemsList.getSelectedValue());
            }
        });
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.wholePanel.add((Component)this.itemsList, gridBagConstraints);
        this.wholePanel.setFocusTraversalPolicy(new MyFocusTraversal(this));
        this.doSetOpened(this.settings.isExpanded(category));
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    Serializable serializable;
                    Action[] actionArray;
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    Item item = null;
                    if (jComponent instanceof JList) {
                        actionArray = (Action[])jComponent;
                        serializable = mouseEvent.getPoint();
                        int n = actionArray.locationToIndex((Point)serializable);
                        if (n >= 0 && !actionArray.getCellBounds(n, n).contains((Point)serializable)) {
                            n = -1;
                        }
                        if (n >= 0) {
                            item = (Item)actionArray.getModel().getElementAt(n);
                        }
                    }
                    actionArray = null == item ? CategoryDescriptor.this.category.getActions() : item.getActions();
                    serializable = Utilities.actionsToPopup((Action[])actionArray, (Component)CategoryDescriptor.this.getComponent());
                    Utils.addCustomizationMenuItems((JPopupMenu)serializable, CategoryDescriptor.this.getPalettePanel().getController(), CategoryDescriptor.this.getPalettePanel().getSettings());
                    ((JPopupMenu)serializable).show(jComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
    }

    void refresh() {
        this.categoryButton.updateProperties();
        this.categoryButton.repaint();
        if (this.isOpened() && this.resetItems) {
            this.computeItems();
        }
    }

    void computeItems() {
        DefaultListModel<Item> defaultListModel = new DefaultListModel<Item>();
        Item[] itemArray = this.category.getItems();
        if (itemArray != null) {
            for (int i = 0; i < itemArray.length; ++i) {
                if (!this.settings.isVisible(itemArray[i])) continue;
                defaultListModel.addElement(itemArray[i]);
            }
        }
        this.itemsListModel = defaultListModel;
        this.itemsList.setModel(defaultListModel);
        this.resetItems = false;
    }

    void resetItems() {
        this.resetItems = true;
    }

    Category getCategory() {
        return this.category;
    }

    boolean isOpened() {
        return this.opened;
    }

    boolean isSelected() {
        return this.categoryButton.isFocusOwner() || this.itemsList.getSelectedIndex() >= 0;
    }

    void setSelectedItem(Item item) {
        if (this.itemsList.getSelectedValue() == item) {
            return;
        }
        if (item == null) {
            int n = this.itemsList.getSelectedIndex();
            this.itemsList.removeSelectionInterval(n, n);
        } else {
            this.itemsList.setSelectedValue(item, true);
        }
    }

    void setOpened(boolean bl) {
        if (this.opened == bl) {
            return;
        }
        this.doSetOpened(bl);
        this.settings.setExpanded(this.category, bl);
    }

    private void doSetOpened(boolean bl) {
        this.opened = bl;
        if (this.opened) {
            if (this.resetItems) {
                this.computeItems();
            }
        } else {
            this.palettePanel.select(this.category, null);
        }
        this.itemsList.setVisible(this.opened);
        this.categoryButton.setSelected(this.opened);
        if (this.opened) {
            this.itemsList.ensureIndexIsVisible(0);
        }
    }

    void setPositionY(int n) {
        this.wholePanel.setLocation(0, n);
    }

    JComponent getComponent() {
        return this.wholePanel;
    }

    int getPreferredHeight(int n) {
        return this.isOpened() ? this.itemsList.getPreferredHeight(n) + this.categoryButton.getPreferredSize().height : this.categoryButton.getPreferredSize().height;
    }

    void setWidth(int n) {
        this.wholePanel.setSize(n, this.wholePanel.getHeight());
    }

    void setShowNames(boolean bl) {
        this.itemsList.setShowNames(bl);
    }

    void setIconSize(int n) {
        this.itemsList.setIconSize(n);
    }

    void setItemWidth(int n) {
        this.itemsList.setFixedCellWidth(n);
    }

    PalettePanel getPalettePanel() {
        return this.palettePanel;
    }

    public void categoryModified(Category category) {
        this.resetItems();
        this.palettePanel.refresh();
    }

    CategoryList getList() {
        return this.itemsList;
    }

    CategoryButton getButton() {
        return this.categoryButton;
    }

    private static class MyFocusTraversal
    extends FocusTraversalPolicy {
        private CategoryDescriptor descriptor;

        public MyFocusTraversal(CategoryDescriptor categoryDescriptor) {
            this.descriptor = categoryDescriptor;
        }

        public Component getComponentBefore(Container container, Component component) {
            if (container == this.descriptor.wholePanel && component == this.descriptor.categoryButton) {
                return this.descriptor.itemsList;
            }
            return null;
        }

        public Component getComponentAfter(Container container, Component component) {
            if (container == this.descriptor.wholePanel && component == this.descriptor.itemsList) {
                return this.descriptor.categoryButton;
            }
            return null;
        }

        public Component getLastComponent(Container container) {
            if (container == this.descriptor.wholePanel) {
                return this.descriptor.itemsList;
            }
            return null;
        }

        public Component getFirstComponent(Container container) {
            if (container == this.descriptor.wholePanel) {
                return this.descriptor.categoryButton;
            }
            return null;
        }

        public Component getDefaultComponent(Container container) {
            return this.getFirstComponent(container);
        }
    }
}

