/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components;

import java.io.IOException;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.digester.Digester;

public class ComponentsXmlHandler
implements XmlDigesterConfigurer,
ComponentXmlWriter {
    public void configureDigester(Digester digester) {
        String listPattern = "*/componentElement/list";
        digester.addObjectCreate(listPattern, StandardListComponent.class);
        String listContentsPattern = listPattern + "/listContents";
        digester.addObjectCreate(listContentsPattern, DesignListContents.class);
        digester.addSetProperties(listContentsPattern);
        digester.addSetNext(listContentsPattern, "setContents");
    }

    public void writeToXml(ComponentKey componentKey, Component component, JRXmlWriter reportWriter) throws IOException {
        ListComponent list = (ListComponent)component;
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("list", namespace);
        reportWriter.writeDatasetRun(list.getDatasetRun());
        ListContents contents = list.getContents();
        writer.startElement("listContents");
        writer.addAttribute("height", contents.getHeight());
        reportWriter.writeChildElements(contents);
        writer.closeElement();
        writer.closeElement();
    }
}

