/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common;

import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.Credential;
import org.sdg.xdman.core.common.IXDMConstants;
import org.sdg.xdman.gui.StringResource;

public abstract class Connection
implements Runnable,
IXDMConstants {
    protected Credential credential;
    public long read;
    public long clen;
    public String content_type;
    public String content_disposition;
    public String url;
    public String fileName;
    protected volatile long length = -1L;
    protected volatile long contentLength;
    protected volatile long downloaded = 0L;
    protected volatile long startOff;
    public int status;
    protected boolean stop = false;
    protected ConnectionManager mgr;
    protected Object lock;
    protected boolean pause = false;
    protected String lastError = null;
    protected InputStream in;
    public RandomAccessFile out;
    protected byte[] buf = new byte[8192];
    protected Thread t;
    protected String message;
    public float rate;
    public long time;
    long oldRead;

    public State getState() {
        return new State(this.status, this.fileName, this.length, this.contentLength, this.downloaded, this.startOff, this.url);
    }

    public void setState(State t) {
        this.status = t.stat;
        this.fileName = t.fileName;
        this.length = t.length;
        this.contentLength = t.contentLength;
        this.downloaded = t.downloaded;
        this.startOff = t.startOff;
        this.url = t.url;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    public long getStartOff() {
        return this.startOff;
    }

    public void setStartOff(long startOff) {
        this.startOff = startOff;
    }

    protected Connection(String url, String fileName, long startOff, long length, long contentLength, ConnectionManager mgr, Object lock) {
        this.url = url;
        this.fileName = fileName;
        this.length = length;
        this.contentLength = contentLength;
        this.mgr = mgr;
        this.startOff = startOff;
        this.lock = lock;
    }

    protected Connection(State state, int timeout, ConnectionManager mgr, Object lock) {
        this.setState(state);
        this.mgr = mgr;
        this.lock = lock;
        this.stop = false;
        this.pause = false;
    }

    public abstract boolean connect();

    @Override
    public void run() {
        while (!this.download()) {
            if (this.stop) {
                this.close();
                break;
            }
            this.chkPause();
            if (!this.connect()) {
                this.close();
                return;
            }
            if (this.stop) {
                this.close();
                break;
            }
            this.chkPause();
        }
    }

    public abstract void close();

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        this.stop = true;
        this.t.interrupt();
        this.message = StringResource.getString("DISCONNECT");
    }

    public void pause() {
        this.pause = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chkPause() {
        if (!this.pause) {
            return;
        }
        try {
            this.msg("Pausing...");
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
            this.msg("Resuming...");
        }
        catch (Exception e) {
            this.msg(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pause = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download() {
        this.read = 0L;
        this.msg("To download: " + this.length);
        if (this.stop) {
            this.close();
            this.msg("Returning because STOP");
            return true;
        }
        this.chkPause();
        if (this.status != 20) {
            this.msg("Returning because NOT DOWNLOADING");
            return false;
        }
        if (this.in == null) {
            this.msg("Returning because IN IS NULL");
            return false;
        }
        try {
            this.msg("Init download...");
            this.msg("Opening file: " + this.fileName);
            this.out = new RandomAccessFile(this.fileName, "rw");
            this.out.seek(this.downloaded);
            while (true) {
                int len;
                int x;
                if (this.stop) {
                    this.close();
                    return true;
                }
                this.message = StringResource.getString("DOWNLOADING");
                this.mgr.updated();
                this.chkPause();
                if (this.length > -1L && this.downloaded >= this.length) {
                    if (this.downloaded > this.length) {
                        this.read = 0L;
                    }
                    this.msg("Download complete before: " + this.downloaded + " / " + this.length);
                    this.msg("Going to call downloadComplete()...");
                    this.status = 50;
                    if (this.mgr.donwloadComplete(this)) {
                        this.msg("called downloadComplete()");
                        this.message = StringResource.getString("DOWNLOAD_COMPLETE");
                        this.close();
                        return true;
                    }
                    this.status = 20;
                    this.msg("called downloadComplete()...");
                    this.msg("Download complete after: " + this.downloaded + " / " + this.length);
                }
                if ((x = (len = (int)(this.length - this.downloaded)) < this.buf.length && len > 0 ? this.in.read(this.buf, 0, len) : this.in.read(this.buf, 0, this.buf.length)) != -1) {
                    this.read += (long)x;
                }
                if (this.stop) {
                    this.close();
                    return true;
                }
                this.chkPause();
                if (x == -1) {
                    if (this.length <= -1L) {
                        this.status = 50;
                        this.mgr.donwloadComplete(this);
                        return true;
                    }
                    if (this.downloaded >= this.length) {
                        this.status = 50;
                        this.mgr.donwloadComplete(this);
                        this.close();
                        return true;
                    }
                    throw new Exception("Unexpected End Of Stream: " + this.downloaded + " / " + this.length);
                }
                this.chkPause();
                this.out.write(this.buf, 0, x);
                this.downloaded += (long)x;
                long currentTime = System.currentTimeMillis();
                long tdiff = currentTime - this.time;
                long diff = this.read - this.oldRead;
                if ((int)(tdiff / 1000L) > 0) {
                    this.rate = (float)diff / (float)tdiff * 1000.0f;
                    this.oldRead = this.read;
                    this.time = currentTime;
                }
                if (this.stop) {
                    this.close();
                    return true;
                }
                this.message = StringResource.getString("DOWNLOADING");
                this.chkPause();
                this.mgr.updated();
                this.mgr.saveDownload();
            }
        }
        catch (Exception e) {
            if (this.length < 0L) {
                this.close();
                return true;
            }
            this.msg(e);
            e.printStackTrace();
            if (this.stop) {
                this.close();
                return true;
            }
            this.chkPause();
            this.close();
            return false;
        }
    }

    public abstract boolean isEOF();

    public void msg(Object o) {
        System.out.println(String.valueOf(this.startOff) + " :  " + o.toString());
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 4156081526363598564L;
        int stat;
        String fileName;
        String url;
        long length;
        long contentLength;
        long downloaded;
        long startOff;

        public State(int stat, String fileName, long length, long contentLength, long downloaded, long startOff, String url) {
            this.stat = stat;
            this.fileName = fileName;
            this.length = length;
            this.contentLength = contentLength;
            this.downloaded = downloaded;
            this.startOff = startOff;
            this.url = url;
        }
    }
}

