/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.gui.BatchItem;
import org.sdg.xdman.gui.BatchTableModel;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMFileChooser;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMTableHeaderRenderer;
import org.sdg.xdman.util.XDMUtil;

public class BatchDownloadDlg
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -4717157093775786226L;
    BatchTableModel model;
    JTable table;
    JTextField dir;
    JButton browse;
    JButton ok;
    JButton cancel;
    JButton checkAll;
    JButton uncheckAll;
    JCheckBox startQ;
    DownloadStateListner listener;

    public BatchDownloadDlg() {
        this.setSize(600, 300);
        this.setTitle(StringResource.getString("LIST_TTL"));
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        this.add((Component)new JLabel(StringResource.getString("LIST_LBL")), "North");
        this.dir = new JTextField();
        this.browse = new JButton("...");
        this.browse.addActionListener(this);
        this.ok = new JButton(StringResource.getString("MSG_BOX_OK"));
        this.ok.addActionListener(this);
        this.cancel = new JButton(StringResource.getString("CANCEL"));
        this.cancel.addActionListener(this);
        this.checkAll = new JButton(StringResource.getString("LIST_LBL1"));
        this.checkAll.addActionListener(this);
        this.uncheckAll = new JButton(StringResource.getString("LIST_LBL2"));
        this.uncheckAll.addActionListener(this);
        this.startQ = new JCheckBox(StringResource.getString("LIST_LBL3"));
        this.startQ.addActionListener(this);
        this.model = new BatchTableModel();
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(0);
        this.table.setShowGrid(false);
        if (System.getProperty("xdm.defaulttheme") != null) {
            this.table.getTableHeader().setDefaultRenderer(new XDMTableHeaderRenderer());
        }
        this.table.setFillsViewportHeight(true);
        TableColumnModel cm = this.table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            if (c.getHeaderValue().equals("#")) {
                c.setPreferredWidth(20);
            } else {
                c.setPreferredWidth(200);
            }
            ++i;
        }
        JScrollPane jsp = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add(jsp);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = BatchDownloadDlg.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                int c = BatchDownloadDlg.this.table.getSelectedColumn();
                if (c != 0) {
                    return;
                }
                BatchItem item = BatchDownloadDlg.this.model.batchList.get(index);
                item.selected = !item.selected;
                BatchDownloadDlg.this.model.fireTableRowsUpdated(index, index);
            }
        });
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel(StringResource.getString("SAVE_IN")));
        b1.add(Box.createRigidArea(new Dimension(5, 5)));
        this.dir.setMaximumSize(new Dimension(this.dir.getMaximumSize().width, this.dir.getPreferredSize().height));
        b1.add(this.dir);
        b1.add(Box.createRigidArea(new Dimension(5, 5)));
        b1.add(this.browse);
        box.add(b1);
        b1.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box b2 = Box.createHorizontalBox();
        b2.add(this.checkAll);
        this.checkAll.setPreferredSize(this.uncheckAll.getPreferredSize());
        b2.add(Box.createRigidArea(new Dimension(5, 5)));
        b2.add(this.uncheckAll);
        b2.add(Box.createRigidArea(new Dimension(5, 5)));
        b2.add(this.startQ);
        b2.add(Box.createHorizontalGlue());
        b2.add(this.ok);
        this.ok.setPreferredSize(this.cancel.getPreferredSize());
        b2.add(Box.createRigidArea(new Dimension(5, 5)));
        b2.add(this.cancel);
        box.add(b2);
        b2.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)box, "South");
    }

    public void showDialog(List<BatchItem> list, String folder, DownloadStateListner listener) {
        try {
            this.listener = listener;
            this.model.batchList.clear();
            this.dir.setText(folder);
            int i = 0;
            while (i < list.size()) {
                this.model.batchList.add(list.get(i));
                ++i;
            }
            this.model.fireTableDataChanged();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showDialog(String folder, DownloadStateListner listener) {
        this.listener = listener;
        this.model.batchList.clear();
        this.dir.setText(folder);
        try {
            Object obj = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            String txt = "";
            int count = 0;
            if (obj == null) {
                JOptionPane.showMessageDialog(this, StringResource.getString("LIST_MSG"));
                return;
            }
            txt = obj.toString();
            if (txt.length() > 0) {
                String[] urls = txt.split("\n");
                int i = 0;
                while (i < urls.length) {
                    BatchItem item = new BatchItem();
                    String url = urls[i];
                    if (XDMUtil.validateURL(url)) {
                        ++count;
                        item.url = url;
                        item.dir = this.dir.getText();
                        item.fileName = XDMUtil.getFileName(url);
                        this.model.batchList.add(item);
                    }
                    ++i;
                }
            }
            if (count < 1) {
                JOptionPane.showMessageDialog(this, StringResource.getString("LIST_MSG"));
                return;
            }
            this.model.fireTableDataChanged();
            this.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, StringResource.getString("LIST_MSG"));
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc;
        if (e.getSource() == this.browse && (fc = XDMFileChooser.getFileChooser(1, null)).showSaveDialog(this) == 0) {
            this.dir.setText(fc.getSelectedFile().getAbsolutePath());
            int i = 0;
            while (i < this.model.batchList.size()) {
                this.model.batchList.get((int)i).dir = this.dir.getText();
                ++i;
            }
            this.model.fireTableDataChanged();
        }
        if (e.getSource() == this.checkAll) {
            int i = 0;
            while (i < this.model.batchList.size()) {
                this.model.batchList.get((int)i).selected = true;
                ++i;
            }
            this.model.fireTableDataChanged();
        }
        if (e.getSource() == this.uncheckAll) {
            int i = 0;
            while (i < this.model.batchList.size()) {
                this.model.batchList.get((int)i).selected = false;
                ++i;
            }
            this.model.fireTableDataChanged();
        }
        if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
        if (e.getSource() == this.ok) {
            int i = 0;
            while (i < this.model.batchList.size()) {
                BatchItem item = this.model.batchList.get(i);
                if (item.selected) {
                    this.listener.add2Queue(item.url, item.fileName, item.dir, item.user, item.pass, null, null, null, this.startQ.isSelected());
                }
                ++i;
            }
            this.listener.startQueue();
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        new BatchDownloadDlg().showDialog(System.getProperty("user.home"), null);
    }
}

