/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.util.XDMUtil;

public class MainTableModel
extends AbstractTableModel {
    DownloadList list = null;
    Icon q;
    private static final long serialVersionUID = -8936395745120671317L;
    final String[] cols = new String[]{"", this.getString("FILE_NAME"), this.getString("Q"), this.getString("SIZE"), this.getString("STATUS"), this.getString("TIME_LEFT"), this.getString("TRANSFER_RATE"), this.getString("LAST_TRY"), this.getString("DESCRIPTION"), this.getString("DATE_ADDED"), this.getString("SAVE_TO"), this.getString("URL"), this.getString("REFERER")};

    public void setList(DownloadList list) {
        this.list = list;
        this.fireTableDataChanged();
    }

    void setType(String type) {
        this.list.setType(type);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.cols[col];
    }

    @Override
    public int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        DownloadListItem item = this.list.get(row);
        switch (col) {
            case 0: {
                return item.icon == null ? new ImageIcon() : item.icon;
            }
            case 1: {
                return XDMUtil.nvl(item.filename);
            }
            case 2: {
                return item.q ? "Yes" : "";
            }
            case 3: {
                return XDMUtil.nvl(item.size);
            }
            case 4: {
                return XDMUtil.nvl(item.status);
            }
            case 5: {
                return XDMUtil.nvl(item.timeleft);
            }
            case 6: {
                return XDMUtil.nvl(item.transferrate);
            }
            case 7: {
                return XDMUtil.nvl(item.lasttry);
            }
            case 8: {
                return XDMUtil.nvl(item.description);
            }
            case 9: {
                return XDMUtil.nvl(item.dateadded);
            }
            case 10: {
                return XDMUtil.nvl(item.saveto);
            }
            case 11: {
                return XDMUtil.nvl(item.url);
            }
            case 12: {
                return XDMUtil.nvl(item.referer);
            }
        }
        return "";
    }

    public void updateItem(DownloadInfo info) {
        DownloadListItem item = this.list.getByID(info.id);
        if (item == null) {
            return;
        }
        item.updateData(info);
        int index = this.list.getIndex(item);
        if (index < 0) {
            return;
        }
        this.fireTableRowsUpdated(index, index);
    }

    String getString(String id) {
        return StringResource.getString(id);
    }
}

