/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.AboutDialog;
import org.sdg.xdman.gui.AssembleDialog;
import org.sdg.xdman.gui.BatchDlg;
import org.sdg.xdman.gui.BatchDownloadDlg;
import org.sdg.xdman.gui.BatchDownloadListener;
import org.sdg.xdman.gui.BatchItem;
import org.sdg.xdman.gui.BrowserIntDlg;
import org.sdg.xdman.gui.ConfigDialog;
import org.sdg.xdman.gui.DownloadCompleteDialog;
import org.sdg.xdman.gui.DownloadFileInfoDialog;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.DownloadWindow;
import org.sdg.xdman.gui.DropBox;
import org.sdg.xdman.gui.FileTransferHandler;
import org.sdg.xdman.gui.HelpDialog;
import org.sdg.xdman.gui.IconUtil;
import org.sdg.xdman.gui.MainTableModel;
import org.sdg.xdman.gui.MediaGrabberWindow;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.gui.PropertiesDialog;
import org.sdg.xdman.gui.RefreshLinkDlg;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.TableSortInfo;
import org.sdg.xdman.gui.XDMBlankIcon;
import org.sdg.xdman.gui.XDMButtonUI;
import org.sdg.xdman.gui.XDMFileChooser;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMLookAndFeel;
import org.sdg.xdman.gui.XDMTableHeaderRenderer;
import org.sdg.xdman.gui.XDMToolBarButtonUI;
import org.sdg.xdman.gui.XDMTreeCellRenderer;
import org.sdg.xdman.gui.XDMTreeNode;
import org.sdg.xdman.gui.YoutubeGrabberDlg;
import org.sdg.xdman.interceptor.DownloadIntercepterInfo;
import org.sdg.xdman.interceptor.IMediaGrabber;
import org.sdg.xdman.interceptor.XDMServer;
import org.sdg.xdman.util.LinuxUtil;
import org.sdg.xdman.util.Logger;
import org.sdg.xdman.util.XDMUtil;

public class XDMMainWindow
extends JFrame
implements TreeSelectionListener,
ActionListener,
DownloadStateListner,
BatchDownloadListener,
IMediaGrabber {
    private static final long serialVersionUID = -5562142092210683635L;
    String state;
    String type;
    int windowState;
    JPanel toolbar;
    JButton addurl;
    JButton resume;
    JButton pause;
    JButton delete;
    JButton option;
    JButton youtube;
    JButton media;
    JButton exit;
    JLabel closetree;
    JSplitPane split;
    JTree tree;
    JTable table;
    MainTableModel model = new MainTableModel();
    static DownloadList list = null;
    static String tempdir = null;
    static String destdir = null;
    static String appdir = null;
    static XDMConfig config;
    Toolkit t;
    JPopupMenu pop;
    JSplitPane content;
    XDMToolBarButtonUI toolBtnUI;
    JMenuBar bar;
    XDMButtonUI btnUI;
    ConfigDialog configDlg;
    BatchDlg batchDlg;
    BatchDownloadDlg listDlg;
    MediaGrabberWindow mediaDlg;
    MediaTableModel mediaModel;
    YoutubeGrabberDlg ytDlg;
    JPopupMenu ctxPopup;
    BrowserIntDlg biDlg;
    JLabel lbl;
    Timer timer;
    AboutDialog abtDlg;
    boolean processQueue;
    DownloadListItem qi;
    boolean schedulerActive;
    AssembleDialog asmDlg;
    Clipboard clipboard;
    DropBox w;
    Thread st;
    int hotcount = 0;
    boolean hot = false;
    static HashMap<String, String> arg;

    static {
        arg = new HashMap();
    }

    public XDMMainWindow() {
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        list = new DownloadList(appdir);
        this.model.setList(list);
        this.setTitle(this.getString("TITLE"));
        this.content = new JSplitPane(1);
        this.content.setBorder(new EmptyBorder(2, 5, 5, 5));
        this.content.setDividerSize(2);
        this.content.setDividerLocation(150);
        System.out.println(XDMMainWindow.config.dbY);
        if (XDMMainWindow.config.mwW <= 0) {
            this.t = Toolkit.getDefaultToolkit();
            Dimension d = this.t.getScreenSize();
            int w = 700;
            int h = 400;
            if (d.width < w) {
                w = d.width;
            }
            if (d.height < h) {
                h = d.height;
            }
            this.setSize(w, h);
            this.setLocationRelativeTo(null);
        } else {
            this.setSize(XDMMainWindow.config.mwW, XDMMainWindow.config.mwH);
            this.setLocation(XDMMainWindow.config.mwX, XDMMainWindow.config.mwY);
        }
        this.toolBtnUI = new XDMToolBarButtonUI();
        this.createToolbar();
        this.createMenu();
        this.createTable();
        this.createTree();
        this.add(this.content);
        if (XDMMainWindow.config.destdir == null) {
            XDMMainWindow.config.destdir = destdir;
        }
        if (XDMMainWindow.config.tempdir == null) {
            XDMMainWindow.config.tempdir = tempdir;
        }
        this.createTray();
    }

    int getDupAction(String url) {
        JTextField txt = new JTextField(url);
        String lbl = StringResource.getString("DUP_TXT");
        JComboBox<String> choice = new JComboBox<String>(new String[]{StringResource.getString("DUP_OP1"), StringResource.getString("DUP_OP2"), StringResource.getString("DUP_OP3")});
        JCheckBox chk = new JCheckBox(StringResource.getString("DUP_CHK"));
        int ret = JOptionPane.showOptionDialog(null, new Object[]{txt, lbl, choice, chk}, StringResource.getString("DUP_TITLE"), 2, 3, null, null, null);
        if (ret == 0) {
            int index = choice.getSelectedIndex();
            if (chk.isSelected()) {
                XDMMainWindow.config.duplicateLinkAction = index;
            }
            return index;
        }
        return -1;
    }

    void showMessageBox(String msg, String title, int msgType) {
        JOptionPane.showMessageDialog(this, msg, title, msgType);
    }

    void removeDownloads() {
        DownloadListItem item;
        int[] indexes = this.table.getSelectedRows();
        if (indexes.length < 1) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem[] items = new DownloadListItem[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            item = list.get(indexes[i]);
            if (item.mgr != null) {
                this.showMessageBox(this.getString("DWN_ACTIVE"), this.getString("DEFAULT_TITLE"), 0);
                return;
            }
            items[i] = item;
            ++i;
        }
        i = 0;
        while (i < indexes.length) {
            item = items[i];
            String tmpdir = item.tempdir;
            list.remove(item);
            if (!XDMUtil.isNullOrEmpty(tmpdir)) {
                this.delDirRec(tmpdir);
            }
            ++i;
        }
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    void delDirRec(String dir) {
        File fdir = new File(dir);
        File[] files = fdir.listFiles();
        if (files == null) {
            fdir.delete();
        } else {
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
            fdir.delete();
        }
    }

    private void resumeDownload() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem item = list.get(index);
        if (item == null) {
            return;
        }
        this.resumeDownload(item);
    }

    void resumeDownload(DownloadListItem item) {
        if (item.mgr != null) {
            this.showMessageBox(this.getString("DWN_ACTIVE"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (item.state == 50) {
            this.showMessageBox(this.getString("DWN_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (item.tempdir == null || item.tempdir.length() < 1) {
            this.startDownload(item.url, item.filename, item.saveto, null, null, item.userAgent, item.referer, item.cookies, item, true);
        } else {
            DownloadWindow dw;
            ConnectionManager mgr = new ConnectionManager(item.id, item.url, item.filename, item.saveto, item.tempdir, item.userAgent, item.referer, item.cookies, config);
            if (!XDMUtil.isNullOrEmpty(item.user) && !XDMUtil.isNullOrEmpty(item.pass)) {
                mgr.setCredential(item.user, item.pass);
            }
            item.mgr = mgr;
            this.model.fireTableDataChanged();
            list.downloadStateChanged();
            item.window = dw = new DownloadWindow(mgr);
            if (XDMMainWindow.config.showDownloadPrgDlg && this.qi != item) {
                dw.showWindow();
            }
            mgr.setProgressListener(dw);
            mgr.dwnListener = this;
            try {
                mgr.resume();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void restartDownload() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem item = list.get(index);
        if (item == null) {
            return;
        }
        this.restartDownload(item);
    }

    void restartDownload(DownloadListItem item) {
        if (item.mgr != null) {
            this.showMessageBox(this.getString("DWN_ACTIVE"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        this.startDownload(item.url, item.filename, item.saveto, null, null, item.userAgent, item.referer, item.cookies, item, true);
    }

    private void pauseDownload() {
        int[] indexes = this.table.getSelectedRows();
        int i = 0;
        while (i < indexes.length) {
            DownloadListItem item = list.get(indexes[i]);
            if (item.mgr != null) {
                item.mgr.stop();
            }
            ++i;
        }
    }

    void addDownload() {
        DownloadFileInfoDialog fdlg = new DownloadFileInfoDialog(this, config);
        fdlg.setDir(XDMMainWindow.config.destdir);
        fdlg.showDlg();
    }

    synchronized void startDownload(String url, String name, String folder, String user, String pass, String userAgent, String referer, ArrayList<String> cookies, DownloadListItem item, boolean overriteExisting) {
        DownloadWindow dw;
        UUID id = UUID.randomUUID();
        ConnectionManager mgr = new ConnectionManager(id, url, name, folder, XDMMainWindow.config.tempdir, userAgent, referer, cookies, config);
        mgr.overwrite = overriteExisting;
        if (item == null) {
            item = new DownloadListItem();
            list.add(item);
        }
        if (!XDMUtil.isNullOrEmpty(user) && !XDMUtil.isNullOrEmpty(pass)) {
            mgr.setCredential(user, pass);
            item.user = user;
            item.pass = pass;
        }
        item.mgr = mgr;
        item.filename = name;
        item.url = url;
        item.q = false;
        item.dateadded = item.lasttry = new Date().toString();
        item.id = id;
        item.saveto = folder;
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.userAgent = userAgent;
        item.referer = referer;
        if (cookies != null) {
            item.cookies = new ArrayList();
            item.cookies.addAll(cookies);
        }
        item.state = 10;
        item.type = XDMUtil.findCategory(name);
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
        item.window = dw = new DownloadWindow(mgr);
        if (XDMMainWindow.config.showDownloadPrgDlg && this.qi != item) {
            dw.showWindow();
        }
        mgr.setProgressListener(dw);
        mgr.dwnListener = this;
        try {
            mgr.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void add2Queue(String url, String name, String folder, String user, String pass, String referer, ArrayList<String> cookies, String userAgent, boolean q) {
        UUID id = UUID.randomUUID();
        DownloadListItem item = new DownloadListItem();
        list.add(item);
        item.user = user;
        item.pass = pass;
        item.filename = name;
        item.url = url;
        item.q = q;
        item.dateadded = item.lasttry = new Date().toString();
        item.id = id;
        item.saveto = folder;
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.userAgent = userAgent;
        item.referer = referer;
        if (cookies != null) {
            item.cookies.addAll(cookies);
        }
        item.state = 40;
        item.status = "Stopped";
        item.type = XDMUtil.findCategory(name);
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    @Override
    public void configChanged() {
        if (XDMMainWindow.config.schedule) {
            if (this.schedulerActive) {
                Logger.log("Scheduler is active");
                return;
            }
            this.st = new Thread(new Runnable(){

                @Override
                public void run() {
                    XDMMainWindow.this.schedulerRun();
                }
            });
            this.st.start();
        }
    }

    @Override
    public void downloadComplete(UUID id) {
        DownloadListItem item = list.getByID(id);
        if (item == null) {
            return;
        }
        item.window = null;
        item.status = "Download Complete";
        item.timeleft = "";
        item.state = 50;
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
        if (this.qi == item) {
            this.qi = null;
            if (this.processQueue && this.processNextQueuedDownload()) {
                return;
            }
        }
        if (XDMMainWindow.config.halt) {
            this.executeCommands();
        } else if (XDMMainWindow.config.showDownloadCompleteDlg) {
            DownloadCompleteDialog cdlg = new DownloadCompleteDialog(config);
            cdlg.setData(item.filename, item.saveto);
            cdlg.setLocationRelativeTo(null);
            cdlg.setVisible(true);
        }
    }

    @Override
    public void downloadConfirmed(UUID id, Object data) {
        DownloadListItem item = list.getByID(id);
        ConnectionManager mgr = item.mgr;
        item.tempdir = mgr.getTempdir();
        item.url = mgr.getUrl();
        item.filename = mgr.getFileName();
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.updateData((DownloadInfo)data);
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    @Override
    public void downloadFailed(UUID id) {
        System.out.println("Download failed");
        list.downloadStateChanged();
        DownloadListItem item = list.getByID(id);
        if (item == null) {
            return;
        }
        item.window = null;
        if (this.qi == item) {
            this.qi = null;
            if (this.processQueue) {
                this.processNextQueuedDownload();
            } else {
                System.out.println("Queue stopped");
            }
        } else {
            System.out.println("Not queued");
        }
    }

    @Override
    public void downloadNow(String url, String name, String folder, String user, String pass, String referer, ArrayList<String> cookies, String userAgent) {
        boolean overwrite = false;
        int i = 0;
        while (i < XDMMainWindow.list.list.size()) {
            DownloadListItem item = XDMMainWindow.list.list.get(i);
            if (url.equals(item.url)) {
                int action = XDMMainWindow.config.duplicateLinkAction;
                if (action == 3) {
                    action = this.getDupAction(url);
                }
                if (action == -1) {
                    return;
                }
                if (action == 2) {
                    if (item.state == 50) {
                        File file = new File(item.saveto, item.filename);
                        if (file.exists()) {
                            XDMUtil.open(file.getParentFile());
                        } else if (item.mgr == null) {
                            this.restartDownload(item);
                        } else {
                            this.showMessageBox(this.getString("DWN_ACTIVE"), "Message", 0);
                        }
                    } else if (item.mgr == null) {
                        this.resumeDownload(item);
                    } else {
                        this.showMessageBox(this.getString("DWN_ACTIVE"), "Message", 0);
                    }
                    return;
                }
                overwrite = action == 1;
                break;
            }
            ++i;
        }
        this.startDownload(url, name, folder, user, pass, userAgent, referer, cookies, null, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadPaused(UUID id) {
        XDMMainWindow xDMMainWindow = this;
        synchronized (xDMMainWindow) {
            DownloadListItem item = list.getByID(id);
            if (item == null) {
                return;
            }
            item.window = null;
            item.mgr = null;
            item.status = "Stopped";
            item.state = 40;
            int index = list.getIndex(item);
            if (index < 0) {
                return;
            }
            this.model.fireTableCellUpdated(index, index);
            list.downloadStateChanged();
            if (this.qi == item) {
                this.qi = null;
                if (this.processQueue) {
                    if (JOptionPane.showConfirmDialog(this, this.getString("CONTINUE_Q"), this.getString("DEFAULT_TITLE"), 0, 3) == 0) {
                        this.processNextQueuedDownload();
                    } else {
                        this.processQueue = false;
                        this.qi = null;
                    }
                } else {
                    this.qi = null;
                }
            }
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void getCredentials(ConnectionManager mgr, String host) {
    }

    @Override
    public void interceptDownload(DownloadIntercepterInfo info) {
        this.addDownload(info.url, XDMUtil.getFileName(info.url), XDMMainWindow.config.destdir, null, null, info.referer, info.cookies, info.ua);
    }

    @Override
    public void restoreWindow() {
        System.out.println("RESTORE");
        this.setVisible(true);
    }

    @Override
    public void startQueue() {
        if (this.processQueue) {
            this.showMessageBox(this.getString("Q_STARTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (this.qi != null) {
            return;
        }
        this.processQueue = true;
        this.processNextQueuedDownload();
    }

    @Override
    public void stopQueue() {
        this.processQueue = false;
        if (this.qi == null) {
            return;
        }
        if (this.qi.mgr != null) {
            this.qi.mgr.stop();
            this.qi = null;
        } else {
            this.qi = null;
        }
    }

    @Override
    public void updateManager(UUID id, Object data) {
        DownloadListItem item = list.getByID(id);
        if (item == null) {
            return;
        }
        DownloadInfo info = (DownloadInfo)data;
        item.updateData(info);
        int index = list.getIndex(item);
        if (index >= 0) {
            this.model.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void ytCallback(String yturl) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        String status = null;
        int state = 0;
        Object[] o = e.getPath().getPath();
        int i = 0;
        while (i < o.length) {
            XDMTreeNode node = (XDMTreeNode)o[i];
            if (node.id.equals("TREE_UNFINISHED")) {
                state = 1;
            }
            if (node.id.equals("TREE_FINISHED")) {
                state = 50;
            }
            if (node.id.equals("TREE_DOCUMENTS")) {
                status = "Documents";
            }
            if (node.id.equals("TREE_COMPRESSED")) {
                status = "Compressed";
            }
            if (node.id.equals("TREE_MUSIC")) {
                status = "Music";
            }
            if (node.id.equals("TREE_PROGRAMS")) {
                status = "Programs";
            }
            if (node.id.equals("TREE_VIDEOS")) {
                status = "Video";
            }
            list.setState(state);
            list.setType(status);
            this.model.fireTableDataChanged();
            ++i;
        }
    }

    void createTable() {
        this.table = new JTable(this.model);
        JScrollPane jsp = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.content.add((Component)jsp, "right");
        if (System.getProperty("xdm.defaulttheme") != null) {
            jsp.setCorner("UPPER_RIGHT_CORNER", new XDMTableHeaderRenderer());
            int rh = this.table.getRowHeight();
            if (rh > 0) {
                this.table.setRowHeight(rh + 5);
            }
            this.table.getTableHeader().setDefaultRenderer(new XDMTableHeaderRenderer());
        }
        this.table.setShowGrid(false);
        this.table.setTransferHandler(new FileTransferHandler(list, this));
        this.table.setDragEnabled(true);
        this.table.setAutoResizeMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            if (c.getHeaderValue().equals("")) {
                c.setPreferredWidth(20);
            } else if (c.getHeaderValue().equals(this.getString("FILE_NAME"))) {
                c.setPreferredWidth(200);
            } else if (c.getHeaderValue().equals(this.getString("Q"))) {
                c.setPreferredWidth(50);
            } else {
                c.setPreferredWidth(100);
            }
            ++i;
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 3) {
                    if (XDMMainWindow.this.ctxPopup == null) {
                        XDMMainWindow.this.createContextMenu();
                    }
                    XDMMainWindow.this.ctxPopup.show(XDMMainWindow.this.table, me.getX(), me.getY());
                }
            }
        });
    }

    void createTree() {
        JLabel header = null;
        if (System.getProperty("xdm.defaulttheme") != null) {
            header = new XDMTableHeaderRenderer();
        } else {
            header = new JLabel();
            header.setOpaque(true);
            header.setBackground(Color.DARK_GRAY);
            header.setForeground(Color.WHITE);
        }
        header.setText(this.getString("CATEGORIES"));
        header.setHorizontalAlignment(0);
        XDMTreeNode root = new XDMTreeNode(this.getString("TREE_DOWNLOADS"));
        root.id = "TREE_DOWNLOADS";
        String[] types = new String[]{"TREE_COMPRESSED", "TREE_DOCUMENTS", "TREE_MUSIC", "TREE_PROGRAMS", "TREE_VIDEOS"};
        XDMTreeNode all = new XDMTreeNode(this.getString("TREE_ALL"));
        all.id = "TREE_ALL";
        int i = 0;
        while (i < types.length) {
            XDMTreeNode node = new XDMTreeNode(this.getString(types[i]));
            node.id = types[i];
            all.add(node);
            ++i;
        }
        root.add(all);
        XDMTreeNode unfinished = new XDMTreeNode(this.getString("TREE_UNFINISHED"));
        unfinished.id = "TREE_UNFINISHED";
        int i2 = 0;
        while (i2 < types.length) {
            XDMTreeNode node = new XDMTreeNode(this.getString(types[i2]));
            node.id = types[i2];
            unfinished.add(node);
            ++i2;
        }
        root.add(unfinished);
        XDMTreeNode finished = new XDMTreeNode(this.getString("TREE_FINISHED"));
        finished.id = "TREE_FINISHED";
        int i3 = 0;
        while (i3 < types.length) {
            XDMTreeNode node = new XDMTreeNode(this.getString(types[i3]));
            node.id = types[i3];
            finished.add(node);
            ++i3;
        }
        root.add(finished);
        this.tree = new JTree(root);
        this.tree.addTreeSelectionListener(this);
        this.tree.setAutoscrolls(true);
        JScrollPane jsp = new JScrollPane(this.tree);
        jsp.setColumnHeaderView(header);
        if (System.getProperty("xdm.defaulttheme") != null) {
            this.tree.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.tree.setCellRenderer(new XDMTreeCellRenderer());
        }
        this.content.add((Component)jsp, "left");
    }

    void createToolbar() {
        JComponent p;
        int toolBtnWidth = 0;
        this.addurl = new JButton(this.getString("ADD_URL"), XDMMainWindow.getIcon("add.png"));
        this.addurl.setRolloverIcon(XDMMainWindow.getIcon("add_r.png"));
        this.addurl.setName("ADD_URL");
        this.delete = new JButton(this.getString("DELETE"), XDMMainWindow.getIcon("remove.png"));
        this.delete.setRolloverIcon(XDMMainWindow.getIcon("remove_r.png"));
        this.delete.setName("DELETE");
        this.resume = new JButton(this.getString("RESUME"), XDMMainWindow.getIcon("resume.png"));
        this.resume.setRolloverIcon(XDMMainWindow.getIcon("resume_r.png"));
        this.resume.setName("RESUME");
        this.pause = new JButton(this.getString("PAUSE"), XDMMainWindow.getIcon("pause.png"));
        this.pause.setRolloverIcon(XDMMainWindow.getIcon("pause_r.png"));
        this.pause.setName("PAUSE");
        this.media = new JButton(this.getString("GRABBER"), XDMMainWindow.getIcon("media.png"));
        this.media.setRolloverIcon(XDMMainWindow.getIcon("media_r.png"));
        this.media.setName("GRABBER");
        this.option = new JButton(this.getString("OPTIONS"), XDMMainWindow.getIcon("settings.png"));
        this.option.setRolloverIcon(XDMMainWindow.getIcon("settings_r.png"));
        this.option.setName("OPTIONS");
        this.youtube = new JButton(this.getString("YOUTUBE"), XDMMainWindow.getIcon("ytd.png"));
        this.youtube.setRolloverIcon(XDMMainWindow.getIcon("ytd_r.png"));
        this.youtube.setName("YOUTUBE");
        this.exit = new JButton(this.getString("EXIT"), XDMMainWindow.getIcon("exit.png"));
        this.exit.setRolloverIcon(XDMMainWindow.getIcon("exit_r.png"));
        this.exit.setName("EXIT");
        this.decorateButton(this.addurl);
        this.decorateButton(this.delete);
        this.decorateButton(this.resume);
        this.decorateButton(this.pause);
        this.decorateButton(this.media);
        this.decorateButton(this.option);
        this.decorateButton(this.youtube);
        this.decorateButton(this.exit);
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            toolBtnWidth = this.addurl.getPreferredSize().width;
            toolBtnWidth = Math.max(this.delete.getPreferredSize().width, toolBtnWidth);
            toolBtnWidth = Math.max(this.resume.getPreferredSize().width, toolBtnWidth);
            toolBtnWidth = Math.max(this.pause.getPreferredSize().width, toolBtnWidth);
            toolBtnWidth = Math.max(this.media.getPreferredSize().width, toolBtnWidth);
            toolBtnWidth = Math.max(this.option.getPreferredSize().width, toolBtnWidth);
            toolBtnWidth = Math.max(this.youtube.getPreferredSize().width, toolBtnWidth);
            toolBtnWidth = Math.max(this.exit.getPreferredSize().width, toolBtnWidth);
            Dimension d = new Dimension(toolBtnWidth, this.exit.getPreferredSize().height);
            this.addurl.setPreferredSize(d);
            this.delete.setPreferredSize(d);
            this.resume.setPreferredSize(d);
            this.pause.setPreferredSize(d);
            this.media.setPreferredSize(d);
            this.option.setPreferredSize(d);
            this.youtube.setPreferredSize(d);
            this.exit.setPreferredSize(d);
            this.addurl.setMaximumSize(d);
            this.delete.setMaximumSize(d);
            this.resume.setMaximumSize(d);
            this.pause.setMaximumSize(d);
            this.media.setMaximumSize(d);
            this.option.setMaximumSize(d);
            this.youtube.setMaximumSize(d);
            this.exit.setMaximumSize(d);
            this.addurl.setMinimumSize(d);
            this.delete.setMinimumSize(d);
            this.resume.setMinimumSize(d);
            this.pause.setMinimumSize(d);
            this.media.setMinimumSize(d);
            this.option.setMinimumSize(d);
            this.youtube.setMinimumSize(d);
            this.exit.setMinimumSize(d);
            p = Box.createHorizontalBox();
            ((Box)p).setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 0));
        } else {
            p = new JToolBar();
        }
        p.add(this.addurl);
        p.add(this.delete);
        p.add(this.resume);
        p.add(this.pause);
        p.add(this.media);
        p.add(this.option);
        p.add(this.youtube);
        p.add(this.exit);
        p.add(Box.createHorizontalGlue());
        this.add((Component)p, "North");
    }

    void decorateButton(JButton b) {
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            b.setUI(this.toolBtnUI);
            b.setBorderPainted(false);
            b.setFocusPainted(false);
            b.setContentAreaFilled(false);
            b.setMargin(new Insets(6, 1, 2, 1));
        }
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setHorizontalAlignment(0);
        b.addActionListener(this);
    }

    void createMenu() {
        this.bar = new JMenuBar();
        this.bar.add(Box.createRigidArea(new Dimension(10, 0)));
        JMenu file = new JMenu(this.getString("FILE"));
        this.addMenuItem("ADD_URL", file);
        this.addMenuItem("BATCH_DOWNLOAD", file);
        this.addMenuItem("YOUTUBE_DOWNLOADER", file);
        this.addMenuItem("CLIP_ADD", file);
        this.addMenuItem("DELETE_DWN", file);
        this.addMenuItem("DELETE_COMPLETED", file);
        this.addMenuItem("MAKE_SHORTCUT", file);
        this.addMenuItem("MEDIA_GRABBER", file);
        this.addMenuItem("EXIT", file);
        JMenu dwn = new JMenu(this.getString("DOWNLOAD"));
        this.addMenuItem("PAUSE", dwn);
        this.addMenuItem("RESUME", dwn);
        this.addMenuItem("RESTART", dwn);
        this.addMenuItem("START_Q", dwn);
        this.addMenuItem("STOP_Q", dwn);
        JMenu tools = new JMenu(this.getString("TOOLS"));
        this.addMenuItem("OPTIONS", tools);
        this.addMenuItem("REFRESH_LINK", tools);
        this.addMenuItem("BROWSER_INT", tools);
        this.addMenuItem("CTX_ASM", tools);
        JMenu theme = this.createThemeMenu();
        tools.add(theme);
        JMenu view = new JMenu(this.getString("VIEW"));
        this.addMenuItem("CTX_OPEN", view);
        this.addMenuItem("CTX_OPEN_FOLDER", view);
        this.addMenuItem("CTX_SAVE_AS", view);
        this.addMenuItem("CTX_COPY_URL", view);
        this.addMenuItem("CTX_COPY_FILE", view);
        view.add(this.createSortMenu());
        JMenu help = new JMenu(this.getString("HELP"));
        this.addMenuItem("CONTENT", help);
        this.addMenuItem("HOME_PAGE", help);
        this.addMenuItem("UPDATE", help);
        this.addMenuItem("ABOUT", help);
        this.bar.add(file);
        this.bar.add(dwn);
        this.bar.add(view);
        this.bar.add(tools);
        this.bar.add(help);
        this.setJMenuBar(this.bar);
    }

    void addMenuItem(String id, JComponent menu) {
        JMenuItem mitem = new JMenuItem(this.getString(id));
        mitem.setName(id);
        mitem.addActionListener(this);
        menu.add(mitem);
    }

    String getString(String id) {
        String str = StringResource.getString(id);
        return str == null ? "" : str;
    }

    static ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(XDMMainWindow.class.getResource("/res/" + name));
        }
        catch (Exception e) {
            return new ImageIcon("res/" + name);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            String name = ((AbstractButton)e.getSource()).getName();
            if (name == null) {
                return;
            }
            if ("ADD_URL".equals(name)) {
                this.addDownload();
            } else if ("PAUSE".equals(name)) {
                this.pauseDownload();
            } else if ("RESUME".equals(name)) {
                this.resumeDownload();
            } else if ("DELETE".equals(name) || "DELETE_DWN".equals(name)) {
                this.removeDownloads();
            } else if ("RESTART".equals(name)) {
                this.restartDownload();
            } else if ("OPTIONS".equals(name)) {
                if (this.configDlg == null) {
                    this.configDlg = new ConfigDialog((Frame)this, config, this);
                }
                this.configDlg.showDialog();
            } else if ("EXIT".equals(name)) {
                this.exitXDM();
            } else if ("BATCH_DOWNLOAD".equals(name)) {
                if (this.batchDlg == null) {
                    this.batchDlg = new BatchDlg(this);
                }
                this.batchDlg.setLocationRelativeTo(this);
                this.batchDlg.setVisible(true);
            } else if ("CLIP_ADD".equals(name)) {
                if (this.listDlg == null) {
                    this.listDlg = new BatchDownloadDlg();
                }
                this.listDlg.setLocationRelativeTo(this);
                this.listDlg.showDialog(XDMMainWindow.config.destdir, this);
            } else if ("MEDIA_GRABBER".equals(name) || "GRABBER".equals(name)) {
                this.showGrabber();
            } else if ("YOUTUBE_DOWNLOADER".equals(name) || "YOUTUBE".equals(name)) {
                if (this.ytDlg == null) {
                    this.ytDlg = new YoutubeGrabberDlg(this);
                }
                this.ytDlg.showDialog(this, config, "");
            } else if ("DELETE_COMPLETED".equals(name)) {
                this.deleteFinished();
            } else if ("REFRESH_LINK".equals(name)) {
                this.refreshLink();
            } else if ("CTX_OPEN".equals(name)) {
                this.openFile();
            } else if ("CTX_OPEN_FOLDER".equals(name)) {
                this.openFolder();
            } else if ("CTX_SAVE_AS".equals(name)) {
                this.renameFile();
            } else if ("LAF".equals(name)) {
                String cmd = e.getActionCommand();
                this.setLAF(cmd);
            } else if ("BROWSER_INT".equals(name)) {
                this.showBrowserIntegrationDlg();
            } else if ("RESTORE".equals(name)) {
                this.restoreWindow();
            } else if ("ABOUT".equals(name)) {
                this.abtDlg = new AboutDialog();
                this.abtDlg.setLocationRelativeTo(null);
                this.abtDlg.setVisible(true);
            } else if ("PROPERTIES".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                PropertiesDialog.showDetails(item);
            } else if ("HOME_PAGE".equals(name)) {
                XDMUtil.browse("http://www.sourceforge.net/projects/xdman");
            } else if ("UPDATE".equals(name)) {
                XDMUtil.browse("http://www.sourceforge.net/projects/xdman");
            } else if ("CONTENT".equals(name)) {
                try {
                    HelpDialog hlp = HelpDialog.getHelpDialog();
                    hlp.setDocument("BROWSER_INTEGRATION");
                    hlp.setLocationRelativeTo(null);
                    hlp.setVisible(true);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            } else if ("CTX_ASC".equals(name)) {
                TableSortInfo.setAscending(true);
                this.sort();
            } else if ("CTX_DESC".equals(name)) {
                TableSortInfo.setAscending(false);
                this.sort();
            } else if (name.startsWith("COL:")) {
                String num = name.split(":")[1];
                TableSortInfo.setSortingField(Integer.parseInt(num));
                this.sort();
            } else if ("START_Q".equals(name)) {
                this.startQueue();
            } else if ("STOP_Q".equals(name)) {
                TableSortInfo.setAscending(false);
                this.stopQueue();
            } else if ("CTX_ADD_Q".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                this.add2Q(item, true);
            } else if ("CTX_DEL_Q".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                this.add2Q(item, false);
            } else if ("CTX_SHOW_PRG".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                if (item.window != null) {
                    item.window.setVisible(true);
                }
            } else if ("MAKE_SHORTCUT".equals(name)) {
                JFileChooser jfc = XDMFileChooser.getFileChooser(1, new File(System.getProperty("user.home")));
                if (jfc.showOpenDialog(this) == 0) {
                    this.createLinuxShortCut(jfc.getSelectedFile());
                }
            } else if ("CTX_ASM".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                if (item.mgr != null || item.state == 50) {
                    this.showMessageBox(this.getString("DWN_ACTIVE_OR_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, this.getString("ASM_WRN"), this.getString("DEFAULT_TITLE"), 0, 3) == 0) {
                    if (this.asmDlg == null) {
                        this.asmDlg = new AssembleDialog(this);
                    }
                    this.asmDlg.startAssemble(item.filename, item.saveto, item.tempdir);
                }
            } else if ("CTX_COPY_FILE".equals(name)) {
                int[] index = this.table.getSelectedRows();
                if (index == null || index.length < 1) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem[] items = new DownloadListItem[index.length];
                int i = 0;
                while (i < index.length) {
                    items[i] = list.get(index[i]);
                    ++i;
                }
                try {
                    this.copyFiles(items);
                }
                catch (Exception exx) {
                    exx.printStackTrace();
                }
            } else if ("CTX_COPY_URL".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                this.copyURL(item.url);
            }
        }
    }

    void setLAF(String laf) {
        try {
            if ("Default".equals(laf)) {
                XDMMainWindow.config.lafClass = XDMLookAndFeel.class.getName();
                XDMMainWindow.config.lafName = laf;
            } else {
                UIManager.LookAndFeelInfo[] lafs;
                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs = UIManager.getInstalledLookAndFeels();
                int n = lafs.length;
                int n2 = 0;
                while (n2 < n) {
                    UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                    if (info.getName().equals(laf)) {
                        XDMMainWindow.config.lafClass = info.getClassName();
                        XDMMainWindow.config.lafName = info.getName();
                        break;
                    }
                    ++n2;
                }
            }
            this.showMessageBox(this.getString("THEME_TXT"), this.getString("DEFAULT_TITLE"), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(XDMMainWindow.config.lafName);
    }

    public void renameFile(DownloadListItem item, int row) {
        if (item.state == 50) {
            this.showMessageBox(this.getString("DWN_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
        } else {
            JFileChooser jfc = XDMFileChooser.getFileChooser(0, new File(item.saveto, item.filename));
            if (jfc.showSaveDialog(this) != 0) {
                return;
            }
            String file = jfc.getSelectedFile().getName();
            String folder = jfc.getSelectedFile().getParent();
            if (item.mgr != null) {
                if (item.mgr.state == 60) {
                    this.showMessageBox(this.getString("DWN_ASSEMBLING"), this.getString("DEFAULT_TITLE"), 0);
                } else {
                    item.mgr.setDestdir(folder);
                    item.mgr.setFileName(file);
                }
            }
            item.filename = file;
            item.saveto = folder;
            list.downloadStateChanged();
            this.model.fireTableRowsUpdated(row, row);
        }
    }

    private void renameFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DownloadListItem item = list.get(row);
        if (item == null) {
            return;
        }
        this.renameFile(item, row);
    }

    private void openFolder() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DownloadListItem item = list.get(row);
        if (item == null) {
            return;
        }
        File folder = new File(item.saveto);
        if (!folder.exists()) {
            this.showMessageBox(this.getString("FOLDER_NOT_FOUND"), this.getString("DEFAULT_TITLE"), 0);
        } else {
            XDMUtil.open(folder);
        }
    }

    private void openFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DownloadListItem item = list.get(row);
        if (item == null) {
            return;
        }
        if (item.state == 50) {
            File file = new File(item.saveto, item.filename);
            if (file.exists()) {
                XDMUtil.open(file);
            } else {
                this.showMessageBox(this.getString("FILE_NOT_FOUND"), this.getString("DEFAULT_TITLE"), 0);
            }
        } else {
            this.showMessageBox(this.getString("DWN_INCOMPLETE"), this.getString("DEFAULT_TITLE"), 0);
        }
    }

    void createContextMenu() {
        this.ctxPopup = new JPopupMenu();
        this.addMenuItem("CTX_OPEN", this.ctxPopup);
        this.addMenuItem("CTX_OPEN_FOLDER", this.ctxPopup);
        this.addMenuItem("CTX_SAVE_AS", this.ctxPopup);
        this.addMenuItem("CTX_SHOW_PRG", this.ctxPopup);
        this.addMenuItem("PAUSE", this.ctxPopup);
        this.addMenuItem("RESUME", this.ctxPopup);
        this.addMenuItem("RESTART", this.ctxPopup);
        this.addMenuItem("DELETE", this.ctxPopup);
        this.addMenuItem("REFRESH_LINK", this.ctxPopup);
        this.addMenuItem("CTX_ASM", this.ctxPopup);
        this.addMenuItem("CTX_ADD_Q", this.ctxPopup);
        this.addMenuItem("CTX_DEL_Q", this.ctxPopup);
        this.ctxPopup.add(this.createSortMenu());
        this.addMenuItem("CTX_COPY_URL", this.ctxPopup);
        this.addMenuItem("CTX_COPY_FILE", this.ctxPopup);
        this.addMenuItem("PROPERTIES", this.ctxPopup);
        this.ctxPopup.setInvoker(this.table);
    }

    JMenu createSortMenu() {
        JMenu sortMenu = new JMenu(this.getString("CTX_SORT"));
        sortMenu.setName("CTX_SORT");
        sortMenu.addActionListener(this);
        sortMenu.setIcon(new XDMBlankIcon(15, 10));
        sortMenu.setBorderPainted(false);
        sortMenu.setMargin(new Insets(10, 0, 0, 0));
        ButtonGroup bg1 = new ButtonGroup();
        int i = 1;
        while (i < this.model.getColumnCount()) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.model.getColumnName(i));
            item.setName("COL:" + i);
            item.addActionListener(this);
            sortMenu.add(item);
            bg1.add(item);
            if (TableSortInfo.getSortingField() == i) {
                item.setSelected(true);
            }
            ++i;
        }
        sortMenu.addSeparator();
        ButtonGroup bg2 = new ButtonGroup();
        JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(this.getString("CTX_ASC"));
        item1.setName("CTX_ASC");
        item1.addActionListener(this);
        sortMenu.add(item1);
        bg2.add(item1);
        JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(this.getString("CTX_DESC"));
        item2.setName("CTX_DESC");
        item2.addActionListener(this);
        sortMenu.add(item2);
        bg2.add(item2);
        if (TableSortInfo.isAscending()) {
            item1.setSelected(true);
        } else {
            item2.setSelected(true);
        }
        return sortMenu;
    }

    private void refreshLink() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem item = list.get(index);
        if (item != null) {
            if (item.state != 50 && item.mgr == null) {
                String url = XDMUtil.isNullOrEmpty(item.referer) ? item.url : item.referer;
                if ((url = RefreshLinkDlg.showDialog(this, url)) != null) {
                    item.url = url;
                    this.model.fireTableRowsUpdated(index, index);
                    list.downloadStateChanged();
                }
            } else {
                this.showMessageBox(this.getString("DWN_ACTIVE_OR_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
            }
        }
    }

    private void exitXDM() {
        XDMMainWindow.config.mwX = this.getX();
        XDMMainWindow.config.mwY = this.getY();
        XDMMainWindow.config.mwW = this.getWidth();
        XDMMainWindow.config.mwH = this.getHeight();
        if (this.mediaDlg != null) {
            XDMMainWindow.config.mgX = this.mediaDlg.getX();
            XDMMainWindow.config.mgY = this.mediaDlg.getY();
            XDMMainWindow.config.mgW = this.mediaDlg.getWidth();
            XDMMainWindow.config.mgH = this.mediaDlg.getHeight();
        }
        if (this.w != null) {
            XDMMainWindow.config.dbX = this.w.getX();
            XDMMainWindow.config.dbY = this.w.getY();
        }
        list.downloadStateChanged();
        config.save();
        Authenticator.getInstance().save();
        System.exit(0);
    }

    @Override
    public void initBatchDownload(List<String> list, String user, String pass) {
        if (list == null || list.size() < 1) {
            return;
        }
        if (this.listDlg == null) {
            this.listDlg = new BatchDownloadDlg();
        }
        this.listDlg.setLocationRelativeTo(null);
        ArrayList<BatchItem> blist = new ArrayList<BatchItem>();
        int i = 0;
        while (i < list.size()) {
            BatchItem item = new BatchItem();
            item.url = list.get(i);
            item.fileName = XDMUtil.getFileName(item.url);
            item.user = user;
            item.pass = pass;
            item.dir = XDMMainWindow.config.destdir;
            blist.add(item);
            ++i;
        }
        this.listDlg.showDialog(blist, XDMMainWindow.config.destdir, this);
    }

    @Override
    public void mediaCaptured(String name, String url, String type, String size, String referer, String ua, ArrayList<String> cookies) {
        if (this.mediaDlg == null) {
            this.mediaModel = new MediaTableModel();
            this.mediaDlg = new MediaGrabberWindow(this.mediaModel, this, config);
            if (XDMMainWindow.config.mgW <= 0) {
                this.mediaDlg.setLocationRelativeTo(null);
            } else {
                this.mediaDlg.setLocation(XDMMainWindow.config.mgX, XDMMainWindow.config.mgY);
            }
        }
        String filename = XDMUtil.isNullOrEmpty(name) ? XDMUtil.getFileName(url) : name;
        MediaInfo info = new MediaInfo();
        info.name = filename;
        info.url = url;
        info.referer = referer;
        info.userAgent = ua;
        info.type = type;
        info.size = size;
        info.cookies = cookies;
        this.mediaModel.add(info);
        this.showNotification();
    }

    @Override
    public void showGrabber() {
        if (this.mediaDlg == null) {
            this.mediaModel = new MediaTableModel();
            this.mediaDlg = new MediaGrabberWindow(this.mediaModel, this, config);
        }
        if (XDMMainWindow.config.mgW <= 0) {
            this.mediaDlg.setLocationRelativeTo(null);
        } else {
            this.mediaDlg.setLocation(XDMMainWindow.config.mgX, XDMMainWindow.config.mgY);
        }
        this.mediaDlg.setVisible(true);
    }

    @Override
    public void showNotification() {
        this.lbl.setToolTipText("Video captured");
        if (this.timer == null) {
            this.timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ++XDMMainWindow.this.hotcount;
                    if (XDMMainWindow.this.hotcount >= 9) {
                        XDMMainWindow.this.timer.stop();
                        XDMMainWindow.this.hotcount = 0;
                    }
                    if (XDMMainWindow.this.hotcount % 2 == 0) {
                        XDMMainWindow.this.lbl.setIcon(XDMIconMap.getIcon("HOT_ICON"));
                    } else {
                        XDMMainWindow.this.lbl.setIcon(XDMIconMap.getIcon("COLD_ICON"));
                    }
                }
            });
        }
        this.timer.stop();
        this.timer.setRepeats(true);
        this.timer.start();
        this.hot = true;
    }

    @Override
    public void showNotificationText(String text, String title) {
        this.showNotification();
    }

    @Override
    public void addDownload(String url, String name, String folder, String user, String pass, String referer, ArrayList<String> cookies, String userAgent) {
        DownloadFileInfoDialog fdlg = new DownloadFileInfoDialog(this, config);
        fdlg.setURL(url);
        fdlg.file.setText(name);
        fdlg.setDir(XDMMainWindow.config.destdir);
        fdlg.user.setText(user);
        fdlg.pass.setText(pass);
        fdlg.referer = referer;
        fdlg.cookies = cookies;
        fdlg.userAgent = userAgent;
        fdlg.showDlg();
    }

    void deleteFinished() {
        ArrayList<DownloadListItem> lists = new ArrayList<DownloadListItem>();
        int i = 0;
        while (i < XDMMainWindow.list.list.size()) {
            DownloadListItem item = XDMMainWindow.list.list.get(i);
            if (item.state == 50) {
                lists.add(item);
            }
            ++i;
        }
        i = 0;
        while (i < lists.size()) {
            XDMMainWindow.list.list.remove(lists.get(i));
            ++i;
        }
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    JMenu createThemeMenu() {
        JMenu mitem = new JMenu(this.getString("THEME"));
        mitem.setName("THEME");
        mitem.addActionListener(this);
        mitem.setIcon(new XDMBlankIcon(15, 10));
        mitem.setBorderPainted(false);
        mitem.setMargin(new Insets(10, 0, 0, 0));
        try {
            ButtonGroup bg = new ButtonGroup();
            UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
            int i = 0;
            while (i < lafs.length) {
                JCheckBoxMenuItem mitem2 = new JCheckBoxMenuItem(lafs[i].getName());
                if (lafs[i].getName().equals(XDMMainWindow.config.lafName)) {
                    mitem2.setSelected(true);
                }
                mitem2.setName("LAF");
                mitem2.addActionListener(this);
                mitem.add(mitem2);
                bg.add(mitem2);
                ++i;
            }
            JCheckBoxMenuItem mitem32 = new JCheckBoxMenuItem("Default");
            if ("Default".equals(XDMMainWindow.config.lafName)) {
                mitem32.setSelected(true);
            }
            mitem32.setName("LAF");
            mitem32.addActionListener(this);
            mitem.add(mitem32);
            bg.add(mitem32);
        }
        catch (Exception e) {
            e.printStackTrace();
            mitem.setEnabled(false);
        }
        return mitem;
    }

    void createTray() {
        JMenuItem newDownload = new JMenuItem(StringResource.getString("ADD_URL"));
        newDownload.setName("ADD_URL");
        newDownload.addActionListener(this);
        JMenuItem aboutXDM = new JMenuItem(StringResource.getString("ABOUT"));
        aboutXDM.setName("ABOUT");
        aboutXDM.addActionListener(this);
        JMenuItem restore = new JMenuItem(StringResource.getString("RESTORE"));
        restore.setName("RESTORE");
        restore.addActionListener(this);
        JMenuItem exit2 = new JMenuItem(StringResource.getString("EXIT"));
        exit2.setName("EXIT");
        exit2.addActionListener(this);
        final JPopupMenu trayPop = new JPopupMenu();
        trayPop.add(newDownload);
        trayPop.add(aboutXDM);
        trayPop.add(restore);
        trayPop.add(exit2);
        this.lbl = new JLabel();
        this.lbl.setToolTipText("Xtreme Download Manager");
        this.lbl.setOpaque(true);
        this.lbl.setIcon(XDMMainWindow.getIcon("xdm22.png"));
        this.lbl.setHorizontalAlignment(0);
        this.lbl.setVerticalAlignment(0);
        trayPop.setInvoker(this.lbl);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (e.getClickCount() == 2) {
                        XDMMainWindow.this.restoreWindow();
                    }
                    if (XDMMainWindow.this.hot) {
                        XDMMainWindow.this.killTimer();
                        XDMMainWindow.this.showGrabber();
                    }
                }
                if (e.getButton() == 3) {
                    trayPop.show(XDMMainWindow.this.lbl, e.getX(), e.getY());
                }
            }
        };
        this.lbl.addMouseListener(m);
        this.w = new DropBox(this.lbl, this);
        this.w.setSize(22, 22);
        if (XDMMainWindow.config.dbX <= 0) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.w.setLocation(d.width - 30, d.height - 100);
        } else {
            this.w.setLocation(XDMMainWindow.config.dbX, XDMMainWindow.config.dbY);
        }
        this.w.setVisible(true);
    }

    HelpDialog getHTMLViwer() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("Browser Integration", this.getClass().getResource("/help/browser_integration.html"));
        map.put("Capturing Videos", this.getClass().getResource("/help/video_download.html"));
        map.put("Refresh Broken Downloads", this.getClass().getResource("/help/refresh_link.html"));
        HelpDialog hlp = new HelpDialog();
        hlp.addPages(map);
        return hlp;
    }

    static void parseArgs(String[] a) {
        String key = "url";
        boolean min = false;
        int i = 0;
        while (i < a.length) {
            if (a[i].equals("-c")) {
                key = "cookie";
            } else if (a[i].equals("-r")) {
                key = "referer";
            } else if (a[i].equals("-m")) {
                min = true;
            } else if (a[i].equals("-u")) {
                key = "url";
            } else {
                arg.put(key, a[i]);
            }
            ++i;
        }
        if (min) {
            arg.put("min", "true");
        }
    }

    void showBrowserIntegrationDlg() {
        if (this.biDlg == null) {
            this.biDlg = new BrowserIntDlg(config);
        }
        this.biDlg.setLocationRelativeTo(null);
        this.biDlg.setVisible(true);
    }

    void killTimer() {
        this.hot = false;
        this.timer.stop();
        this.hotcount = 0;
        this.lbl.setIcon(XDMIconMap.getIcon("COLD_ICON"));
        this.lbl.setToolTipText("Xtreme Download Manager");
    }

    void sort() {
        list.sort();
        list.downloadStateChanged();
        this.model.fireTableDataChanged();
    }

    boolean processNextQueuedDownload() {
        System.out.println("ProcessNextQueue");
        if (!this.processQueue) {
            return false;
        }
        if (this.qi != null) {
            return false;
        }
        int i = 0;
        while (i < XDMMainWindow.list.list.size()) {
            DownloadListItem di = XDMMainWindow.list.list.get(i);
            if (di.mgr == null && di.state != 50 && di.q) {
                this.qi = di;
                this.resumeDownload(di);
                return true;
            }
            ++i;
        }
        this.qi = null;
        this.processQueue = false;
        XDMMainWindow.config.schedule = false;
        this.schedulerActive = false;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void schedulerRun() {
        this.schedulerActive = true;
        Logger.log("SchedulerRun");
        try {
            block17: {
                block16: {
                    if (System.currentTimeMillis() > XDMMainWindow.config.endDate.getTime()) {
                        Logger.log("Scheduler outdated");
                        return;
                    }
                    Logger.log("Starting scheduler");
                    while (true) {
                        if (!XDMMainWindow.config.schedule) {
                            Logger.log("Scheduler killed");
                            return;
                        }
                        if (System.currentTimeMillis() > XDMMainWindow.config.startDate.getTime()) {
                            if (!this.processQueue) {
                                break;
                            }
                            break block16;
                        }
                        Thread.sleep(1000L);
                    }
                    Logger.log("Starting queue scheduler");
                    this.processQueue = true;
                    this.processNextQueuedDownload();
                    break block17;
                }
                Logger.log("Queue already started");
            }
            while (true) {
                if (!this.processQueue) {
                    return;
                }
                if (!XDMMainWindow.config.schedule) {
                    Logger.log("Scheduler killed");
                    if (!this.processQueue) return;
                    this.stopQueue();
                    this.processQueue = false;
                    return;
                }
                if (System.currentTimeMillis() > XDMMainWindow.config.endDate.getTime()) {
                    if (this.processQueue) {
                        this.stopQueue();
                        this.processQueue = false;
                    }
                    Logger.log("Time ended processQ: " + this.processQueue);
                    XDMMainWindow.config.schedule = false;
                    return;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception ex) {
            Logger.log(ex);
            return;
        }
        finally {
            this.schedulerActive = false;
        }
    }

    void add2Q(DownloadListItem item, boolean add) {
        if (item.mgr != null || item.state == 50) {
            this.showMessageBox(this.getString("DWN_ACTIVE_OR_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        item.q = add;
        list.downloadStateChanged();
        this.model.fireTableDataChanged();
    }

    void executeCommands() {
        if (XDMMainWindow.config.executeCmd) {
            this.exec(XDMMainWindow.config.cmdTxt);
        }
        if (XDMMainWindow.config.antivir) {
            this.exec(XDMMainWindow.config.antivirTxt);
        }
        if (XDMMainWindow.config.hungUp) {
            this.exec(XDMMainWindow.config.hungUpTxt);
        }
        if (XDMMainWindow.config.halt) {
            this.exec(XDMMainWindow.config.haltTxt);
        }
    }

    void exec(String cmd) {
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void createLinuxShortCut(File f) {
        LinuxUtil.createDesktopFile(f.getAbsolutePath(), false);
    }

    void copyFiles(DownloadListItem[] items) {
        Object[] values = null;
        if (items != null) {
            values = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                DownloadListItem item = items[i];
                File file = new File(item.saveto, item.filename);
                System.out.println(file);
                values[i] = file;
                ++i;
            }
        }
        StringBuffer plainBuf = new StringBuffer();
        StringBuffer htmlBuf = new StringBuffer();
        htmlBuf.append("<html>\n<body>\n<ul>\n");
        int i = 0;
        while (i < values.length) {
            Object obj = values[i];
            String val = obj == null ? "" : obj.toString();
            plainBuf.append(String.valueOf(val) + "\n");
            htmlBuf.append("  <li>" + val + "\n");
            ++i;
        }
        if (this.clipboard == null) {
            this.clipboard = this.t.getSystemClipboard();
        }
        this.clipboard.setContents(new FileTransferHandler.FileTransferable(plainBuf.toString(), htmlBuf.toString(), values), null);
    }

    void copyURL(String url) {
        if (this.clipboard == null) {
            this.clipboard = this.t.getSystemClipboard();
        }
        this.clipboard.setContents(new StringSelection(url), null);
    }

    public static void main(String[] args) {
        boolean firstRun = false;
        File fAppDir = new File(System.getProperty("user.home"), ".xdm");
        File fTmpDir = new File(fAppDir, "temp");
        File configFile = new File(fAppDir, ".xdmconf");
        firstRun = !configFile.exists();
        config = XDMConfig.load(configFile);
        XDMMainWindow.parseArgs(args);
        if (firstRun) {
            fAppDir.mkdirs();
            fTmpDir.mkdirs();
        }
        tempdir = fTmpDir.getAbsolutePath();
        destdir = System.getProperty("user.home");
        appdir = fAppDir.getAbsolutePath();
        try {
            if (XDMMainWindow.config.lafName == null) {
                XDMMainWindow.config.lafName = "Default";
                XDMMainWindow.config.lafClass = XDMLookAndFeel.class.getName();
            }
            UIManager.setLookAndFeel(XDMMainWindow.config.lafClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            StringResource.loadResource("en");
            XDMIconMap.setIcon("DOC", XDMMainWindow.getIcon("document.png"));
            XDMIconMap.setIcon("MUSIC", XDMMainWindow.getIcon("music.png"));
            XDMIconMap.setIcon("OTHER", XDMMainWindow.getIcon("other.png"));
            XDMIconMap.setIcon("APP", XDMMainWindow.getIcon("program.png"));
            XDMIconMap.setIcon("VID", XDMMainWindow.getIcon("video.png"));
            XDMIconMap.setIcon("ZIP", XDMMainWindow.getIcon("compressed.png"));
            XDMIconMap.setIcon("FOLDER", XDMMainWindow.getIcon("folder.png"));
            XDMIconMap.setIcon("RIGHT_ARROW", XDMMainWindow.getIcon("left_arrow.png"));
            XDMIconMap.setIcon("LEFT_ARROW", XDMMainWindow.getIcon("right_arrow.png"));
            XDMIconMap.setIcon("UP_ARROW", XDMMainWindow.getIcon("up_arrow.png"));
            XDMIconMap.setIcon("DOWN_ARROW", XDMMainWindow.getIcon("down_arrow.png"));
            XDMIconMap.setIcon("EXPAND_ICON", XDMMainWindow.getIcon("expand.png"));
            XDMIconMap.setIcon("COLLAPSE_ICON", XDMMainWindow.getIcon("collapse.png"));
            XDMIconMap.setIcon("APP_ICON", XDMMainWindow.getIcon("icon.png"));
            XDMIconMap.setIcon("Q_ICON", XDMMainWindow.getIcon("q.png"));
            XDMIconMap.setIcon("YT_ICON", XDMMainWindow.getIcon("youtube72.png"));
            XDMIconMap.setIcon("RF_ICON", XDMMainWindow.getIcon("restart.png"));
            XDMIconMap.setIcon("COLD_ICON", XDMMainWindow.getIcon("xdm22.png"));
            XDMIconMap.setIcon("HOT_ICON", XDMMainWindow.getIcon("xdm22_hot.png"));
            XDMIconMap.setIcon("BACK_ICON", XDMMainWindow.getIcon("back.png"));
            XDMIconMap.setIcon("BACK_R_ICON", XDMMainWindow.getIcon("back_r.png"));
            XDMIconMap.setIcon("NEXT_ICON", XDMMainWindow.getIcon("next.png"));
            XDMIconMap.setIcon("NEXT_R_ICON", XDMMainWindow.getIcon("next_r.png"));
            XDMIconMap.setIcon("FF_ICON", XDMMainWindow.getIcon("firefox.png"));
            XDMIconMap.setIcon("CR_ICON", XDMMainWindow.getIcon("chrome.png"));
            XDMIconMap.setIcon("OP_ICON", XDMMainWindow.getIcon("opera.png"));
            XDMIconMap.setIcon("OT_ICON", XDMMainWindow.getIcon("browser.png"));
            XDMIconMap.setIcon("CI_ICON", XDMMainWindow.getIcon("chrome-inst.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XDMMainWindow mw = new XDMMainWindow();
        XDMServer server = new XDMServer(config, mw, mw);
        if (!server.start()) {
            server.sendParams(arg);
            System.exit(0);
        }
        if (arg.get("min") == null) {
            mw.setVisible(true);
        }
        Authenticator.getInstance().load(new File(fAppDir, ".xdmauth"));
        mw.configChanged();
        if (firstRun) {
            try {
                mw.createLinuxShortCut(new File(XDMUtil.getJarPath()));
            }
            catch (Exception e) {
                System.out.println(e);
            }
            mw.showBrowserIntegrationDlg();
        }
    }
}

