/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class XDMMenuUI
extends BasicMenuUI {
    GradientPaint gradPressed;
    Color lightColor;
    Color darkColor;
    Color lightColor2;

    public static ComponentUI createUI(JComponent c) {
        return new XDMMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)c;
            btn.setMargin(new Insets(1, 1, 1, 1));
        }
        this.lightColor = Color.WHITE;
        this.darkColor = new Color(230, 230, 230);
        this.lightColor2 = new Color(245, 245, 245);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Color c = g.getColor();
        if (this.gradPressed == null) {
            this.gradPressed = new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), 0.0f, b.getHeight(), new Color(220, 220, 220));
        }
        Graphics2D g2 = (Graphics2D)g;
        if ("THEME".equals(b.getName()) || "CTX_SORT".equals(b.getName())) {
            g2.setPaint(this.gradPressed);
            int gapx = 0;
            g2.fillRect(gapx + 2, 0, b.getWidth() - (4 + gapx + 2), b.getHeight() - 2);
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawRect(gapx + 2, 0, b.getWidth() - (4 + gapx + 2), b.getHeight() - 2);
            if (this.menuItem.getIcon() != null) {
                int gap = this.menuItem.getIcon().getIconWidth() + 2;
                g.setColor(this.darkColor);
                g.drawLine(gap, 1, gap, this.menuItem.getHeight() - 3);
                g.setColor(this.lightColor2);
                g.drawLine(gap + 1, 1, gap + 1, this.menuItem.getHeight() - 3);
            }
        } else {
            g2.setPaint(this.gradPressed);
            g2.fillRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 4, 4);
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 4, 4);
        }
        g.setColor(c);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            this.paintButtonPressed(g, menuItem);
        } else if (menuItem.getIcon() != null) {
            int gap = menuItem.getIcon().getIconWidth() + 2;
            g.setColor(this.darkColor);
            g.drawLine(gap, 0, gap, menuItem.getHeight());
            g.setColor(this.lightColor);
            g.drawLine(gap + 1, 0, gap + 1, menuItem.getHeight());
        }
        g.setColor(oldColor);
    }
}

