/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.plugin.youtube;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.sdg.xdman.plugin.youtube.ParserProgressListner;
import org.sdg.xdman.plugin.youtube.YTVideoInfo;
import org.sdg.xdman.plugin.youtube.YouTubeFmtMap;

public class JSONParser {
    public ParserProgressListner plistener;
    long read;

    public ArrayList<YTVideoInfo> list(InputStream in) throws Exception {
        String ln;
        ArrayList<YTVideoInfo> list = new ArrayList<YTVideoInfo>();
        while ((ln = this.readJSLine(in)) != null) {
            String map = this.parseJSONLine(ln);
            if (map == null) continue;
            String[] arr = map.split(",");
            int i = 0;
            while (i < arr.length) {
                YTVideoInfo info = this.getVideoFmt(this.decodeJSONEscape(arr[i]));
                if (info != null) {
                    list.add(info);
                }
                ++i;
            }
            if (list.size() <= 0) continue;
            return list;
        }
        return list;
    }

    private YTVideoInfo getVideoFmt(String encoded_str) throws Exception {
        String[] enc_arr = encoded_str.split("&");
        boolean isEncrypted = false;
        int itag = 0;
        String url = "";
        String sig = "";
        String quality = "";
        String type = "";
        int i = 0;
        while (i < enc_arr.length) {
            String enc_str = enc_arr[i];
            int index = enc_str.indexOf("=");
            if (index > 0) {
                int idx;
                String key = enc_str.substring(0, index);
                String value = enc_str.substring(index + 1);
                value = value.replace("\\", "");
                System.out.println("YT_KEY: " + key + " VALUE: " + value);
                if (key.trim().equals("url")) {
                    url = URLDecoder.decode(value, "utf-8");
                    idx = url.indexOf(";");
                    if (idx > 0) {
                        url = url.substring(0, idx);
                    }
                    if ((idx = url.indexOf(",")) > 0) {
                        url = url.substring(0, idx);
                        url = url.replace("\\", "");
                    }
                }
                if (key.trim().equals("s")) {
                    isEncrypted = true;
                }
                if (key.trim().equals("sig")) {
                    sig = value;
                    idx = sig.indexOf(";");
                    if (idx > 0) {
                        sig = sig.substring(0, idx);
                    }
                    if ((idx = sig.indexOf(",")) > 0) {
                        sig = sig.substring(0, idx);
                        sig = sig.replace("\\", "");
                    }
                }
                if (key.trim().equals("itag")) {
                    try {
                        String itg = URLDecoder.decode(value, "utf-8");
                        itg = itg.replace("\\", "");
                        itg = itg.trim();
                        itag = Integer.parseInt(itg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (key.trim().equals("quality")) {
                    quality = URLDecoder.decode(value, "utf-8");
                    quality = quality.replace("\\", "");
                }
                if (key.trim().equals("type")) {
                    type = URLDecoder.decode(value, "utf-8");
                    type = type.replace("\\", "");
                }
            }
            ++i;
        }
        if (url.length() < 1 || isEncrypted) {
            return null;
        }
        YTVideoInfo info = new YTVideoInfo();
        info.url = String.valueOf(url) + (sig.length() < 1 ? "" : "&signature=" + sig);
        info.itag = YouTubeFmtMap.getFMTInfo(String.valueOf(itag));
        info.quality = quality;
        if (type != null) {
            try {
                type = type.split(";")[0].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        info.type = type;
        return info;
    }

    private String decodeJSONEscape(String json) {
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        while (true) {
            int index;
            if ((index = json.indexOf("\\u", pos)) < 0) {
                if (pos >= json.length()) break;
                buf.append(json.substring(pos));
                break;
            }
            buf.append(json.substring(pos, index));
            pos = index;
            String code = json.substring(pos + 2, pos + 2 + 4);
            int char_code = Integer.parseInt(code, 16);
            buf.append((char)char_code);
            pos += 6;
        }
        return buf.toString();
    }

    private String parseJSONLine(String line) {
        String key = "url_encoded_fmt_stream_map";
        int index = line.indexOf(key);
        if (index < 0) {
            return null;
        }
        int colonIndex = line.indexOf(58, index + key.length());
        if (colonIndex < 0) {
            return null;
        }
        int quoteStartIndex = line.indexOf(34, colonIndex);
        if (quoteStartIndex < 0) {
            return null;
        }
        int quoteEndIndex = line.indexOf(34, quoteStartIndex + 1);
        if (quoteEndIndex < 0) {
            return null;
        }
        String url_encoded_fmt_stream = line.substring(quoteStartIndex + 1, quoteEndIndex);
        return url_encoded_fmt_stream;
    }

    private String readJSLine(InputStream in) throws Exception {
        int x;
        StringBuffer buf = null;
        while ((x = in.read()) != -1) {
            ++this.read;
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (x == 10 || x == 13) continue;
            if (x == 59) break;
            buf.append((char)x);
        }
        if (this.plistener != null) {
            this.plistener.update(this.read);
        }
        if (buf == null) {
            return null;
        }
        return buf.toString().trim();
    }
}

