/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.Credential;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.CreditentialTableModel;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.util.Java6Util;

public class ConfigWindow
extends JDialog
implements TreeSelectionListener,
ActionListener {
    private static final long serialVersionUID = -8869224019635935507L;
    JTree tree;
    JPanel rp;
    JPanel up;
    Box dp;
    JButton ok;
    JButton cancel;
    CardLayout card = new CardLayout();
    JPanel general;
    JPanel saveto;
    JPanel advanced;
    JPanel connection;
    String[] items = new String[]{"General", "Connection", "Save To", "Advanced", "Proxy", "File Types", "Sites Login", "Scheduler"};
    JPanel cardPanel;
    JTextField tempdir;
    JTextField destdir;
    JButton br1;
    JButton br2;
    JComboBox c = new JComboBox<String>(new String[]{"1", "2", "4", "8", "16", "32"});
    JComboBox buf = new JComboBox<String>(new String[]{"8", "16", "32", "64"});
    JSpinner t = new JSpinner(new SpinnerNumberModel(60, 0, 3600, 1));
    JCheckBox chk1 = new JCheckBox("Show Download Progress Dialog");
    JCheckBox chk2 = new JCheckBox("Show Download Complete Dialog");
    JCheckBox chk3 = new JCheckBox("Show Download Box");
    JComboBox act = new JComboBox<String>(new String[]{"Auto Rename", "Resume", "Prompt"});
    JCheckBox cmdChk = new JCheckBox("Execute a command");
    JCheckBox mdmChk = new JCheckBox("Hung up Modem");
    JCheckBox haltChk = new JCheckBox("Shutdown Computer");
    JCheckBox antiChk = new JCheckBox("Scan with antivirus");
    JTextField cmd1 = new JTextField(30);
    JTextField cmd2 = new JTextField(30);
    JTextField cmd3 = new JTextField(30);
    JTextField cmd4 = new JTextField(30);
    JTextArea fileTypes;
    JTextField httpProxy;
    JTextField ftpProxy;
    JTextField httpsProxy;
    JTextField httpPort;
    JTextField ftpPort;
    JTextField httpsPort;
    JTextField httpUser;
    JTextField httpPass;
    JTextField httpsUser;
    JTextField httpsPass;
    JTextField ftpUser;
    JTextField ftpPass;
    JTextField bypassProxy;
    JCheckBox useHttpProxy;
    JCheckBox useHttpsProxy;
    JCheckBox useFtpProxy;
    JPanel proxyPanel;
    JPanel fileTypesPanel;
    JPanel authPanel;
    JPanel schedulePanel;
    XDMConfig config;
    JFileChooser fc;
    JTable table;
    CreditentialTableModel model;
    JButton addAuth;
    JButton removeAuth;
    JButton editAuth;
    JButton defaults;
    JSpinner startDate;
    JSpinner endDate;
    JCheckBox schedule;
    SpinnerDateModel start;
    SpinnerDateModel end;
    JCheckBox allowBrowser;
    JButton antivir;
    JComboBox ctype;
    JCheckBox compress;
    JTextField host;
    JTextField user;
    JTextField pass;
    Object[] obj;

    public ConfigWindow(XDMConfig c, JFrame f) {
        super(f);
        this.setTitle("Configure");
        Java6Util.jdialog$setIconImage(this, MainWindow.icon.getImage());
        this.setModal(true);
        this.config = c;
        this.init();
    }

    void init() {
        this.rp = new JPanel(new BorderLayout());
        this.rp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.rp);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(d.width / 2, d.height / 2);
        this.tree = new JTree(this.items);
        this.tree.addTreeSelectionListener(this);
        this.rp.add((Component)new JScrollPane(this.tree), "West");
        this.ok = new JButton("Save");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.dp = Box.createHorizontalBox();
        this.dp.add(Box.createHorizontalGlue());
        this.dp.add(this.ok);
        this.dp.add(Box.createHorizontalStrut(10));
        this.dp.add(this.cancel);
        this.dp.add(Box.createHorizontalStrut(10));
        this.dp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.dp, "South");
        this.general = new JPanel(new BorderLayout());
        this.general.add(new JLabel("dfsdff"));
        this.connection = new JPanel(new BorderLayout());
        this.saveto = new JPanel(new BorderLayout());
        this.advanced = new JPanel(new BorderLayout());
        this.proxyPanel = new JPanel(new BorderLayout());
        this.fileTypesPanel = new JPanel(new BorderLayout(10, 10));
        this.authPanel = new JPanel(new BorderLayout(10, 10));
        this.schedulePanel = new JPanel(new BorderLayout());
        this.cardPanel = new JPanel(this.card);
        this.cardPanel.add((Component)this.general, this.items[0]);
        this.cardPanel.add((Component)this.connection, this.items[1]);
        this.cardPanel.add((Component)this.saveto, this.items[2]);
        this.cardPanel.add((Component)this.advanced, this.items[3]);
        this.cardPanel.add((Component)this.proxyPanel, this.items[4]);
        this.cardPanel.add((Component)this.fileTypesPanel, this.items[5]);
        this.cardPanel.add((Component)this.authPanel, this.items[6]);
        this.cardPanel.add((Component)this.schedulePanel, this.items[7]);
        this.rp.add(this.cardPanel);
        this.createSaveToPanel();
        this.createConnectionPanel();
        this.createGeneralPanel();
        this.createAdvancedPanel();
        this.createProxyPanel();
        this.createFileTypesPanel();
        this.createAuthPanel();
        this.createSchedulePanel();
        this.card.show(this.cardPanel, this.items[0]);
    }

    void createSaveToPanel() {
        this.br1 = new JButton("...");
        this.br1.addActionListener(this);
        this.br2 = new JButton("...");
        this.br2.addActionListener(this);
        this.tempdir = new JTextField();
        this.tempdir.setEditable(false);
        this.destdir = new JTextField();
        this.destdir.setEditable(false);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        panel.add((Component)new JLabel("Temporary Directory"), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        panel.add((Component)this.tempdir, gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        panel.add((Component)this.br1, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        panel.add((Component)new JLabel("Destination Directory"), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        panel.add((Component)this.destdir, gc);
        gc.weightx = 0.0;
        gc.gridx = 1;
        gc.gridy = 3;
        gc.gridwidth = 1;
        panel.add((Component)this.br2, gc);
        this.saveto.add(panel);
        this.saveto.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Save To"));
    }

    void createConnectionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        panel.add((Component)new JLabel("Connection per download:"), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        panel.add((Component)this.c, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        panel.add((Component)new JLabel("Connection timeout:"), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        panel.add((Component)this.t, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        panel.add((Component)new JLabel("Tcp Window Size(KB):"), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        panel.add((Component)this.buf, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.compress = new JCheckBox("Enable compression");
        panel.add((Component)this.compress, gc);
        this.connection.add(panel);
        this.connection.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Connection"));
    }

    void createGeneralPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        panel.add((Component)this.chk1, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        panel.add((Component)this.chk2, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        panel.add((Component)this.chk3, gc);
        if (!MainWindow.hasTrayIcon) {
            this.chk3.setEnabled(false);
        }
        this.allowBrowser = new JCheckBox("Allow the browser to download if you press cancel");
        gc.gridx = 0;
        gc.gridy = 3;
        panel.add((Component)this.allowBrowser, gc);
        this.general.add(panel);
        this.general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General"));
    }

    void createAdvancedPanel() {
        this.antivir = new JButton("Browse");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        panel.add((Component)new JLabel("When download completes:"), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        panel.add((Component)this.cmdChk, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        panel.add((Component)this.cmd1, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 2;
        panel.add((Component)this.mdmChk, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 2;
        panel.add((Component)this.cmd2, gc);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 2;
        panel.add((Component)this.haltChk, gc);
        gc.gridx = 0;
        gc.gridy = 6;
        gc.gridwidth = 2;
        panel.add((Component)this.cmd3, gc);
        gc.gridx = 0;
        gc.gridy = 7;
        gc.gridwidth = 2;
        panel.add((Component)this.antiChk, gc);
        gc.gridx = 0;
        gc.gridy = 8;
        gc.gridwidth = 1;
        panel.add((Component)this.cmd4, gc);
        gc.gridx = 1;
        gc.gridy = 8;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        panel.add((Component)this.antivir, gc);
        this.cmdChk.addActionListener(this);
        this.mdmChk.addActionListener(this);
        this.haltChk.addActionListener(this);
        this.antiChk.addActionListener(this);
        this.antivir.addActionListener(this);
        this.advanced.add(new JScrollPane(panel));
        this.advanced.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Advanced"));
    }

    void createProxyPanel() {
        JPanel p = new JPanel(new GridLayout(4, 1));
        JPanel http = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        this.useHttpProxy = new JCheckBox("Use HTTP Proxy");
        this.useHttpProxy.addActionListener(this);
        gc.gridwidth = 7;
        http.add((Component)this.useHttpProxy, gc);
        gc.gridy = 1;
        gc.gridwidth = 1;
        http.add((Component)new JLabel("Host"), gc);
        this.httpProxy = new JTextField();
        gc.gridx = 1;
        gc.weightx = 1.0;
        http.add((Component)this.httpProxy, gc);
        gc.gridx = 2;
        gc.weightx = 0.0;
        http.add((Component)new JLabel("Port"), gc);
        this.httpPort = new JTextField();
        gc.gridx = 3;
        gc.weightx = 0.5;
        http.add((Component)this.httpPort, gc);
        gc.gridx = 4;
        gc.weightx = 0.0;
        http.add((Component)new JLabel("USER"), gc);
        this.httpUser = new JTextField();
        gc.gridx = 5;
        gc.weightx = 1.0;
        http.add((Component)this.httpUser, gc);
        gc.weightx = 0.0;
        gc.gridx = 6;
        http.add((Component)new JLabel("PASS"), gc);
        this.httpPass = new JTextField();
        gc.weightx = 1.0;
        gc.gridx = 7;
        http.add((Component)this.httpPass, gc);
        http.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "HTTP"));
        p.add(http);
        JPanel https = new JPanel(new GridBagLayout());
        gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        this.useHttpsProxy = new JCheckBox("Use HTTPS Proxy");
        this.useHttpsProxy.addActionListener(this);
        gc.gridwidth = 7;
        https.add((Component)this.useHttpsProxy, gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        https.add((Component)new JLabel("Host"), gc);
        this.httpsProxy = new JTextField();
        gc.gridx = 1;
        gc.weightx = 1.0;
        https.add((Component)this.httpsProxy, gc);
        gc.gridx = 2;
        gc.weightx = 0.0;
        https.add((Component)new JLabel("Port"), gc);
        this.httpsPort = new JTextField();
        gc.gridx = 3;
        gc.weightx = 0.5;
        https.add((Component)this.httpsPort, gc);
        gc.gridx = 4;
        gc.weightx = 0.0;
        https.add((Component)new JLabel("USER"), gc);
        this.httpsUser = new JTextField();
        gc.gridx = 5;
        gc.weightx = 1.0;
        https.add((Component)this.httpsUser, gc);
        gc.weightx = 0.0;
        gc.gridx = 6;
        https.add((Component)new JLabel("PASS"), gc);
        this.httpsPass = new JTextField();
        gc.weightx = 1.0;
        gc.gridx = 7;
        https.add((Component)this.httpsPass, gc);
        https.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "HTTPS"));
        p.add(https);
        JPanel ftp = new JPanel(new GridBagLayout());
        gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        this.useFtpProxy = new JCheckBox("Use FTP Proxy");
        this.useFtpProxy.addActionListener(this);
        gc.gridwidth = 7;
        ftp.add((Component)this.useFtpProxy, gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        ftp.add((Component)new JLabel("Host"), gc);
        this.ftpProxy = new JTextField();
        gc.gridx = 1;
        gc.weightx = 1.0;
        ftp.add((Component)this.ftpProxy, gc);
        gc.gridx = 2;
        gc.weightx = 0.0;
        ftp.add((Component)new JLabel("Port"), gc);
        this.ftpPort = new JTextField();
        gc.gridx = 3;
        gc.weightx = 0.5;
        ftp.add((Component)this.ftpPort, gc);
        gc.gridx = 4;
        gc.weightx = 0.0;
        ftp.add((Component)new JLabel("USER"), gc);
        this.ftpUser = new JTextField();
        gc.gridx = 5;
        gc.weightx = 1.0;
        ftp.add((Component)this.ftpUser, gc);
        gc.weightx = 0.0;
        gc.gridx = 6;
        ftp.add((Component)new JLabel("PASS"), gc);
        this.ftpPass = new JTextField();
        gc.weightx = 1.0;
        gc.gridx = 7;
        ftp.add((Component)this.ftpPass, gc);
        ftp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "FTP"));
        p.add(ftp);
        JPanel bypass = new JPanel(new GridBagLayout());
        gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        this.bypassProxy = new JTextField();
        gc.weightx = 1.0;
        gc.gridwidth = 4;
        bypass.add((Component)this.bypassProxy, gc);
        gc.gridy = 1;
        bypass.add((Component)new JLabel("Separate names by spaces"), gc);
        bypass.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Do NOT use proxy for following hosts"));
        p.add(bypass);
        p.add(bypass);
        this.proxyPanel.add(new JScrollPane(p));
        this.proxyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Proxy"));
    }

    void createFileTypesPanel() {
        this.fileTypes = new JTextArea();
        this.fileTypes.setWrapStyleWord(true);
        this.fileTypes.setLineWrap(true);
        this.fileTypesPanel.add((Component)new JLabel("Capture download for following file types:"), "North");
        this.fileTypesPanel.add(new JScrollPane(this.fileTypes));
        this.fileTypes.setBorder(BorderFactory.createBevelBorder(1));
        this.defaults = new JButton("Defaults");
        this.defaults.addActionListener(this);
        this.fileTypesPanel.add((Component)this.defaults, "South");
    }

    void createAuthPanel() {
        JPanel p = new JPanel(new BorderLayout());
        this.model = new CreditentialTableModel();
        Authenticator.getInstance().addObserver(this.model);
        this.table = new JTable(this.model);
        p.add(new JScrollPane(this.table));
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        this.addAuth = new JButton("Add");
        b.add(this.addAuth);
        this.addAuth.addActionListener(this);
        b.add(Box.createHorizontalStrut(10));
        this.removeAuth = new JButton("Remove");
        this.removeAuth.addActionListener(this);
        b.add(this.removeAuth);
        b.add(Box.createHorizontalStrut(10));
        this.editAuth = new JButton("Edit");
        this.editAuth.addActionListener(this);
        b.add(this.editAuth);
        b.add(Box.createHorizontalStrut(10));
        this.authPanel.add(p);
        this.authPanel.add((Component)b, "South");
        this.authPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sites Logins"));
    }

    private void createSchedulePanel() {
        this.schedulePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scheduler"));
        this.schedule = new JCheckBox("Enable Scheduler");
        this.schedule.addActionListener(this);
        this.schedulePanel.add((Component)this.schedule, "North");
        this.start = new SpinnerDateModel();
        this.end = new SpinnerDateModel();
        this.startDate = new JSpinner(this.start);
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, "dd-MMM HH:mm"));
        this.endDate = new JSpinner(this.end);
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, "dd-MMM HH:mm"));
        JPanel center = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        center.add((Component)new JLabel("Start Queue Processing at:"), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        center.add((Component)this.startDate, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        center.add((Component)new JLabel("Stop Queue Processing at:"), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        center.add((Component)this.endDate, gc);
        this.schedulePanel.add(center);
    }

    void chkTxt() {
        if (this.haltChk.isSelected()) {
            this.haltChk.setSelected(this.cmd2.getText().length() > 0);
        }
        if (this.cmdChk.isSelected()) {
            this.cmdChk.setSelected(this.cmd1.getText().length() > 0);
        }
        if (this.antiChk.isSelected()) {
            this.antiChk.setSelected(this.cmd4.getText().length() > 0);
        }
        if (this.mdmChk.isSelected()) {
            this.mdmChk.setSelected(this.cmd3.getText().length() > 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String host;
        Credential c;
        if (e.getSource() == this.schedule) {
            this.startDate.setEnabled(this.schedule.isSelected());
            this.endDate.setEnabled(this.schedule.isSelected());
        }
        if (e.getSource() == this.ok) {
            if (!this.chkVal()) {
                System.out.println("ERROR");
                return;
            }
            this.chkTxt();
            this.applyConfig();
            this.config.save();
            Authenticator.getInstance().save();
            this.setVisible(false);
        }
        if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
        if (e.getSource() == this.br1) {
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(1);
            if (this.fc.showSaveDialog(this) == 0) {
                this.tempdir.setText(this.fc.getSelectedFile().getAbsolutePath());
            }
        }
        if (e.getSource() == this.br2) {
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(1);
            if (this.fc.showSaveDialog(this) == 0) {
                this.destdir.setText(this.fc.getSelectedFile().getAbsolutePath());
            }
        }
        if (e.getSource() == this.useHttpProxy) {
            this.applyHttpProxyConfig();
        }
        if (e.getSource() == this.useHttpsProxy) {
            this.applyHttpsProxyConfig();
        }
        if (e.getSource() == this.useFtpProxy) {
            this.applyFtpProxyConfig();
        }
        if (e.getSource() == this.addAuth && (c = this.getCredential(true)) != null) {
            Authenticator.getInstance().addCreditential(c);
        }
        if (e.getSource() == this.removeAuth) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            host = "" + this.model.getValueAt(index, 0);
            Authenticator.getInstance().removeCreditential(host);
        }
        if (e.getSource() == this.editAuth) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            host = "" + this.model.getValueAt(index, 0);
            System.out.println("HOST: " + host);
            Credential c2 = Authenticator.getInstance().getCredential(host);
            System.out.println("CR: " + c2);
            if (this.host == null) {
                this.host = new JTextField();
            }
            this.host.setText(host);
            c2 = this.getCredential(false);
            if (c2 != null) {
                Authenticator.getInstance().addCreditential(c2);
            }
        }
        if (e.getSource() == this.defaults) {
            String types = "";
            int i = 0;
            while (i < this.config.defaultFileTypes.length) {
                types = String.valueOf(types) + this.config.defaultFileTypes[i] + " ";
                ++i;
            }
            this.fileTypes.setText(types);
        }
        if (e.getSource() == this.antivir) {
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(0);
            if (this.fc.showSaveDialog(this) == 0) {
                this.cmd4.setText(this.fc.getSelectedFile().getAbsolutePath());
            }
        }
    }

    Credential getCredential(boolean clear) {
        if (this.host == null) {
            this.host = new JTextField();
        }
        if (this.user == null) {
            this.user = new JTextField();
        }
        if (this.pass == null) {
            this.pass = new JTextField();
        }
        if (this.obj == null) {
            this.obj = new Object[6];
            this.obj[0] = "Host";
            this.obj[1] = this.host;
            this.obj[2] = "user";
            this.obj[3] = this.user;
            this.obj[4] = "pass";
            this.obj[5] = this.pass;
        }
        if (clear) {
            this.host.setText("");
            this.user.setText("");
            this.pass.setText("");
        }
        this.host.setEditable(clear);
        while (JOptionPane.showOptionDialog(null, this.obj, "Enter Creditential", 2, 3, null, null, null) == 0) {
            if (this.host.getText() == null || this.host.getText().length() < 1) {
                JOptionPane.showMessageDialog(null, "Enter Host");
                continue;
            }
            if (this.user.getText() == null || this.user.getText().length() < 1) {
                JOptionPane.showMessageDialog(null, "Enter username");
                continue;
            }
            if (this.pass.getText() == null || this.pass.getText().length() < 1) {
                JOptionPane.showMessageDialog(null, "Enter password");
                continue;
            }
            Credential c = new Credential();
            c.host = this.host.getText();
            c.user = this.user.getText();
            c.pass = this.pass.getText();
            return c;
        }
        return null;
    }

    void applyHttpProxyConfig() {
        boolean selected = this.useHttpProxy.isSelected();
        this.httpProxy.setEnabled(selected);
        this.httpPort.setEnabled(selected);
        this.httpUser.setEnabled(selected);
        this.httpPass.setEnabled(selected);
    }

    void applyHttpsProxyConfig() {
        boolean selected = this.useHttpsProxy.isSelected();
        this.httpsProxy.setEnabled(selected);
        this.httpsPort.setEnabled(selected);
        this.httpsUser.setEnabled(selected);
        this.httpsPass.setEnabled(selected);
    }

    void applyFtpProxyConfig() {
        boolean selected = this.useFtpProxy.isSelected();
        this.ftpProxy.setEnabled(selected);
        this.ftpPort.setEnabled(selected);
        this.ftpUser.setEnabled(selected);
        this.ftpPass.setEnabled(selected);
    }

    void showDialog() {
        this.showConfig();
        this.setVisible(true);
    }

    void showConfig() {
        this.chk1.setSelected(this.config.showDownloadPrgDlg);
        this.chk2.setSelected(this.config.showDownloadCompleteDlg);
        this.chk3.setSelected(this.config.showDownloadBox);
        this.act.setSelectedIndex(this.config.duplicateLinkAction);
        this.c.setSelectedItem(String.valueOf(this.config.maxConn));
        this.t.setValue(this.config.timeout);
        this.destdir.setText(this.config.destdir);
        this.tempdir.setText(this.config.tempdir);
        this.cmdChk.setSelected(this.config.executeCmd);
        this.antiChk.setSelected(this.config.antivir);
        this.haltChk.setSelected(this.config.halt);
        this.mdmChk.setSelected(this.config.hungUp);
        this.useHttpProxy.setSelected(this.config.useHttpProxy);
        this.useHttpsProxy.setSelected(this.config.useHttpsProxy);
        this.useFtpProxy.setSelected(this.config.useFtpProxy);
        this.applyHttpProxyConfig();
        this.applyFtpProxyConfig();
        this.applyHttpsProxyConfig();
        this.httpProxy.setText(this.config.httpProxyHost);
        this.httpPort.setText(String.valueOf(this.config.httpProxyPort));
        this.httpUser.setText(this.config.httpUser);
        this.httpPass.setText(this.config.httpPass);
        this.httpsProxy.setText(this.config.httpsProxyHost);
        this.httpsPort.setText(String.valueOf(this.config.httpsProxyPort));
        this.httpsUser.setText(this.config.httpsUser);
        this.httpsPass.setText(this.config.httpsPass);
        this.ftpProxy.setText(this.config.ftpProxyHost);
        this.ftpPort.setText(String.valueOf(this.config.ftpProxyPort));
        this.ftpUser.setText(this.config.ftpUser);
        this.ftpPass.setText(this.config.ftpPass);
        String[] arr = this.config.fileTypes;
        String types = "";
        int i = 0;
        while (i < arr.length) {
            types = String.valueOf(types) + arr[i] + " ";
            ++i;
        }
        this.fileTypes.setText(types);
        this.model.load();
        this.schedule.setSelected(this.config.schedule);
        this.startDate.setEnabled(this.config.schedule);
        this.endDate.setEnabled(this.config.schedule);
        if (this.config.startDate != null) {
            this.start.setValue(this.config.startDate);
        }
        if (this.config.endDate != null) {
            this.end.setValue(this.config.endDate);
        }
        this.cmd1.setText(this.config.cmdTxt);
        this.cmd4.setText(this.config.antivirTxt);
        this.cmd3.setText(this.config.hungUpTxt);
        this.cmd2.setText(this.config.haltTxt);
        this.allowBrowser.setSelected(this.config.allowbrowser);
        int v = this.config.tcpBuf / 1024;
        this.buf.setSelectedItem(String.valueOf(v));
        this.compress.setSelected(this.config.compress);
    }

    boolean chkVal() {
        try {
            if (this.useHttpProxy.isSelected()) {
                if (this.httpProxy.getText().length() < 1) {
                    throw new Exception("Host is empty");
                }
                Integer.parseInt(this.httpPort.getText());
            }
            if (this.useHttpsProxy.isSelected()) {
                if (this.httpsProxy.getText().length() < 1) {
                    throw new Exception("Host is empty");
                }
                Integer.parseInt(this.httpsPort.getText());
            }
            if (this.useFtpProxy.isSelected()) {
                if (this.ftpProxy.getText().length() < 1) {
                    throw new Exception("Host is empty");
                }
                Integer.parseInt(this.ftpPort.getText());
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Please enter numeric value");
            return false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Field can not be left blank");
            return false;
        }
        return true;
    }

    void applyConfig() {
        this.config.antivir = this.antiChk.isSelected();
        this.config.antivirTxt = this.cmd4.getText();
        this.config.cmdTxt = this.cmd1.getText();
        this.config.destdir = this.destdir.getText();
        this.config.tempdir = this.tempdir.getText();
        this.config.duplicateLinkAction = this.act.getSelectedIndex();
        this.config.executeCmd = this.cmdChk.isSelected();
        this.config.halt = this.haltChk.isSelected();
        this.config.haltTxt = this.cmd3.getText();
        this.config.hungUp = this.mdmChk.isSelected();
        this.config.hungUpTxt = this.cmd2.getText();
        this.config.maxConn = Integer.parseInt(this.c.getSelectedItem().toString());
        this.config.showDownloadBox = this.chk3.isSelected();
        this.config.showDownloadPrgDlg = this.chk1.isSelected();
        this.config.showDownloadCompleteDlg = this.chk2.isSelected();
        this.config.useHttpProxy = this.useHttpProxy.isSelected();
        this.config.useHttpsProxy = this.useHttpsProxy.isSelected();
        this.config.useFtpProxy = this.useFtpProxy.isSelected();
        this.config.httpProxyHost = this.httpProxy.getText();
        this.config.httpsProxyHost = this.httpsProxy.getText();
        this.config.ftpProxyHost = this.ftpProxy.getText();
        this.config.httpUser = this.httpUser.getText();
        this.config.httpsUser = this.httpsUser.getText();
        this.config.ftpUser = this.ftpUser.getText();
        this.config.httpPass = this.httpPass.getText();
        this.config.httpsPass = this.httpsPass.getText();
        this.config.ftpPass = this.ftpPass.getText();
        this.config.httpProxyPort = Integer.parseInt(this.httpPort.getText());
        this.config.httpsProxyPort = Integer.parseInt(this.httpsPort.getText());
        this.config.ftpProxyPort = Integer.parseInt(this.ftpPort.getText());
        this.config.tcpBuf = Integer.parseInt(this.buf.getSelectedItem().toString()) * 1024;
        ArrayList<String> lst = new ArrayList<String>();
        String[] arr = this.fileTypes.getText().replaceAll("\n", " ").split(" ");
        int i = 0;
        while (i < arr.length) {
            String t = arr[i].trim();
            if (t.length() > 0) {
                lst.add(t);
            }
            ++i;
        }
        this.config.fileTypes = new String[lst.size()];
        i = 0;
        while (i < lst.size()) {
            this.config.fileTypes[i] = (String)lst.get(i);
            ++i;
        }
        this.config.schedule = this.schedule.isSelected();
        this.config.startDate = this.start.getDate();
        this.config.endDate = this.end.getDate();
        this.config.allowbrowser = this.allowBrowser.isSelected();
        this.config.compress = this.compress.isSelected();
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object[] path = e.getPath().getPath();
        if (path.length > 0) {
            this.card.show(this.cardPanel, path[path.length - 1].toString());
        }
    }

    public static void main(String[] a) {
        new ConfigWindow(new XDMConfig(null), null).showDialog();
    }
}

