/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.sdg.xdman.proxy.IConnection;
import org.sdg.xdman.proxy.IConnectionListener;

public class HttpTableModel
extends AbstractTableModel
implements IConnectionListener {
    private static final long serialVersionUID = -4973440686633702921L;
    String[] cols = new String[]{"URL", "Application", "Type", "Length", "HTTP", "Host"};
    ArrayList<IConnection> arr = new ArrayList();

    public int getColumnCount() {
        return this.cols.length;
    }

    public int getRowCount() {
        return this.arr.size();
    }

    public String getColumnName(int c) {
        return this.cols[c];
    }

    public Object getValueAt(int r, int c) {
        try {
            IConnection cn = this.arr.get(r);
            switch (c) {
                case 0: {
                    return cn.getURL();
                }
                case 1: {
                    return cn.getApplication();
                }
                case 2: {
                    return cn.getContentType();
                }
                case 3: {
                    return cn.getContentLength();
                }
                case 4: {
                    return cn.getHTTPTYPE();
                }
                case 5: {
                    return cn.getHost();
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public void closed(IConnection c) {
        try {
            this.arr.remove(c);
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connected(IConnection c) {
        try {
            this.arr.add(c);
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(IConnection c) {
        try {
            int index = this.arr.indexOf(c);
            if (index != -1) {
                this.fireTableRowsUpdated(index, index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

