/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.util.XDMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTableModel
extends AbstractTableModel
implements Observer {
    DownloadList list = null;
    Icon q;
    private static final long serialVersionUID = -8936395745120671317L;
    final String[] cols = new String[]{"", "File Name", "Q", "Size", "Status", "Time left", "Transfer rate", "Last Try", "Description", "Date Added", "Save To", "URL", "Referer"};

    public void setList(DownloadList list) {
        this.list = list;
        this.fireTableDataChanged();
    }

    void setType(String type) {
        this.list.setType(type);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0 || col == 2) {
            return Icon.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.cols[col];
    }

    @Override
    public int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.list == null) {
            return "";
        }
        DownloadListItem item = this.list.get(row);
        if (this.q == null) {
            this.q = MainWindow.getIcon("q.png");
        }
        switch (col) {
            case 0: {
                return item.icon;
            }
            case 1: {
                return XDMUtil.nvl(item.filename);
            }
            case 2: {
                return item.q ? this.q : new ImageIcon();
            }
            case 3: {
                return XDMUtil.nvl(item.size);
            }
            case 4: {
                return XDMUtil.nvl(item.status);
            }
            case 5: {
                return XDMUtil.nvl(item.timeleft);
            }
            case 6: {
                return XDMUtil.nvl(item.transferrate);
            }
            case 7: {
                return XDMUtil.nvl(item.lasttry);
            }
            case 8: {
                return XDMUtil.nvl(item.description);
            }
            case 9: {
                return XDMUtil.nvl(item.dateadded);
            }
            case 10: {
                return XDMUtil.nvl(item.saveto);
            }
            case 11: {
                return XDMUtil.nvl(item.url);
            }
            case 12: {
                HashMap<String, String> hm = item.extra;
                if (hm == null) {
                    return "";
                }
                String ref = hm.get("referer");
                return ref == null ? "" : ref;
            }
        }
        return "";
    }

    @Override
    public void update(Observable o, Object obj) {
        DownloadListItem item = (DownloadListItem)o;
        if (this.list == null) {
            return;
        }
        int index = this.list.getIndex(item);
        if (index < 0) {
            return;
        }
        this.fireTableRowsUpdated(index, index);
    }
}

