/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.UnsupportedProtocolException;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.XDMHttpClient;
import org.sdg.xdman.gui.AboutDlg;
import org.sdg.xdman.gui.BatchDlg;
import org.sdg.xdman.gui.BatchDownloadDlg;
import org.sdg.xdman.gui.BatchDownloadListener;
import org.sdg.xdman.gui.BatchItem;
import org.sdg.xdman.gui.BrowserIntDlg;
import org.sdg.xdman.gui.ConfigWindow;
import org.sdg.xdman.gui.DownloadCompleteDialog;
import org.sdg.xdman.gui.DownloadFileInfoDialog;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.DownloadWindow;
import org.sdg.xdman.gui.DropBox;
import org.sdg.xdman.gui.DropListener;
import org.sdg.xdman.gui.FFIntDlg;
import org.sdg.xdman.gui.FileTransferHandler;
import org.sdg.xdman.gui.HelpDialog;
import org.sdg.xdman.gui.HttpMonitorDlg;
import org.sdg.xdman.gui.HttpTableModel;
import org.sdg.xdman.gui.IDownloadListener;
import org.sdg.xdman.gui.IXDMQueue;
import org.sdg.xdman.gui.IconUtil;
import org.sdg.xdman.gui.MainTableModel;
import org.sdg.xdman.gui.MediaGrabberWindow;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.gui.PropDlg;
import org.sdg.xdman.gui.RefreshLinkDlg;
import org.sdg.xdman.gui.ShutdownDlg;
import org.sdg.xdman.gui.YoutubeGrabberDlg;
import org.sdg.xdman.gui.YoutubeMediaListener;
import org.sdg.xdman.proxy.RequestHandler;
import org.sdg.xdman.proxy.RequestIntercepter;
import org.sdg.xdman.proxy.XDMHelper;
import org.sdg.xdman.proxy.XDMProxyServer;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.LinuxProxyUtil;
import org.sdg.xdman.util.MacUtil;
import org.sdg.xdman.util.XDMUtil;
import org.sdg.xdman.util.win.RegUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
extends JFrame
implements ActionListener,
TreeSelectionListener,
Observer,
IXDMQueue,
Runnable,
RequestIntercepter,
DropListener,
BatchDownloadListener,
YoutubeMediaListener {
    int windowState;
    XDMProxyServer server;
    private static final long serialVersionUID = -3846059297444673997L;
    Box toolbar;
    JButton addurl;
    JButton resume;
    JButton pause;
    JButton delete;
    JButton option;
    JButton youtube;
    JButton media;
    JButton exit;
    JLabel closetree;
    JSplitPane split;
    JTree tree;
    JTable table;
    MainTableModel model = new MainTableModel();
    static DownloadList list = null;
    static String tempdir;
    static String destdir;
    static String appdir;
    IDownloadListener dlistener;
    boolean stop = false;
    ConfigWindow cwin;
    static XDMConfig config;
    JMenuItem cat;
    Box statusBar;
    JToolBar browserBar;
    JLabel browser;
    JPanel content;
    JLabel catview;
    JLabel interceptview;
    MediaGrabberWindow mw;
    MediaTableModel mmodel;
    Toolkit t;
    JPopupMenu pop;
    PropDlg propDlg;
    DownloadListItem queuedItem;
    boolean queue;
    Thread scheduler;
    DownloadCompleteDialog completeDlg;
    ShutdownDlg sdlg;
    public static ImageIcon icon;
    boolean hasTray;
    AboutDlg abtDlg;
    Clipboard clipboard;
    RefreshLinkDlg rdlg;
    boolean haltPending = false;
    DropBox dropBox;
    HelpDialog view;
    BrowserIntDlg bint;
    HttpTableModel httpModel;
    HttpMonitorDlg httpDlg;
    BatchDownloadDlg batchDlg;
    BatchDlg bdlg;
    boolean proxyAttached = false;
    JLabel queueLabel;
    Icon qIcon;
    YoutubeGrabberDlg ytgdlg;
    public static String version;
    String updateURL = "http://xdman.sourceforge.net/update/update.php?v=30327";
    String homeURL = "http://xdman.sourceforge.net/";
    JPanel p;
    JMenuBar bar;
    long before;
    JPopupMenu trayPop;
    boolean showInfo;
    Object tray;
    Object trayIcon;
    PopupMenu pop2;
    static boolean hasTrayIcon;
    Popup popup;
    JFileChooser fc;
    FFIntDlg ffdlg;
    DefaultListModel ffmodel;
    static boolean mod_xdm;
    static boolean first_run;

    static {
        destdir = tempdir = System.getProperty("user.home");
        appdir = tempdir;
        version = "Version: 3.03 Build 27 (Feb 4, 2014)";
        hasTrayIcon = false;
        mod_xdm = false;
        first_run = false;
    }

    public MainWindow(DownloadList list) {
        icon = MainWindow.getIcon("icon.png");
        MainWindow.list = list;
        this.dlistener = list;
        this.createWindow();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MainWindow.this.shutdownHook();
            }
        });
        this.windowState = this.getState();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (MainWindow.this.getState() != 1) {
                    MainWindow.this.windowState = MainWindow.this.getState();
                    System.out.println("State ICONIFIED: " + (MainWindow.this.windowState == 1));
                }
            }
        });
        XDMConfig.hasTray = this.hasTray = this.createTrayIcon();
        if (MainWindow.config.showDownloadBox) {
            this.dropBox.setVisible(true);
        }
    }

    void setList(DownloadList list, IDownloadListener l) {
        MainWindow.list = list;
        this.dlistener = l;
        this.model.setList(list);
    }

    void createWindow() {
        this.setTitle("Xtreme Download Manager");
        this.setIconImage(icon.getImage());
        this.content = new JPanel(new BorderLayout());
        this.browserBar = new JToolBar();
        this.add((Component)this.browserBar, "South");
        this.t = Toolkit.getDefaultToolkit();
        Dimension d = this.t.getScreenSize();
        int w = 700;
        int h = 400;
        if (d.width < w) {
            w = d.width;
        }
        if (d.height < h) {
            h = d.height;
        }
        this.setSize(w, h);
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.createToolbar();
        this.createMenu();
        this.split = new JSplitPane(1);
        this.split.setDividerLocation(this.getWidth() / 5);
        this.split.setDividerSize(2);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        p.add(this.split);
        this.content.add(p);
        this.add(this.content);
        this.createTreePane();
        this.createTable();
        this.createBrowserBar();
    }

    void createTreePane() {
        this.p = new JPanel(new BorderLayout());
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        JLabel top = new JLabel("Catagories", 0);
        top.setFont(new Font("DIALOG", 0, 12));
        b.add(top);
        this.closetree = new JLabel(MainWindow.getIcon("close.png"));
        this.closetree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                MainWindow.this.hideCatagory();
                MainWindow.this.cat.setText("Show Catagory");
            }
        });
        b.add(Box.createHorizontalGlue());
        b.add(this.closetree);
        this.p.add((Component)b, "North");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Downloads");
        DefaultMutableTreeNode unfinished = new DefaultMutableTreeNode("Unfinished");
        String[] types = new String[]{"Compressed", "Documents", "Music", "Programs", "Video"};
        DefaultMutableTreeNode all = new DefaultMutableTreeNode("All");
        int i = 0;
        while (i < types.length) {
            all.add(new DefaultMutableTreeNode(types[i]));
            ++i;
        }
        root.add(all);
        i = 0;
        while (i < types.length) {
            unfinished.add(new DefaultMutableTreeNode(types[i]));
            ++i;
        }
        root.add(unfinished);
        DefaultMutableTreeNode finished = new DefaultMutableTreeNode("Finished");
        int i2 = 0;
        while (i2 < types.length) {
            finished.add(new DefaultMutableTreeNode(types[i2]));
            ++i2;
        }
        root.add(finished);
        this.tree = new JTree(root);
        this.tree.addTreeSelectionListener(this);
        this.p.add(new JScrollPane(this.tree));
        this.split.add((Component)this.p, "left");
    }

    void createTable() {
        this.table = new JTable(this.model);
        this.table.setTransferHandler(new FileTransferHandler());
        this.table.setDragEnabled(true);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 3) {
                    if (MainWindow.this.pop == null) {
                        MainWindow.this.createPop();
                    }
                    MainWindow.this.pop.show(MainWindow.this.table, me.getX(), me.getY());
                }
            }
        });
        this.model.setList(list);
        Java6Util.jtable$setAutoCreateRowSorter(this.table);
        this.table.setAutoResizeMode(0);
        this.table.setShowGrid(false);
        TableColumnModel cm = this.table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            if (c.getHeaderValue().equals("")) {
                c.setPreferredWidth(20);
            } else if (c.getHeaderValue().equals("File Name")) {
                c.setPreferredWidth(200);
            } else if (c.getHeaderValue().equals("Q")) {
                c.setPreferredWidth(50);
            } else {
                c.setPreferredWidth(100);
            }
            ++i;
        }
        JScrollPane jsp = new JScrollPane(this.table);
        if (!Java6Util.jtable$setFillsViewportHeight(this.table, true)) {
            jsp.getViewport().setBackground(this.table.getBackground());
            jsp.getViewport().setOpaque(false);
            jsp.setBackground(this.table.getBackground());
        }
        this.split.add((Component)jsp, "right");
    }

    void createBrowserBar() {
        this.browserBar.setFloatable(false);
        this.catview = new JLabel("[Downloads]");
        String status = mod_xdm ? "ON (" + MainWindow.config.port + ")" : "OFF";
        this.interceptview = new JLabel("Download Grabber: " + status);
        this.browser = new JLabel("No Browser Detected");
        this.browser.setToolTipText("Click Here for more information...");
        this.browser.setIcon(MainWindow.getIcon("hlp.png"));
        this.browser.setCursor(new Cursor(12));
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browserBar.add(this.browser);
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browserBar.add(new JLabel(MainWindow.getIcon("sep.png")));
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browserBar.add(this.interceptview);
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browserBar.add(new JLabel(MainWindow.getIcon("sep.png")));
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browserBar.add(this.catview);
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browserBar.add(new JLabel(MainWindow.getIcon("sep.png")));
        this.browserBar.add(Box.createHorizontalGlue());
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.queueLabel = new JLabel();
        this.browserBar.add(this.queueLabel);
        this.browserBar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.browser.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MainWindow.this.showBrowserStatus();
            }
        });
    }

    void createToolbar() {
        this.toolbar = Box.createHorizontalBox();
        Box p = Box.createHorizontalBox();
        this.addurl = new JButton("Add URL", MainWindow.getIcon("add.png"));
        this.addurl.setRolloverIcon(MainWindow.getIcon("add_r.png"));
        this.addurl.addActionListener(this);
        this.decorateButton(this.addurl);
        p.add(this.addurl);
        this.delete = new JButton("Delete", MainWindow.getIcon("remove.png"));
        this.delete.setRolloverIcon(MainWindow.getIcon("remove_r.png"));
        this.delete.addActionListener(this);
        this.decorateButton(this.delete);
        p.add(this.delete);
        this.resume = new JButton("Resume", MainWindow.getIcon("resume.png"));
        this.resume.setRolloverIcon(MainWindow.getIcon("resume_r.png"));
        this.resume.addActionListener(this);
        this.decorateButton(this.resume);
        p.add(this.resume);
        this.pause = new JButton("Pause", MainWindow.getIcon("pause.png"));
        this.pause.setRolloverIcon(MainWindow.getIcon("pause_r.png"));
        this.pause.addActionListener(this);
        this.decorateButton(this.pause);
        p.add(this.pause);
        this.option = new JButton("Options", MainWindow.getIcon("settings.png"));
        this.option.setRolloverIcon(MainWindow.getIcon("settings_r.png"));
        this.option.addActionListener(this);
        this.decorateButton(this.option);
        p.add(this.option);
        this.media = new JButton("Grabber", MainWindow.getIcon("media.png"));
        this.media.setRolloverIcon(MainWindow.getIcon("media_r.png"));
        this.media.addActionListener(this);
        this.decorateButton(this.media);
        p.add(this.media);
        this.youtube = new JButton("YouTube", MainWindow.getIcon("ytd.png"));
        this.youtube.setRolloverIcon(MainWindow.getIcon("ytd_r.png"));
        this.youtube.addActionListener(this);
        this.decorateButton(this.youtube);
        p.add(this.youtube);
        this.exit = new JButton("Exit", MainWindow.getIcon("exit.png"));
        this.exit.setRolloverIcon(MainWindow.getIcon("exit_r.png"));
        this.exit.addActionListener(this);
        this.decorateButton(this.exit);
        p.add(this.exit);
        p.add(Box.createHorizontalGlue());
        this.toolbar.add(p);
        this.toolbar.add(Box.createHorizontalGlue());
        this.content.add((Component)this.toolbar, "North");
    }

    void createMenu() {
        this.bar = new JMenuBar();
        this.bar.add(Box.createRigidArea(new Dimension(10, 0)));
        JMenu file = new JMenu("File");
        JMenuItem add = new JMenuItem("Add URL");
        add.addActionListener(this);
        file.add(add);
        JMenuItem ytgrab = new JMenuItem("YouTube Downloader");
        ytgrab.addActionListener(this);
        file.add(ytgrab);
        JMenuItem batchClip = new JMenuItem("Add from clipboard");
        batchClip.addActionListener(this);
        file.add(batchClip);
        JMenuItem batch = new JMenuItem("Batch download");
        batch.addActionListener(this);
        file.add(batch);
        JMenuItem link = new JMenuItem("Create Shortcut");
        link.addActionListener(this);
        file.add(link);
        JMenuItem grab = new JMenuItem("Grabber");
        grab.addActionListener(this);
        file.add(grab);
        JMenuItem del = new JMenuItem("Delete");
        del.addActionListener(this);
        file.add(del);
        JMenuItem delc = new JMenuItem("Delete Completed");
        delc.addActionListener(this);
        file.add(delc);
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(this);
        file.add(exit);
        JMenu dwn = new JMenu("Download");
        dwn.addActionListener(this);
        JMenuItem pause = new JMenuItem("Pause");
        pause.addActionListener(this);
        dwn.add(pause);
        JMenuItem resume = new JMenuItem("Resume");
        resume.addActionListener(this);
        dwn.add(resume);
        JMenuItem restart = new JMenuItem("Restart");
        restart.addActionListener(this);
        dwn.add(restart);
        JMenuItem startQ = new JMenuItem("Start Queue");
        startQ.addActionListener(this);
        dwn.add(startQ);
        JMenuItem stopQ = new JMenuItem("Stop Queue");
        stopQ.addActionListener(this);
        dwn.add(stopQ);
        JMenu view = new JMenu("Tools");
        JMenuItem option = new JMenuItem("Options");
        option.addActionListener(this);
        view.add(option);
        JMenuItem prop = new JMenuItem("Properties");
        prop.addActionListener(this);
        view.add(prop);
        this.cat = new JMenuItem("Hide Catagory");
        view.add(this.cat);
        this.cat.addActionListener(this);
        JMenuItem refresh = new JMenuItem("Refresh Link");
        refresh.addActionListener(this);
        view.add(refresh);
        JMenuItem test = new JMenuItem("Test Browser");
        test.addActionListener(this);
        view.add(test);
        JMenuItem http = new JMenuItem("HTTP Monitor");
        http.addActionListener(this);
        view.add(http);
        JMenuItem bint = new JMenuItem("Browser Integration");
        bint.addActionListener(this);
        view.add(bint);
        JMenu help = new JMenu("help");
        JMenuItem hvid = new JMenuItem("Capturing videos");
        hvid.addActionListener(this);
        help.add(hvid);
        JMenuItem abi = new JMenuItem("Capturing downloads");
        abi.addActionListener(this);
        help.add(abi);
        JMenuItem hpg = new JMenuItem("XDM Home page");
        hpg.addActionListener(this);
        help.add(hpg);
        JMenuItem updt = new JMenuItem("Check for update");
        updt.addActionListener(this);
        help.add(updt);
        JMenuItem abt = new JMenuItem("About XDM");
        abt.addActionListener(this);
        help.add(abt);
        this.bar.add(file);
        this.bar.add(dwn);
        this.bar.add(view);
        this.bar.add(help);
        this.setJMenuBar(this.bar);
        this.bar.add(Box.createHorizontalGlue());
    }

    static ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(MainWindow.class.getResource("/res/" + name));
        }
        catch (Exception e) {
            return new ImageIcon("res/" + name);
        }
    }

    void shutdownHook() {
        if (this.proxyAttached) {
            System.out.println("restore proxy");
            if (XDMHelper.helperAvail()) {
                XDMHelper.terminate();
            }
        }
        System.out.println("ShutdownHook...");
        System.out.println("Stopping server");
        this.server.stop();
        System.out.println("Stopping server...done");
    }

    void decorateButton(JButton b) {
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        b.setContentAreaFilled(false);
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
    }

    DownloadListItem getSelectedItem() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return null;
        }
        index = Java6Util.jtable$convertRowIndexToModel(this.table, index);
        return list.get(index);
    }

    int getSelectedItemIndex() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        index = Java6Util.jtable$convertRowIndexToModel(this.table, index);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        DownloadListItem item;
        Object url;
        DownloadFileInfoDialog dfi;
        String str = e.getActionCommand();
        if (str.equals("Add URL")) {
            this.addURL(null, null, null, null);
        }
        if (str.equals("Download Later")) {
            dfi = (DownloadFileInfoDialog)e.getSource();
            if (dfi.interceptor != null) {
                ((RequestHandler)dfi.interceptor).intercept = true;
                DownloadFileInfoDialog downloadFileInfoDialog = dfi;
                synchronized (downloadFileInfoDialog) {
                    dfi.notifyAll();
                }
            }
            url = dfi.getURL();
            String user = dfi.getUser();
            String pass = dfi.getPass();
            HashMap<String, String> extra = dfi.extra;
            if (user.length() > 0) {
                try {
                    if (extra == null) {
                        extra = new HashMap();
                    }
                    extra.put("USER", user);
                    extra.put("PASS", pass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DownloadListItem item2 = new DownloadListItem();
            item2.dateadded = new Date().toString();
            item2.lasttry = new Date().toString();
            item2.q = true;
            item2.url = url;
            item2.extra = extra;
            item2.filename = dfi.getFile();
            item2.icon = IconUtil.getIcon(XDMUtil.findCategory(item2.filename));
            item2.saveto = dfi.getDir();
            item2.cookies = dfi.cookies;
            list.add(item2);
            this.model.fireTableDataChanged();
        }
        if (str.equals("Download Now")) {
            dfi = (DownloadFileInfoDialog)e.getSource();
            if (dfi.interceptor != null) {
                ((RequestHandler)dfi.interceptor).intercept = true;
                url = dfi;
                synchronized (url) {
                    dfi.notifyAll();
                }
            }
            url = dfi.getURL();
            String file = dfi.getFile();
            String dir = dfi.getDir();
            String user = dfi.getUser();
            String pass = dfi.getPass();
            HashMap<String, String> extra = dfi.extra;
            if (user.length() > 0) {
                try {
                    if (extra == null) {
                        extra = new HashMap();
                    }
                    extra.put("USER", user);
                    extra.put("PASS", pass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.addDownload((String)url, file, dir, tempdir, list, dfi.client, extra, dfi.cookies);
        }
        if (str.equals("Delete")) {
            this.removeDownloads();
        }
        if (str.equals("Resume")) {
            item = this.getSelectedItem();
            if (item == null) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            System.out.println(item.state);
            if (item.mgr == null && item.state != 50) {
                item.lasttry = new Date().toString();
                if (item.tempdir.equals("")) {
                    this.startDownload(item.url, item.filename, item.saveto, tempdir, item, null, item.extra, item.cookies);
                } else {
                    ConnectionManager c = new ConnectionManager(item.url, item.filename, item.saveto, item.tempdir, item.extra, config);
                    c.setTimeOut(MainWindow.config.timeout);
                    c.setMaxConn(MainWindow.config.maxConn);
                    if (MainWindow.config.showDownloadPrgDlg) {
                        DownloadWindow w = new DownloadWindow(c);
                        c.addObserver(w);
                        w.showWindow();
                        item.window = w.window;
                    }
                    item.setCallback(c, this.model, this.dlistener);
                    item.addObserver(this);
                    c.resume();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Download is currently active or finished");
            }
        }
        if (str.equals("Restart")) {
            item = this.getSelectedItem();
            if (item == null) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            System.out.println(item.state);
            if (item.mgr == null) {
                this.startDownload(item.url, item.filename, item.saveto, tempdir, item, null, item.extra, item.cookies);
            } else {
                JOptionPane.showMessageDialog(this, "Download is currently active");
            }
        }
        if (str.equals("Pause")) {
            item = this.getSelectedItem();
            if (item == null) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            if (item.mgr != null) {
                item.mgr.stop();
            } else {
                JOptionPane.showMessageDialog(this, "Download is not active.");
            }
        }
        if (str.equals("Options")) {
            if (this.cwin == null) {
                this.cwin = new ConfigWindow(config, this);
            }
            this.cwin.setLocationRelativeTo(this);
            this.cwin.showDialog();
        }
        if (str.equals("Show Catagory")) {
            this.showCatagory();
            this.cat.setText("Hide Catagory");
        }
        if (str.equals("Hide Catagory")) {
            this.hideCatagory();
            this.cat.setText("Show Catagory");
        }
        if (str.equals("Grabber")) {
            if (this.mw == null) {
                this.mw = new MediaGrabberWindow(this.mmodel, this);
            }
            this.mw.setLocationRelativeTo(this);
            this.mw.setVisible(true);
        }
        if (str.equals("Properties")) {
            this.showProp();
        }
        if (str.equals("Open")) {
            this.openFile();
        }
        if (str.equals("Open Folder")) {
            this.openFolder();
        }
        if (str.equals("Firefox Integration")) {
            this.showFFDlg();
        }
        if (str.equals("Browser Integration")) {
            this.showBrowserIntegrationDlg();
        }
        if (str.equals("Show/Hide Window")) {
            System.out.println("SHOW?HIDE WINDOW");
            this.showDownloadWindow();
        }
        if (str.equals("Start Queue")) {
            if (this.queue) {
                JOptionPane.showMessageDialog(this, "Queue already started");
                return;
            }
            this.startQ();
        }
        if (str.equals("Stop Queue")) {
            if (!this.queue) {
                JOptionPane.showMessageDialog(this, "Queue already stopped");
                return;
            }
            this.stopQ();
        }
        if (str.equals("Exit")) {
            this.dlistener.downloadStateChanged();
            config.save();
            System.exit(0);
        }
        if (str.equals("About XDM")) {
            this.showAboutDialog();
        }
        if (str.equals("Restore")) {
            this.restore();
        }
        if (str.equals("Delete Completed")) {
            this.removeCompleteDownloads();
        }
        if (str.equals("Copy URL") && (item = this.getSelectedItem()) != null) {
            this.copyURL(item.url);
        }
        if (str.equals("Copy File")) {
            this.copyPath();
        }
        if (str.equals("Create Shortcut")) {
            if (File.separatorChar == '\\') {
                this.winCreateLink();
            } else {
                this.linuxCreateLink();
            }
        }
        if (str.equals("Refresh Link")) {
            item = this.getSelectedItem();
            if (item != null) {
                HashMap<String, String> hm = item.extra;
                String ref = hm == null ? "" : hm.get("referer");
                if (this.rdlg == null) {
                    this.rdlg = new RefreshLinkDlg(this);
                }
                this.rdlg.setLocationRelativeTo(this);
                this.rdlg.showDlg(item, ref);
            } else {
                JOptionPane.showMessageDialog(this, "No item Selected.");
            }
        }
        if (str.equals("Test Browser")) {
            this.testBrowser();
        }
        if (str.equals("Copy")) {
            this.copyURL("http://localhost:9614/test");
        }
        if (str.equals("Capturing downloads")) {
            try {
                if (this.view == null) {
                    this.view = this.getHTMLViwer();
                }
                this.view.setDocument(this.getClass().getResource("/help/browser_integration.html"));
                this.view.setVisible(true);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (str.equals("Capturing videos")) {
            try {
                if (this.view == null) {
                    this.view = this.getHTMLViwer();
                }
                this.view.setDocument(this.getClass().getResource("/help/video_download.html"));
                this.view.setVisible(true);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (str.equals("Run XDM on startup")) {
            JCheckBox chk = (JCheckBox)e.getSource();
            this.setAutoStart(chk.isSelected());
            System.out.println(chk.isSelected());
        }
        if (str.equals("Manual Configure")) {
            try {
                if (this.view == null) {
                    this.view = this.getHTMLViwer();
                }
                this.view.setDocument(this.getClass().getResource("/help/browser_integration.html"));
                this.view.setVisible(true);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (str.equals("HTTP Monitor")) {
            if (this.httpDlg == null) {
                this.httpDlg = new HttpMonitorDlg(this.httpModel);
                this.httpDlg.setSize(this.getSize());
            }
            this.httpDlg.setLocation(this.getLocation());
            this.httpDlg.setVisible(true);
        }
        if (str.equals("Save As")) {
            item = this.getSelectedItem();
            if (item == null) {
                JOptionPane.showMessageDialog(this, "No Item Selected.");
                return;
            }
            if (item.state == 50) {
                JOptionPane.showMessageDialog(this, "Can't change completed downloads");
                return;
            }
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(0);
            this.fc.setSelectedFile(new File(item.saveto, item.filename));
            if (this.fc.showSaveDialog(this) == 0) {
                if (item.state == 50 || item.state == 60) {
                    JOptionPane.showMessageDialog(this, "Can't change download property while it is almost complete");
                    return;
                }
                item.saveto = this.fc.getSelectedFile().getParent();
                item.filename = this.fc.getSelectedFile().getName();
                if (item.mgr != null) {
                    item.mgr.setDestdir(item.saveto);
                    item.mgr.setFileName(item.filename);
                }
                list.downloadStateChanged();
            }
        }
        if (str.equals("Add from clipboard")) {
            System.out.println("$$$$$$$$$");
            if (this.batchDlg == null) {
                this.batchDlg = new BatchDownloadDlg();
            }
            this.batchDlg.setLocationRelativeTo(null);
            this.batchDlg.showDialog(MainWindow.config.destdir, this);
        }
        if (str.equals("Batch download")) {
            if (this.bdlg == null) {
                this.bdlg = new BatchDlg();
            }
            this.bdlg.setLocationRelativeTo(null);
            this.bdlg.showDialog(this);
        }
        if (str.equals("YouTube Downloader")) {
            if (this.ytgdlg == null) {
                this.ytgdlg = new YoutubeGrabberDlg(this);
            }
            this.ytgdlg.setLocationRelativeTo(null);
            this.ytgdlg.showDialog(this, config, null);
        }
        if (str.equals("YouTube")) {
            if (this.ytgdlg == null) {
                this.ytgdlg = new YoutubeGrabberDlg(this);
            }
            this.ytgdlg.setLocationRelativeTo(null);
            this.ytgdlg.showDialog(this, config, null);
        }
        if (str.equals("Check for update")) {
            try {
                Java6Util.desktop$browse(new URI(this.updateURL));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (str.equals("XDM Home page")) {
            try {
                Java6Util.desktop$browse(new URI(this.homeURL));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    void restore() {
        this.setState(this.windowState);
        this.setVisible(true);
    }

    void addURL(String url, XDMHttpClient client, HashMap<String, String> map, String cookies) {
        this.addURL(url, client, map, cookies, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addURL(String url, XDMHttpClient client, HashMap<String, String> map, String cookies, Object invoker) {
        System.out.println("Called");
        DownloadFileInfoDialog dlg = new DownloadFileInfoDialog(this, this, config);
        dlg.setURL(url);
        dlg.setDir(MainWindow.config.destdir);
        dlg.client = client;
        dlg.extra = map;
        dlg.cookies = cookies;
        dlg.setAlwaysOnTop(true);
        dlg.showDlg();
        if (MainWindow.config.allowbrowser) {
            if (invoker != null) {
                dlg.interceptor = invoker;
                DownloadFileInfoDialog downloadFileInfoDialog = dlg;
                synchronized (downloadFileInfoDialog) {
                    try {
                        dlg.wait();
                        System.out.println("Returned Intercept? " + ((RequestHandler)invoker).intercept);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (invoker != null) {
            ((RequestHandler)invoker).intercept = true;
        }
    }

    void addDownload(String url, String fileName, String destdir, String tempdir, DownloadList lst, XDMHttpClient client, HashMap<String, String> extra, String cookies) {
        DownloadListItem item = new DownloadListItem();
        item.dateadded = new Date().toString();
        item.lasttry = new Date().toString();
        item.url = url;
        item.extra = extra;
        item.filename = fileName;
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.saveto = destdir;
        item.cookies = cookies;
        list.add(item);
        this.startDownload(url, fileName, destdir, tempdir, item, client, item.extra, cookies);
    }

    void startDownload(String url, String fileName, String destdir, String tempdir, DownloadListItem item, XDMHttpClient client, HashMap<String, String> extra, String cookies) {
        this.startDownload(url, fileName, destdir, tempdir, item, client, extra, cookies, true);
    }

    void startDownload(String url, String fileName, String destdir, String tempdir, DownloadListItem item, XDMHttpClient client, HashMap<String, String> extra, String cookies, boolean fg) {
        ConnectionManager c = new ConnectionManager(url, fileName, destdir, tempdir, extra, config);
        c.extra = extra;
        c.setTimeOut(MainWindow.config.timeout);
        c.setMaxConn(MainWindow.config.maxConn);
        if (MainWindow.config.showDownloadPrgDlg && fg) {
            DownloadWindow w = new DownloadWindow(c);
            c.addObserver(w);
            item.window = w.window;
            w.showWindow();
        }
        item.setCallback(c, this.model, this.dlistener);
        item.addObserver(this);
        this.model.fireTableDataChanged();
        this.dlistener.downloadStateChanged();
        if (client == null) {
            try {
                c.start();
            }
            catch (UnsupportedProtocolException e) {
                JOptionPane.showMessageDialog(this, "Unsupported protocol");
            }
        } else {
            try {
                c.start(client);
            }
            catch (UnsupportedProtocolException e) {
                JOptionPane.showMessageDialog(this, "Unsupported protocol");
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        System.out.println(e.getPath());
        String status = null;
        int state = 0;
        Object[] o = e.getPath().getPath();
        int i = 0;
        while (i < o.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o[i];
            System.out.println(node.toString());
            if (node.toString().equalsIgnoreCase("unfinished")) {
                state = 1;
            }
            if (node.toString().equalsIgnoreCase("finished")) {
                state = 50;
            }
            if (node.toString().equalsIgnoreCase("documents")) {
                status = "Documents";
            }
            if (node.toString().equalsIgnoreCase("compressed")) {
                status = "Compressed";
            }
            if (node.toString().equalsIgnoreCase("music")) {
                status = "Music";
            }
            if (node.toString().equalsIgnoreCase("programs")) {
                status = "Programs";
            }
            if (node.toString().equalsIgnoreCase("video")) {
                status = "Video";
            }
            list.setState(state);
            list.setType(status);
            this.catview.setText(e.getPath().toString());
            this.model.fireTableDataChanged();
            System.out.println("New State: " + state + " " + status);
            ++i;
        }
    }

    void removeDownload() {
        DownloadListItem item = this.getSelectedItem();
        if (item == null) {
            JOptionPane.showMessageDialog(this, "No item selected");
            return;
        }
        if (item.mgr != null) {
            JOptionPane.showMessageDialog(this, "The download is currently active.\nPlease stop the download then try again.");
            return;
        }
        list.remove(item);
        this.model.fireTableDataChanged();
        this.dlistener.downloadStateChanged();
    }

    void removeDownloads() {
        int count = this.table.getSelectedRowCount();
        System.out.println("Selected: " + count);
        if (count > 0) {
            DownloadListItem[] item = new DownloadListItem[count];
            int[] index = this.table.getSelectedRows();
            int i = 0;
            while (i < index.length) {
                index[i] = Java6Util.jtable$convertRowIndexToModel(this.table, index[i]);
                item[i] = list.get(index[i]);
                ++i;
            }
            i = 0;
            while (i < item.length) {
                boolean del = true;
                if (item[i].mgr == null) {
                    list.remove(item[i]);
                    String td = item[i].tempdir;
                    LinkedList<DownloadListItem> items = MainWindow.list.list;
                    if (items != null) {
                        int k = 0;
                        while (k < items.size()) {
                            if (((DownloadListItem)items.get((int)k)).tempdir.equals(td)) {
                                del = false;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (del) {
                        System.out.println("Deleting " + td + "...");
                        File dir = new File(td);
                        if (dir.exists()) {
                            File[] files = dir.listFiles();
                            int c = 0;
                            while (c < files.length) {
                                System.out.println("Deleting " + files[c] + " " + files[c].delete());
                                ++c;
                            }
                        }
                        System.out.println("Deleting " + dir + " " + dir.delete());
                    } else {
                        System.out.println("Not deleting ref exists");
                    }
                }
                ++i;
            }
            this.model.fireTableDataChanged();
        }
    }

    void removeCompleteDownloads() {
        LinkedList<DownloadListItem> lst = MainWindow.list.list;
        LinkedList<DownloadListItem> rl = new LinkedList<DownloadListItem>();
        int i = 0;
        while (i < lst.size()) {
            DownloadListItem item = (DownloadListItem)lst.get(i);
            if (item.state == 50) {
                rl.add((DownloadListItem)lst.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < rl.size()) {
            lst.remove(rl.get(i));
            ++i;
        }
        list.downloadStateChanged();
        this.model.fireTableDataChanged();
    }

    private void hideCatagory() {
        this.split.remove(this.p);
        this.validate();
        list.setState(0);
        list.setType(null);
        this.model.fireTableDataChanged();
    }

    private void showCatagory() {
        this.split.add(this.p);
        this.validate();
        list.setState(0);
        list.setType(null);
        this.model.fireTableDataChanged();
    }

    @Override
    public void update(Observable o, Object obj) {
        if (o == config) {
            if (MainWindow.config.showDownloadBox) {
                if (this.dropBox == null) {
                    this.dropBox = new DropBox(this, MainWindow.getIcon("icon32.png"), this.t.getScreenSize());
                }
                this.dropBox.setVisible(true);
            } else if (this.dropBox != null) {
                this.dropBox.setVisible(false);
            }
            System.out.println("Config updated...");
            if (MainWindow.config.tempdir != null && MainWindow.config.tempdir.length() > 0 && new File(MainWindow.config.tempdir).exists()) {
                tempdir = MainWindow.config.tempdir;
            }
            System.out.println("M_DESTDIR: " + destdir + "\nTEMpDIR: " + tempdir);
            System.out.println("C_DESTDIR: " + MainWindow.config.destdir + "\nTEMpDIR: " + MainWindow.config.tempdir);
            if (MainWindow.config.destdir != null && MainWindow.config.destdir.length() > 0 && new File(MainWindow.config.destdir).exists()) {
                destdir = MainWindow.config.destdir;
            }
            System.out.println("DESTDIR: " + destdir + "\nTEMpDIR: " + tempdir);
            if (MainWindow.config.schedule) {
                if (this.scheduler == null) {
                    this.scheduler = new Thread(this);
                    this.scheduler.start();
                    return;
                }
                if (!this.scheduler.isAlive()) {
                    this.scheduler = new Thread(this);
                    this.scheduler.start();
                }
            }
        }
        if (obj instanceof HashMap) {
            HashMap ht = (HashMap)obj;
            this.addURL((String)ht.get("URL"), null, (HashMap)ht.get("HT"), (String)ht.get("COOKIES"));
        }
        if (obj instanceof HashSet) {
            HashSet hs = (HashSet)obj;
            Iterator it = hs.iterator();
            System.out.println(hs + " " + hs.size());
            String txt = "Browser: ";
            if (hs.size() < 3) {
                if (hs.size() == 1) {
                    txt = String.valueOf(txt) + (String)it.next();
                }
                if (hs.size() == 2) {
                    txt = String.valueOf((String)it.next()) + " , " + (String)it.next();
                }
            } else {
                txt = String.valueOf(txt) + (String)it.next() + " , " + (String)it.next() + " & " + (hs.size() - 2) + " More";
            }
            this.browser.setText(txt);
            this.browser.setIcon(null);
        }
        if (o instanceof DownloadListItem) {
            long time;
            DownloadListItem item = (DownloadListItem)o;
            if (item.state == 50) {
                this.dlistener.downloadStateChanged();
                System.out.println("COMPLETE CALLBACK");
                if (this.queue) {
                    this.next();
                } else if (MainWindow.config.showDownloadCompleteDlg) {
                    if (this.completeDlg == null) {
                        this.completeDlg = new DownloadCompleteDialog();
                        this.completeDlg.setLocationRelativeTo(null);
                        this.completeDlg.setAlwaysOnTop(true);
                    }
                    this.completeDlg.setData(item.filename, item.url);
                    this.completeDlg.file_path = item.filename;
                    this.completeDlg.folder_path = item.saveto;
                    this.completeDlg.setVisible(true);
                }
                if (MainWindow.config.halt) {
                    if (MainWindow.config.haltTxt == null || MainWindow.config.haltTxt.length() < 1) {
                        return;
                    }
                    if (this.allFinished()) {
                        this.shutdownComputer(MainWindow.config.haltTxt);
                    } else {
                        this.haltPending = true;
                    }
                }
                File file = new File(item.saveto, item.filename);
                if (MainWindow.config.executeCmd) {
                    this.executeCommand(String.valueOf(MainWindow.config.cmdTxt) + " " + file);
                }
                if (MainWindow.config.hungUp) {
                    this.hungUp(MainWindow.config.hungUpTxt);
                }
                if (MainWindow.config.antivir) {
                    this.virusScan(String.valueOf(MainWindow.config.antivirTxt) + " " + file);
                }
            }
            if (item.state == 30) {
                this.dlistener.downloadStateChanged();
                System.out.println("FAILED CALLBACK");
                if (this.queue) {
                    item.q = false;
                    this.next();
                }
            }
            if (item.state != 30 && item.state != 50 && (time = System.currentTimeMillis()) - this.before > 30000L) {
                System.out.println("#############SAVING DOWNLOAD LIST####################");
                this.dlistener.downloadStateChanged();
                this.before = time;
            }
        }
    }

    private boolean allFinished() {
        int i = 0;
        while (i < MainWindow.list.list.size()) {
            int state = MainWindow.list.list.get((int)i).state;
            if (state != 40 || state != 50 || state != 30) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setConfig(XDMConfig c) {
        System.out.println("Setting config");
        config = c;
        if (config == null) {
            config = new XDMConfig(new File(appdir, ".xdmconf"));
        }
        if (MainWindow.config.tempdir == null || MainWindow.config.tempdir.length() < 1) {
            MainWindow.config.tempdir = tempdir;
        }
        if (MainWindow.config.destdir == null || MainWindow.config.destdir.length() < 1) {
            MainWindow.config.destdir = destdir;
        }
        System.out.println(config);
        if (MainWindow.config.tempdir != null && MainWindow.config.tempdir.length() > 0 && new File(MainWindow.config.tempdir).exists()) {
            tempdir = MainWindow.config.tempdir;
        }
        if (MainWindow.config.destdir != null && MainWindow.config.destdir.length() > 0 && new File(MainWindow.config.destdir).exists()) {
            destdir = MainWindow.config.destdir;
        }
        config.addObserver(this);
        if (MainWindow.config.schedule) {
            if (this.scheduler == null) {
                this.scheduler = new Thread(this);
                this.scheduler.start();
                return;
            }
            if (!this.scheduler.isAlive()) {
                this.scheduler = new Thread(this);
                this.scheduler.start();
            }
        }
    }

    void createPop() {
        this.pop = new JPopupMenu();
        JMenuItem m1 = new JMenuItem("Open");
        m1.addActionListener(this);
        this.pop.add(m1);
        JMenuItem m2 = new JMenuItem("Open Folder");
        m2.addActionListener(this);
        this.pop.add(m2);
        JMenuItem m32 = new JMenuItem("Save As");
        m32.addActionListener(this);
        this.pop.add(m32);
        this.pop.addSeparator();
        JMenuItem m16 = new JMenuItem("Show/Hide Window");
        m16.addActionListener(this);
        this.pop.add(m16);
        this.pop.addSeparator();
        JMenuItem m3 = new JMenuItem("Pause");
        m3.addActionListener(this);
        this.pop.add(m3);
        JMenuItem m4 = new JMenuItem("Resume");
        m4.addActionListener(this);
        this.pop.add(m4);
        JMenuItem m5 = new JMenuItem("Restart");
        m5.addActionListener(this);
        this.pop.add(m5);
        JMenuItem m6 = new JMenuItem("Remove");
        m6.addActionListener(this);
        this.pop.add(m6);
        JMenuItem m = new JMenuItem("Refresh Link");
        m.addActionListener(this);
        this.pop.add(m);
        this.pop.addSeparator();
        JMenuItem m7 = new JMenuItem("Copy URL");
        m7.addActionListener(this);
        this.pop.add(m7);
        JMenuItem m8 = new JMenuItem("Copy File");
        m8.addActionListener(this);
        this.pop.add(m8);
        this.pop.addSeparator();
        JMenuItem m9 = new JMenuItem("Properties");
        m9.addActionListener(this);
        this.pop.add(m9);
        this.pop.setInvoker(this.pop);
    }

    void showProp() {
        DownloadListItem item = this.getSelectedItem();
        if (item != null) {
            if (this.propDlg == null) {
                this.propDlg = new PropDlg(this);
                this.propDlg.pack();
            }
            this.propDlg.setLocationRelativeTo(this);
            this.propDlg.setDownloadProperty(item);
            this.propDlg.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "No item selected");
        }
    }

    private void openFile() {
        DownloadListItem item = this.getSelectedItem();
        if (item != null) {
            if (item.state == 50) {
                File file = new File(item.saveto, item.filename);
                if (file.exists()) {
                    XDMUtil.open(file);
                } else {
                    JOptionPane.showMessageDialog(this, "File does not exists");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Download not complete");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No item selected");
        }
    }

    private void openFolder() {
        DownloadListItem item = this.getSelectedItem();
        if (item != null) {
            File file = new File(item.saveto);
            if (file.exists()) {
                XDMUtil.open(file);
            } else {
                JOptionPane.showMessageDialog(this, "Folder does not exists");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No item selected");
        }
    }

    void showDownloadWindow() {
        System.out.println("CALLED");
        DownloadListItem item = this.getSelectedItem();
        if (item == null) {
            JOptionPane.showMessageDialog(this, "No item selected");
            return;
        }
        if (item.window != null) {
            boolean show = !item.window.isVisible();
            System.out.println("SHOW WINDOW: " + show);
            item.window.setVisible(show);
        }
        if (item.window == null && item.mgr != null) {
            DownloadWindow w = new DownloadWindow(item.mgr);
            item.mgr.addObserver(w);
            item.window = w.window;
            w.showWindow();
        }
    }

    @Override
    public void startQ() {
        if (!this.queue) {
            this.queue = true;
            this.next();
        }
    }

    @Override
    public void stopQ() {
        this.queue = false;
        if (this.queuedItem != null && this.queuedItem.mgr != null) {
            this.queuedItem.mgr.stop();
            this.queuedItem = null;
        }
        this.queueLabel.setIcon(null);
    }

    @Override
    public void next() {
        int i = 0;
        while (i < MainWindow.list.list.size()) {
            DownloadListItem item = MainWindow.list.list.get(i);
            if (item.q && item.mgr == null && item.state != 50) {
                if (item.tempdir.equals("")) {
                    this.startDownload(item.url, item.filename, item.saveto, tempdir, item, null, item.extra, item.cookies, false);
                } else {
                    ConnectionManager c = new ConnectionManager(item.url, item.filename, item.saveto, item.tempdir, item.extra, config);
                    c.setTimeOut(MainWindow.config.timeout);
                    c.setMaxConn(MainWindow.config.maxConn);
                    item.setCallback(c, this.model, this.dlistener);
                    item.addObserver(this);
                    c.resume();
                }
                this.queuedItem = item;
                if (this.qIcon == null) {
                    this.qIcon = MainWindow.getIcon("icon16.png");
                }
                this.queueLabel.setIcon(this.qIcon);
                return;
            }
            ++i;
        }
        this.queue = false;
        this.queuedItem = null;
        this.queueLabel.setIcon(null);
    }

    @Override
    public void run() {
        while (MainWindow.config.schedule) {
            System.out.println("Scheduler running...");
            long now = System.currentTimeMillis();
            if (MainWindow.config.startDate != null && MainWindow.config.endDate != null) {
                if (now > MainWindow.config.startDate.getTime()) {
                    if (now < MainWindow.config.endDate.getTime() && !this.queue) {
                        this.startQ();
                    }
                } else {
                    System.out.println("Date error Now: " + now + " START: " + MainWindow.config.startDate.getTime() + " END: " + MainWindow.config.endDate.getTime() + (now > MainWindow.config.startDate.getTime()) + " " + (now < MainWindow.config.endDate.getTime()));
                }
                if (MainWindow.config.endDate.getTime() < now) {
                    this.stopQ();
                    break;
                }
            } else {
                System.out.println("Dates are null");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Scheduler finished...");
    }

    void executeUserRequests() {
    }

    void shutdownComputer(String cmd) {
        LinkedList<DownloadListItem> items = MainWindow.list.list;
        int i = 0;
        while (i < items.size()) {
            DownloadListItem item = list.get(i);
            if (item.state == 10 || item.state == 20 || item.state == 60) {
                return;
            }
            ++i;
        }
        if (this.sdlg == null) {
            this.sdlg = new ShutdownDlg();
        }
        this.sdlg.start(cmd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean createTrayIcon() {
        block11: {
            Accessible restore;
            Accessible aboutXDM;
            Accessible newDownload;
            if (this.dropBox == null) {
                this.dropBox = new DropBox(this, MainWindow.getIcon("icon32.png"), this.t.getScreenSize());
                this.trayPop = new JPopupMenu();
                newDownload = new JMenuItem("Add URL");
                ((AbstractButton)((Object)newDownload)).addActionListener(this);
                aboutXDM = new JMenuItem("About XDM");
                ((AbstractButton)((Object)aboutXDM)).addActionListener(this);
                restore = new JMenuItem("Restore");
                ((AbstractButton)((Object)restore)).addActionListener(this);
                JMenuItem exit2 = new JMenuItem("Exit");
                exit2.addActionListener(this);
                this.trayPop.add((JMenuItem)newDownload);
                this.trayPop.add((JMenuItem)aboutXDM);
                this.trayPop.add((JMenuItem)restore);
                this.trayPop.add(exit2);
                this.trayPop.setInvoker(this.dropBox.label);
                MouseAdapter m = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 1) {
                            System.out.println("Left click");
                            MainWindow.this.restore();
                        }
                        if (e.getButton() == 3) {
                            System.out.println("Right click");
                            MainWindow.this.trayPop.show(MainWindow.this.dropBox, e.getX(), e.getY());
                        }
                    }
                };
                this.dropBox.label.addMouseListener(m);
            }
            try {
                if (Java6Util.trayIcon$isSupported()) {
                    this.tray = Java6Util.getSystemTray();
                    this.trayIcon = Java6Util.createTrayIcon(icon.getImage(), "Xtreme Download Manager");
                    if (this.tray == null || this.trayIcon == null) {
                        MainWindow.config.showDownloadBox = true;
                        return false;
                    }
                    Java6Util.setImageAutoSize(this.trayIcon);
                    this.pop2 = new PopupMenu();
                    newDownload = new MenuItem("Add URL");
                    ((MenuItem)newDownload).addActionListener(this);
                    aboutXDM = new MenuItem("About XDM");
                    ((MenuItem)aboutXDM).addActionListener(this);
                    restore = new MenuItem("Restore");
                    ((MenuItem)restore).addActionListener(this);
                    MenuItem showDropBox = new MenuItem("Show/Hide Drop Box");
                    showDropBox.addActionListener(this);
                    MenuItem exit2 = new MenuItem("Exit");
                    exit2.addActionListener(this);
                    this.pop2.add((MenuItem)newDownload);
                    this.pop2.add((MenuItem)aboutXDM);
                    this.pop2.add((MenuItem)restore);
                    this.pop2.add(showDropBox);
                    this.pop2.add(exit2);
                    Java6Util.setPopupMenu(this.trayIcon, this.pop2);
                    ActionListener a = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            if (MainWindow.this.mw == null) {
                                MainWindow.this.mw = new MediaGrabberWindow(MainWindow.this.mmodel, MainWindow.this);
                            }
                            Dimension dim = MainWindow.this.t.getScreenSize();
                            MainWindow.this.mw.setLocation(dim.width / 2 - MainWindow.this.mw.getWidth() / 2, dim.height / 2 - MainWindow.this.mw.getHeight() / 2);
                            MainWindow.this.mw.setVisible(true);
                        }
                    };
                    Java6Util.addActionListener(this.trayIcon, a);
                    MouseAdapter m = new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            if (e.getButton() == 1) {
                                MainWindow.this.restore();
                            }
                        }
                    };
                    Java6Util.addMouseListener(this.trayIcon, m);
                    try {
                        Java6Util.add(this.tray, this.trayIcon);
                        hasTrayIcon = true;
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    MainWindow.config.showDownloadBox = true;
                    this.hasTray = false;
                }
                if (!this.hasTray) {
                    this.dropBox.setVisible(true);
                    break block11;
                }
                if (MainWindow.config.showDownloadBox) {
                    this.dropBox.setVisible(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!hasTrayIcon) {
            MainWindow.config.showDownloadBox = true;
        }
        return true;
    }

    @Override
    public void intercept(Object obj, Object invoker) {
        if (obj instanceof XDMHttpClient) {
            XDMHttpClient client = (XDMHttpClient)obj;
            this.addURL(client.url.toString(), client, client.requestHeader, client.cook, invoker);
            System.out.println("Returnd from addurl");
        }
    }

    void showAboutDialog() {
        if (this.abtDlg == null) {
            this.abtDlg = new AboutDlg(this);
        }
        Dimension d = this.t.getScreenSize();
        this.abtDlg.setLocation(d.width / 2 - this.abtDlg.getWidth() / 2, d.height / 2 - this.abtDlg.getHeight() / 2);
        this.abtDlg.setVisible(true);
    }

    void copyURL(String url) {
        if (this.clipboard == null) {
            this.clipboard = this.t.getSystemClipboard();
        }
        this.clipboard.setContents(new StringSelection(url), null);
    }

    void copyPath() {
        int[] rows = this.table.getSelectedRows();
        if (rows == null) {
            return;
        }
        Object[] values = new Object[rows.length];
        if (rows != null) {
            values = new Object[rows.length];
            int i = 0;
            while (i < rows.length) {
                int index = Java6Util.jtable$convertRowIndexToModel(this.table, rows[i]);
                DownloadListItem item = list.get(index);
                File file = new File(item.saveto, item.filename);
                values[i] = file;
                ++i;
            }
        }
        StringBuffer plainBuf = new StringBuffer();
        StringBuffer htmlBuf = new StringBuffer();
        htmlBuf.append("<html>\n<body>\n<ul>\n");
        int i = 0;
        while (i < values.length) {
            Object obj = values[i];
            String val = obj == null ? "" : obj.toString();
            plainBuf.append(String.valueOf(val) + "\n");
            htmlBuf.append("  <li>" + val + "\n");
            ++i;
        }
        if (this.clipboard == null) {
            this.clipboard = this.t.getSystemClipboard();
        }
        this.clipboard.setContents(new FileTransferHandler.FileTransferable(plainBuf.toString(), htmlBuf.toString(), values), null);
    }

    private void virusScan(String antivirTxt) {
        MainWindow.createProcess(antivirTxt);
    }

    private void hungUp(String hungUpTxt) {
        MainWindow.createProcess(hungUpTxt);
    }

    private void executeCommand(String cmdTxt) {
        MainWindow.createProcess(cmdTxt);
    }

    @Override
    public void intercept(Object obj) {
        if (obj instanceof HashMap) {
            HashMap arg = (HashMap)obj;
            this.addURL((String)arg.get("url"), null, null, (String)arg.get("cookie"));
            return;
        }
        if (obj instanceof ArrayList) {
            ArrayList flvList = (ArrayList)obj;
            int i = 0;
            while (i < flvList.size()) {
                try {
                    URL url = new URL((String)flvList.get(i));
                    MediaInfo minfo = new MediaInfo();
                    minfo.name = XDMUtil.getFileName(url.getPath());
                    minfo.url = "" + url;
                    minfo.size = "Unknown";
                    minfo.type = "Unknown";
                    this.mmodel.add(minfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (this.mw == null) {
                this.mw = new MediaGrabberWindow(this.mmodel, this);
            }
            this.mw.setLocationRelativeTo(this);
            this.mw.setVisible(true);
            return;
        }
        if (obj != null && obj.toString().length() > 0) {
            if (obj.toString().startsWith("http://www.youtube.com/watch?")) {
                if (this.ytgdlg == null) {
                    this.ytgdlg = new YoutubeGrabberDlg(this);
                }
                this.ytgdlg.setLocationRelativeTo(null);
                this.ytgdlg.showDialog(this, config, obj.toString());
            } else {
                this.addURL(obj.toString(), null, null, null);
            }
        }
    }

    void showTrayMessage() {
        try {
            if (this.popup == null) {
                JButton btn = new JButton("Download video with XDM");
                this.popup = PopupFactory.getSharedInstance().getPopup(this.dropBox, btn, this.dropBox.getX() - btn.getPreferredSize().width + this.dropBox.getWidth(), this.dropBox.getY() - btn.getPreferredSize().height);
                System.out.println(btn.getPreferredSize().width);
                ActionListener a = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (MainWindow.this.mw == null) {
                            MainWindow.this.mw = new MediaGrabberWindow(MainWindow.this.mmodel, MainWindow.this);
                        }
                        Dimension dim = MainWindow.this.t.getScreenSize();
                        MainWindow.this.mw.setLocation(dim.width / 2 - MainWindow.this.mw.getWidth() / 2, dim.height / 2 - MainWindow.this.mw.getHeight() / 2);
                        MainWindow.this.mw.setVisible(true);
                        MainWindow.this.popup.hide();
                    }
                };
                btn.addActionListener(a);
            }
            this.popup.show();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void createProcess(String cmd) {
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void createWinLink(String targetFile) {
        try {
            String ln;
            System.out.println("Creating shortcut at: " + targetFile);
            String jarFolder = MainWindow.getJarPath();
            String jarfile = new File(jarFolder, "xdman.jar").getAbsolutePath();
            File file = new File(System.getProperty("user.home"), "link.vbs");
            FileOutputStream out = new FileOutputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(MainWindow.class.getResourceAsStream("/script/link.txt")));
            while ((ln = in.readLine()) != null) {
                String l1 = ln.replace("<TARGET_LOCATION>", targetFile);
                String l2 = l1.replace("<JAR_PATH>", jarfile);
                String l3 = String.valueOf(l2.replace("<ICON_LOCATION>", new File(jarFolder, "icon.ico").getAbsolutePath())) + "\r\n";
                ((OutputStream)out).write(l3.getBytes());
            }
            ((OutputStream)out).close();
            in.close();
            MainWindow.createProcess("WScript.exe \"" + file.getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void winCreateLink() {
        try {
            if (this.fc == null) {
                this.fc = new JFileChooser();
                this.fc.setFileSelectionMode(1);
            }
            if (this.fc.showSaveDialog(this) == 0) {
                String desktopFile = this.fc.getSelectedFile().getAbsolutePath();
                this.createWinLink(desktopFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getJarPath() {
        try {
            String path = MainWindow.class.getResource("/").toURI().getPath();
            System.out.println(path);
            return new File(path).getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error");
            return "Error";
        }
    }

    void testBrowser() {
        JTextField url = new JTextField("http://localhost:" + MainWindow.config.port + "/test");
        url.setEditable(false);
        JButton copy = new JButton("Copy");
        copy.addActionListener(this);
        Object[] arr = new Object[]{"To check if XDM is synchronized with your browser\nPaste/type this URL in your browser.\n", url, copy, "If its not synchronized\nYou have to configure the browser.\nIf you have configured it already then try restarting it again."};
        JOptionPane.showOptionDialog(this, arr, "Test Browser", -1, 1, null, null, null);
    }

    void showBrowserStatus() {
        if (XDMProxyServer.browsers.size() > 0) {
            String bstr = "Monitoring browser: ";
            Iterator<String> it = XDMProxyServer.browsers.iterator();
            while (it.hasNext()) {
                bstr = String.valueOf(bstr) + " " + it.next();
            }
            JOptionPane.showMessageDialog(this, bstr);
        } else {
            JOptionPane.showMessageDialog(this, "XDM could not detect any network activity performed by your browser.\nTo capture downloads you must configure your browser.\n[Goto help->Advanced Browser Integration]\nIf you already configured it then try restarting the browser again");
        }
    }

    @Override
    public void drop(String url) {
        this.addURL(url, null, null, null);
    }

    void showFFDlg() {
        if (this.ffdlg == null) {
            this.ffmodel = new DefaultListModel();
            this.ffmodel.add(0, "http://localhost:" + MainWindow.config.port + "/xdmff.xpi");
            this.ffdlg = new FFIntDlg(this.ffmodel, this);
        }
        this.ffdlg.setVisible(true);
    }

    private boolean attachProxy(boolean refresh) {
        InputStream in;
        File tmp;
        File exe;
        block7: {
            exe = new File(tempdir, "xdm_net_helper.exe");
            tmp = new File(tempdir, "xdm_win_proxy_attach");
            in = this.getClass().getResourceAsStream("/resource/xdm");
            if (in != null) break block7;
            return false;
        }
        try {
            int x;
            FileOutputStream out = new FileOutputStream(tmp);
            byte[] buf = new byte[8192];
            while ((x = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, x);
            }
            ((OutputStream)out).close();
            tmp.renameTo(exe);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(exe.getAbsolutePath());
            if (!refresh) {
                cmds.add("http=http://localhost:" + MainWindow.config.port);
            }
            ProcessBuilder pb = new ProcessBuilder(cmds);
            pb.directory(new File(tempdir));
            Process proc = pb.start();
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new Exception("Return code!=0 : " + proc.exitValue());
            }
            if (!refresh) {
                this.net_recovery_start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            exe.delete();
            return false;
        }
        System.out.println("File Deleted: " + exe.delete());
        return true;
    }

    boolean integrate(boolean enable) {
        File bak = new File(System.getProperty("user.home"), "reg-bak.reg");
        File main_bak = new File(System.getProperty("user.home"), "xdm-main-reg-bak.reg");
        if (enable) {
            MainWindow.config.attachProxy = true;
            if (this.proxyAttached) {
                config.save();
                return true;
            }
            if (!RegUtil.takeBackup(bak)) {
                MainWindow.config.attachProxy = false;
                this.proxyAttached = false;
                JOptionPane.showMessageDialog(null, "Failed to activate Advanced Browser Integration\nPlease activate it manually");
                try {
                    if (this.view == null) {
                        this.view = this.getHTMLViwer();
                    }
                    this.view.setDocument(this.getClass().getResource("/help/browser_integration.html"));
                    this.view.setVisible(true);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                config.save();
                return false;
            }
            if (!this.attachProxy(false)) {
                MainWindow.config.attachProxy = false;
                this.proxyAttached = false;
                JOptionPane.showMessageDialog(null, "Failed to activate Advanced Browser Integration\nPlease activate it manually");
                try {
                    if (this.view == null) {
                        this.view = this.getHTMLViwer();
                    }
                    this.view.setDocument(this.getClass().getResource("/help/browser_integration.html"));
                    this.view.setVisible(true);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                config.save();
                return false;
            }
            MainWindow.config.attachProxy = true;
            this.proxyAttached = true;
            config.save();
            return true;
        }
        boolean restore_main_bak = false;
        if (main_bak.exists()) {
            String msg = "Advanced Browser Integration will be disabled.\nDo you want to restore your previous network settings too?\nNetwork settings will be restored to the state it was on: " + new Date(main_bak.lastModified()) + "\n" + "Click Yes to restore network settings, No to just disable\n" + "Advanced Browser Integration";
            boolean bl = restore_main_bak = JOptionPane.showConfirmDialog(null, msg, "Select option", 0) == 0;
        }
        if (!restore_main_bak) {
            RegUtil.restore(bak);
            bak.delete();
            this.proxyAttached = false;
            MainWindow.config.attachProxy = false;
            this.attachProxy(true);
            config.save();
            this.net_recovery_finish(true);
            return false;
        }
        RegUtil.restore(main_bak);
        this.proxyAttached = false;
        MainWindow.config.attachProxy = false;
        this.attachProxy(true);
        config.save();
        this.net_recovery_finish(true);
        return false;
    }

    void createLinuxLink(String target, boolean min) {
        System.out.println("Creating link at: " + target);
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("[Desktop Entry]\n");
            buf.append("Encoding=UTF-8\n");
            buf.append("Version=1.0\n");
            buf.append("Type=Application\n");
            buf.append("Terminal=false\n");
            String jarPath = MainWindow.getJarPath();
            buf.append("Exec=java -jar '" + new File(jarPath, "xdman.jar").getAbsolutePath() + "'" + (min ? " -m" : "") + "\n");
            buf.append("Name=Xtreme Download Manager\n");
            buf.append("Comment=Powerfull download accelarator and video downloader\n");
            buf.append("Categories=Network;\n");
            buf.append("Icon=" + new File(jarPath, "icon.png").getAbsolutePath() + "\n");
            File desktop = new File(target, "xdman.desktop");
            FileOutputStream out = new FileOutputStream(desktop);
            ((OutputStream)out).write(buf.toString().getBytes());
            ((OutputStream)out).close();
            Java6Util.file$setExecutable(desktop);
        }
        catch (Exception e) {
            System.out.println("Link could not be created: " + e);
            e.printStackTrace();
        }
    }

    void linuxCreateLink() {
        try {
            if (this.fc == null) {
                this.fc = new JFileChooser();
                this.fc.setFileSelectionMode(1);
            }
            if (this.fc.showSaveDialog(this) == 0) {
                String desktopFile = this.fc.getSelectedFile().getAbsolutePath();
                this.createLinuxLink(desktopFile, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean integrateWithLinux() {
        return LinuxProxyUtil.setLinuxProxy();
    }

    void showBrowserIntegrationDlg() {
        boolean win;
        boolean bl = win = File.separatorChar == '\\';
        if (this.bint == null) {
            this.bint = new BrowserIntDlg(!win);
            Java6Util.jdialog$setIconImage(this.bint, icon.getImage());
            this.bint.autoStart.setSelected(MainWindow.config.autostart);
            this.bint.setListeners(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (MainWindow.this.view == null) {
                            MainWindow.this.view = MainWindow.this.getHTMLViwer();
                        }
                        MainWindow.this.view.setDocument(this.getClass().getResource("/help/video_download.html"));
                        MainWindow.this.view.setVisible(true);
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!win) {
                        boolean isLinux;
                        String osName = System.getProperty("os.name");
                        osName = osName != null ? osName.toLowerCase() : "";
                        boolean bl = isLinux = osName.indexOf("linux") != -1;
                        if (isLinux) {
                            if (JOptionPane.showConfirmDialog(null, "To enable Advanced Browser Integration\nXDM will change systems proxy settings.\nIf you depend on Proxy server to connect to the Internet\nPlease DO NOT use Advanced Browser integration\n\nDo you wish to continue?", "Warning", 0, 2) != 0) {
                                return;
                            }
                            if (MainWindow.this.integrateWithLinux()) {
                                JOptionPane.showMessageDialog(null, "Operation successful. Please Restart the browser\nPlease Note:\nIn order to work Advanced Browser Integration properly\nAlways start XDM before starting the browser\nTo make this easy you may add XDM to system startup");
                                return;
                            }
                        }
                        JOptionPane.showMessageDialog(null, "Auto Configure failed.\nPlease activate advanced browser integration manually");
                        try {
                            if (MainWindow.this.view == null) {
                                MainWindow.this.view = MainWindow.this.getHTMLViwer();
                            }
                            MainWindow.this.view.setDocument(this.getClass().getResource("/help/browser_integration.html"));
                            MainWindow.this.view.setVisible(true);
                        }
                        catch (Exception err) {
                            err.printStackTrace();
                        }
                        return;
                    }
                    JCheckBox chk = (JCheckBox)e.getSource();
                    boolean selected = chk.isSelected();
                    chk.setEnabled(false);
                    selected = MainWindow.this.integrate(selected);
                    chk.setSelected(selected);
                    chk.setEnabled(true);
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBox chk = (JCheckBox)e.getSource();
                    chk.setEnabled(false);
                    MainWindow.this.setAutoStart(chk.isSelected());
                    chk.setEnabled(true);
                    MainWindow.config.autostart = chk.isSelected();
                    config.save();
                }
            }, "http://localhost:9614/xdmff.xpi");
        }
        this.bint.adv.setSelected(this.proxyAttached);
        this.bint.setLocationRelativeTo(this);
        this.bint.setVisible(true);
    }

    void setAutoStart(boolean on) {
        boolean win;
        boolean bl = win = File.separatorChar == '\\';
        if (on) {
            if (win) {
                MainWindow.config.autostart = this.eanableAutoStartWin();
                config.save();
            } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") != -1) {
                try {
                    MacUtil.install();
                    MainWindow.config.autostart = true;
                }
                catch (Exception e) {
                    MainWindow.config.autostart = false;
                    JOptionPane.showMessageDialog(this, "Please Manually Add XDM at startup");
                }
            } else if (!this.enableAutoStartLinux()) {
                MainWindow.config.autostart = false;
                JOptionPane.showMessageDialog(this, "Please Manually Add XDM at startup");
            } else {
                MainWindow.config.autostart = true;
            }
        } else {
            if (win) {
                this.disableAutoStartWin();
                MainWindow.config.autostart = false;
            } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") != -1) {
                MacUtil.uninstall();
                MainWindow.config.autostart = false;
            } else {
                this.disableAutoStartLinux();
                MainWindow.config.autostart = false;
            }
            config.save();
        }
    }

    boolean disableAutoStartLinux() {
        String[] autoStartDirs = new String[]{".config/autostart"};
        File home = new File(System.getProperty("user.home"));
        File autoStartDir = null;
        int i = 0;
        while (i < autoStartDirs.length) {
            autoStartDir = new File(home, autoStartDirs[i]);
            if (!autoStartDir.exists()) {
                autoStartDir = null;
            } else {
                File file = new File(autoStartDir, "xdman.desktop");
                if (file.exists() && file.delete()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    boolean enableAutoStartLinux() {
        String autoStartDir = ".config/autostart";
        File home = new File(System.getProperty("user.home"));
        File fAutoStartDir = new File(home, autoStartDir);
        if (!fAutoStartDir.exists()) {
            fAutoStartDir.mkdirs();
        }
        this.createLinuxLink(fAutoStartDir.getAbsolutePath(), true);
        return true;
    }

    boolean eanableAutoStartWin() {
        try {
            String ln;
            System.out.println("Adding startup entry");
            String jarFolder = MainWindow.getJarPath();
            String jarfile = new File(jarFolder, "xdman.jar").getAbsolutePath();
            File file = new File(System.getProperty("user.home"), "startup.vbs");
            FileOutputStream out = new FileOutputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(MainWindow.class.getResourceAsStream("/script/startup_add.txt")));
            while ((ln = in.readLine()) != null) {
                String l2 = ln.replace("<JAR_PATH>", jarfile);
                String l3 = String.valueOf(l2.replace("<ICON_LOCATION>", new File(jarFolder, "icon.ico").getAbsolutePath())) + "\r\n";
                ((OutputStream)out).write(l3.getBytes());
            }
            ((OutputStream)out).close();
            in.close();
            MainWindow.createProcess("WScript.exe \"" + file.getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    void runScriptWin() {
        String l3;
        String l2;
        String ln;
        BufferedReader in;
        FileOutputStream out;
        File file;
        String jarfile;
        String jarFolder;
        try {
            System.out.println("Adding Desktop entry");
            jarFolder = MainWindow.getJarPath();
            jarfile = new File(jarFolder, "xdman.jar").getAbsolutePath();
            file = new File(System.getProperty("user.home"), "desktop_shortcut.vbs");
            out = new FileOutputStream(file);
            in = new BufferedReader(new InputStreamReader(MainWindow.class.getResourceAsStream("/script/desktop_shortcut.txt")));
            while ((ln = in.readLine()) != null) {
                l2 = ln.replace("<JAR_PATH>", jarfile);
                l3 = String.valueOf(l2.replace("<ICON_LOCATION>", new File(jarFolder, "icon.ico").getAbsolutePath())) + "\r\n";
                ((OutputStream)out).write(l3.getBytes());
            }
            ((OutputStream)out).close();
            in.close();
            MainWindow.createProcess("WScript.exe \"" + file.getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            System.out.println("Adding Prgrams entry");
            jarFolder = MainWindow.getJarPath();
            jarfile = new File(jarFolder, "xdman.jar").getAbsolutePath();
            file = new File(System.getProperty("user.home"), "programs_shortcut.vbs");
            out = new FileOutputStream(file);
            in = new BufferedReader(new InputStreamReader(MainWindow.class.getResourceAsStream("/script/programs_shortcut.txt")));
            while ((ln = in.readLine()) != null) {
                l2 = ln.replace("<JAR_PATH>", jarfile);
                l3 = String.valueOf(l2.replace("<ICON_LOCATION>", new File(jarFolder, "icon.ico").getAbsolutePath())) + "\r\n";
                ((OutputStream)out).write(l3.getBytes());
            }
            ((OutputStream)out).close();
            in.close();
            MainWindow.createProcess("WScript.exe \"" + file.getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    boolean disableAutoStartWin() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/script/startup_del.txt");
            File remScript = new File(System.getProperty("user.home"), "rem.vbs");
            FileOutputStream out = new FileOutputStream(remScript);
            byte[] b = new byte[1024];
            int x = in.read(b);
            ((OutputStream)out).write(b, 0, x);
            ((OutputStream)out).close();
            Runtime.getRuntime().exec("wscript \"" + remScript.getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    HelpDialog getHTMLViwer() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("Browser Integration", this.getClass().getResource("/help/browser_integration.html"));
        map.put("Capturing Videos", this.getClass().getResource("/help/video_download.html"));
        map.put("Refresh Broken Downloads", this.getClass().getResource("/help/refresh_link.html"));
        HelpDialog hlp = new HelpDialog();
        hlp.addPages(map);
        return hlp;
    }

    @Override
    public void download(List<BatchItem> list, boolean startQ) {
        int i = 0;
        while (i < list.size()) {
            BatchItem item = list.get(i);
            if (item.selected) {
                DownloadListItem ditem = new DownloadListItem();
                ditem.url = item.url;
                ditem.saveto = item.dir;
                ditem.filename = item.fileName;
                ditem.dateadded = new Date().toString();
                ditem.lasttry = new Date().toString();
                ditem.q = true;
                String user = item.user;
                String pass = item.pass;
                HashMap<String, String> extra = null;
                if (user != null && pass != null && user.length() > 0) {
                    try {
                        if (extra == null) {
                            extra = new HashMap<String, String>();
                        }
                        extra.put("USER", user);
                        extra.put("PASS", pass);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ditem.extra = extra;
                ditem.icon = IconUtil.getIcon(XDMUtil.findCategory(ditem.filename));
                MainWindow.list.add(ditem);
            }
            ++i;
        }
        if (startQ) {
            this.startQ();
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public void initBatchDownload(List<String> list, String user, String pass) {
        System.out.println("Batch");
        if (list == null || list.size() < 1) {
            return;
        }
        if (this.batchDlg == null) {
            this.batchDlg = new BatchDownloadDlg();
        }
        this.batchDlg.setLocationRelativeTo(null);
        ArrayList<BatchItem> blist = new ArrayList<BatchItem>();
        int i = 0;
        while (i < list.size()) {
            BatchItem item = new BatchItem();
            item.url = list.get(i);
            item.fileName = XDMUtil.getFileName(item.url);
            item.user = user;
            item.pass = pass;
            blist.add(item);
            System.out.println(item.url);
            ++i;
        }
        this.batchDlg.showDialog(blist, MainWindow.config.destdir, this);
    }

    @Override
    public void mediaCaptured(ArrayList<String> list) {
        if (list == null || list.size() < 1) {
            return;
        }
        this.mmodel.list.clear();
        int i = 0;
        while (i < list.size()) {
            String yt;
            MediaInfo info = new MediaInfo();
            info.url = yt = list.get(i);
            info.name = XDMUtil.getFileName(info.url);
            this.mmodel.add(info);
            ++i;
        }
        this.mmodel.fireTableDataChanged();
        if (this.mw == null) {
            this.mw = new MediaGrabberWindow(this.mmodel, this);
        }
        this.mw.setLocationRelativeTo(this);
        this.mw.setVisible(true);
    }

    void net_recovery_start() {
        try {
            String ln;
            System.out.println("Starting net recovery");
            String jarFolder = MainWindow.getJarPath();
            String home = System.getProperty("user.home");
            if (!home.endsWith("\\") && !home.endsWith("/")) {
                home = String.valueOf(home) + "\\";
            }
            System.out.println("Home: " + home);
            String exefile = new File(jarFolder, "net_recovery.exe").getAbsolutePath();
            File file = new File(System.getProperty("user.home"), "start_net_recovery.vbs");
            InputStream inStream = MainWindow.class.getResourceAsStream("/script/net_start.txt");
            if (inStream == null) {
                System.out.println("Script not found!");
                return;
            }
            FileOutputStream out = new FileOutputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
            while ((ln = in.readLine()) != null) {
                if (ln.indexOf("<EXE_PATH>") != -1) {
                    ln = ln.replace("<EXE_PATH>", exefile);
                }
                if (ln.indexOf("<HOME_PATH>") != -1) {
                    ln = ln.replace("<HOME_PATH>", home);
                }
                ln = String.valueOf(ln) + "\r\n";
                ((OutputStream)out).write(ln.getBytes());
            }
            ((OutputStream)out).close();
            in.close();
            MainWindow.createProcess("WScript.exe \"" + file.getAbsolutePath() + "\"");
            this.net_recovery_finish(false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void net_recovery_finish(boolean run) {
        try {
            String ln;
            System.out.println("Finish net recovery");
            File file = new File(System.getProperty("user.home"), "finish_net_recovery.vbs");
            InputStream inStream = MainWindow.class.getResourceAsStream("/script/net_finish.txt");
            if (inStream == null) {
                System.out.println("Script not found!");
                return;
            }
            FileOutputStream out = new FileOutputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
            while ((ln = in.readLine()) != null) {
                ln = String.valueOf(ln) + "\r\n";
                ((OutputStream)out).write(ln.getBytes());
            }
            ((OutputStream)out).close();
            in.close();
            if (run) {
                MainWindow.createProcess("WScript.exe \"" + file.getAbsolutePath() + "\"");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void extractCRX() {
        File crxDir = new File(System.getProperty("user.home"), ".xdm");
        crxDir.mkdirs();
        File crx = new File(crxDir, "xdm.crx");
        try {
            int x;
            InputStream in = this.getClass().getResourceAsStream("/resource/xdm.crx");
            if (in == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(crx);
            byte[] buf = new byte[8192];
            while ((x = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, x);
            }
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DownloadList list;
        HashMap<String, String> arg = new HashMap<String, String>();
        String key = "url";
        boolean min = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-c")) {
                key = "cookie";
            } else if (args[i].equals("-r")) {
                key = "referer";
            } else if (args[i].equals("-m")) {
                min = true;
            } else if (args[i].equals("-u")) {
                key = "url";
            } else {
                arg.put(key, args[i]);
            }
            ++i;
        }
        boolean showInfo = false;
        File configFile = new File(appdir, ".xdmconf");
        config = XDMConfig.load(configFile);
        boolean bl = first_run = MainWindow.config.version != 4;
        if (MainWindow.config.tcpBuf <= 8192) {
            MainWindow.config.tcpBuf = 8192;
        }
        showInfo = !configFile.exists();
        XDMProxyServer server = new XDMProxyServer(null, config, null, null, arg);
        if (!server.init()) {
            return;
        }
        mod_xdm = true;
        DownloadList l = list = new DownloadList(appdir);
        MainWindow w = new MainWindow(list);
        w.setConfig(config);
        w.mmodel = new MediaTableModel(w);
        w.setList(list, l);
        if (!min) {
            w.setVisible(true);
        }
        w.showInfo = showInfo;
        Authenticator a = Authenticator.getInstance();
        a.load(new File(appdir, "sites.conf"));
        server.observer = w;
        server.intercepter = w;
        server.model = w.mmodel;
        w.server = server;
        w.httpModel = new HttpTableModel();
        w.server.cl = w.httpModel;
        System.out.println();
        if (arg.size() > 0) {
            System.out.println("creating new process with param" + arg);
            String url = arg.get("url");
            String cookie = arg.get("cookie");
            System.out.println("URL " + url + " COOKIE " + cookie);
            w.addURL(url, null, null, cookie);
        } else {
            System.out.println(args.length);
        }
        new Thread(){

            public void run() {
                String path = MainWindow.getJarPath();
                System.out.println("JAR_PATH: " + path);
                if (first_run) {
                    boolean win;
                    boolean bl = win = File.separatorChar == '\\';
                    if (win && JOptionPane.showConfirmDialog(MainWindow.this, "This version of XDM is for Linux and Mac OS X\nPlease download the Windows version from 'http://sourceforge.net/projects/xdman'\nWould you like to download it now?", "Question", 0) == 0) {
                        try {
                            Java6Util.desktop$browse(new URI("http://sourceforge.net/projects/xdman"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    MainWindow.config.jarPath = path;
                    MainWindow.this.extractCRX();
                    MainWindow.this.showBrowserIntegrationDlg();
                    if (win) {
                        MainWindow.this.runScriptWin();
                        System.out.println("XDM is running for first time...");
                        File bak = new File(System.getProperty("user.home"), "reg-bak.reg");
                        bak.delete();
                        System.out.println("Taking Main Network backup...");
                        bak = new File(System.getProperty("user.home"), "xdm-main-reg-bak.reg");
                        bak.delete();
                        if (RegUtil.takeBackup(bak)) {
                            System.out.println("Main Backup successfull");
                        } else {
                            System.out.println("Main Backup Failed");
                        }
                        MainWindow.this.createWinLink(path);
                    } else {
                        System.out.println("Adding to menu...");
                        MainWindow.this.createLinuxLink(new File(System.getProperty("user.home"), ".local/share/applications").getAbsolutePath(), false);
                        MainWindow.this.createLinuxLink(path, false);
                    }
                } else {
                    String jarPath = path;
                    System.out.println("Old path: " + MainWindow.config.jarPath + " Current Path: " + jarPath);
                    MainWindow.config.jarPath = jarPath;
                }
                if (File.separatorChar == '\\') {
                    MainWindow.this.createWinLink(path);
                    if (MainWindow.config.attachProxy) {
                        System.out.println("Taking Network backup...");
                        File bak = new File(System.getProperty("user.home"), "reg-bak.reg");
                        if (RegUtil.takeBackup(bak)) {
                            System.out.println("Backup successfull");
                            System.out.println("Attaching Proxy...");
                            MainWindow.config.attachProxy = MainWindow.this.proxyAttached = MainWindow.this.attachProxy(false);
                        } else {
                            System.out.println("Backup failed");
                        }
                    }
                }
            }
        }.start();
        w.server.start();
    }
}

