/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.gui.YTDThread;
import org.sdg.xdman.gui.YoutubeListener;
import org.sdg.xdman.gui.YoutubeMediaListener;
import org.sdg.xdman.plugin.youtube.ParserProgressListner;
import org.sdg.xdman.util.XDMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YoutubeGrabberDlg
extends JFrame
implements ActionListener,
YoutubeListener,
ParserProgressListner {
    private static final long serialVersionUID = -1072376334080340930L;
    CardLayout card;
    JPanel p1;
    Box p2;
    JTextField ytaddr;
    JButton get_video;
    JButton cancel;
    JButton stop;
    JLabel anim;
    JPanel p;
    JTextArea info;
    String info1 = "Enter the link of Youtube video you want to download\nExample: http://www.youtube.com/watch?v=F7k_U1ZXybo";
    String info2 = "XDM is collecting information to get a direct download link\nThis may take a minute or two";
    XDMConfig config;
    YTDThread ytd;
    YoutubeMediaListener listener;

    public YoutubeGrabberDlg(YoutubeMediaListener l) {
        super("XDM Youtube Grabber 2013");
        this.listener = l;
        this.setSize(400, 300);
        this.createP1();
        this.createP2();
        this.info = new JTextArea();
        this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.info.setEditable(false);
        this.info.setOpaque(false);
        this.info.setWrapStyleWord(true);
        this.info.setLineWrap(true);
        this.add((Component)this.info, "North");
        this.card = new CardLayout();
        this.p = new JPanel(this.card);
        this.p.add((Component)this.p1, "1");
        this.p.add((Component)this.p2, "2");
        this.add(this.p);
        this.card.show(this.p, "1");
        try {
            this.setIconImage(MainWindow.icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void showDialog(JFrame f, XDMConfig config, String url) {
        this.setLocationRelativeTo(f);
        this.info.setText(this.info1);
        this.config = config;
        this.card.show(this.p, "1");
        this.ytaddr.setText(url == null ? "" : url);
        this.setVisible(true);
    }

    void setText(String url) {
        this.ytaddr.setText(url);
    }

    void createP1() {
        this.p1 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(10, 10, 10, 10);
        this.ytaddr = new JTextField();
        this.get_video = new JButton("Get Video!");
        this.get_video.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        this.p1.add((Component)this.ytaddr, gc);
        gc.gridwidth = 1;
        gc.gridy = 1;
        this.p1.add((Component)this.get_video, gc);
        gc.gridx = 1;
        this.p1.add((Component)this.cancel, gc);
    }

    void createP2() {
        this.p2 = Box.createHorizontalBox();
        this.p2.add(Box.createHorizontalStrut(10));
        this.anim = new JLabel("Downloading information...");
        this.p2.add(this.anim);
        this.p2.add(Box.createHorizontalGlue());
        this.stop = new JButton("Stop");
        this.stop.addActionListener(this);
        this.p2.add(this.stop);
        this.p2.add(Box.createHorizontalStrut(10));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.get_video) {
            String addr = this.ytaddr.getText();
            if (addr.length() < 1) {
                JOptionPane.showMessageDialog(this, "Address may not be left blank");
                return;
            }
            if (!XDMUtil.validateURL(addr)) {
                JOptionPane.showMessageDialog(this, "Not a valid URL");
                return;
            }
            this.info.setText(this.info2);
            this.card.show(this.p, "2");
            this.ytd = new YTDThread(addr, this.config, this);
            this.ytd.plistner = this;
            this.ytd.start();
        }
        if (e.getSource() == this.stop && this.ytd != null) {
            this.ytd.stop();
            this.setVisible(false);
        }
        if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    @Override
    public void parsingComplete(ArrayList<String> list) {
        System.out.println("List of urls======");
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        this.setVisible(false);
        if (this.listener != null) {
            this.listener.mediaCaptured(list);
        }
    }

    @Override
    public void parsingFailed() {
        if (this.isVisible()) {
            JOptionPane.showMessageDialog(this, "Operation failed");
            this.info.setText(this.info1);
            this.card.show(this.p, "1");
        }
    }

    @Override
    public void update(long downloaded) {
        this.anim.setText("Downloading information " + XDMUtil.getFormattedLength(downloaded));
    }

    public static void main(String[] args) {
    }
}

