/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observer;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.proxy.IConnectionListener;
import org.sdg.xdman.proxy.RequestHandler;
import org.sdg.xdman.proxy.RequestIntercepter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMProxyServer {
    public static HashSet<String> browsers = new HashSet();
    public Observer observer;
    ServerSocket server;
    XDMConfig config;
    public MediaTableModel model;
    boolean stop = false;
    public RequestIntercepter intercepter;
    HashMap<String, String> arg;
    public IConnectionListener cl;
    public ArrayList<String> blockedHosts;
    public ArrayList<String> skippedHosts;

    public XDMProxyServer(Observer o, XDMConfig config, MediaTableModel m, RequestIntercepter intercepter, HashMap<String, String> arg) {
        this.observer = o;
        this.config = config;
        this.model = m;
        this.intercepter = intercepter;
        this.arg = arg;
    }

    public boolean init() {
        System.out.println("Config port: " + this.config.port);
        int port = this.config.port;
        try {
            this.server = new ServerSocket(port);
            System.out.println("XDM Module running on: " + port);
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            try {
                System.out.println("Sending param " + this.arg);
                Socket sock = new Socket("localhost", port);
                OutputStream out = sock.getOutputStream();
                out.write("PARAM\r\n".getBytes());
                if (this.arg.size() > 0) {
                    for (String key : this.arg.keySet()) {
                        String value = this.arg.get(key);
                        out.write((String.valueOf(key) + ": " + value + "\r\n").getBytes());
                    }
                }
                out.write("\r\n".getBytes());
                out.flush();
                InputStream in = sock.getInputStream();
                byte[] buf = new byte[2];
                in.read(buf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void start() {
        while (!this.stop) {
            try {
                this.handleRequest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void handleRequest() {
        try {
            Socket sock = this.server.accept();
            RequestHandler r = new RequestHandler();
            r.blockedHosts = this.blockedHosts;
            r.skippedHosts = this.skippedHosts;
            r.cl = this.cl;
            r.intercepter = this.intercepter;
            r.model = this.model;
            r.config = this.config;
            if (this.observer != null) {
                r.addObserver(this.observer);
            }
            r.socket = sock;
            r.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            this.stop = true;
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        new XDMProxyServer(null, null, null, null, null);
    }
}

