/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;

final class CodeHTML
implements Constants {
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String string, String string2, Method[] methodArray, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string2;
        this.methods = methodArray;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i = 0; i < methodArray.length; ++i) {
            this.writeMethod(methodArray[i], i);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence byteSequence, int n) throws IOException {
        int n2;
        int n3;
        short s = (short)byteSequence.readUnsignedByte();
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer("<TT>" + OPCODE_NAMES[s] + "</TT></TD><TD>");
        if (s == 170 || s == 171) {
            n3 = byteSequence.getIndex() % 4;
            n5 = n3 == 0 ? 0 : 4 - n3;
            for (n2 = 0; n2 < n5; ++n2) {
                byteSequence.readByte();
            }
            n4 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.getIndex() - 12 - n5 - 1;
                n4 += n8;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                int[] nArray = new int[n7 - n6 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = n8 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + (n6 + n3) + "</TH>");
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + nArray[n3] + "\">" + nArray[n3] + "</A></TD>");
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + n4 + "\">" + n4 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                n3 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 8 - n5 - 1;
                int[] nArray = new int[n3];
                n4 += n9;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                for (n2 = 0; n2 < n3; ++n2) {
                    int n10 = byteSequence.readInt();
                    nArray[n2] = n9 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + n10 + "</TH>");
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + nArray[n2] + "\">" + nArray[n2] + "</A></TD>");
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + n4 + "\">" + n4 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int n11 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                stringBuffer.append("<A HREF=\"#code" + n + "@" + n11 + "\">" + n11 + "</A>");
                break;
            }
            case 200: 
            case 201: {
                n2 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                stringBuffer.append("<A HREF=\"#code" + n + "@" + n2 + "\">" + n2 + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n12;
                if (wide) {
                    n12 = byteSequence.readShort();
                    wide = false;
                } else {
                    n12 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("%" + n12);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("<FONT COLOR=\"#00FF00\">" + TYPE_NAMES[byteSequence.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n13 = byteSequence.readShort();
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n13, (byte)9);
                int n14 = constantFieldref.getClassIndex();
                String string = this.constant_pool.getConstantString(n14, (byte)7);
                string = Utility.compactClassName(string, false);
                n13 = constantFieldref.getNameAndTypeIndex();
                String string2 = this.constant_pool.constantToString(n13, (byte)12);
                if (string.equals(this.class_name)) {
                    stringBuffer.append("<A HREF=\"" + this.class_name + "_methods.html#field" + string2 + "\" TARGET=Methods>" + string2 + "</A>\n");
                    break;
                }
                stringBuffer.append(this.constant_html.referenceConstant(n14) + "." + string2);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short s2 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s2));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int n15;
                String string;
                int n16;
                Object object;
                short s3 = byteSequence.readShort();
                if (s == 185) {
                    int n17 = byteSequence.readUnsignedByte();
                    int n18 = byteSequence.readUnsignedByte();
                    object = (ConstantInterfaceMethodref)this.constant_pool.getConstant(s3, (byte)11);
                    n16 = ((ConstantCP)object).getClassIndex();
                    string = this.constant_pool.constantToString((Constant)object);
                    n15 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    ConstantMethodref constantMethodref = (ConstantMethodref)this.constant_pool.getConstant(s3, (byte)10);
                    n16 = constantMethodref.getClassIndex();
                    string = this.constant_pool.constantToString(constantMethodref);
                    n15 = constantMethodref.getNameAndTypeIndex();
                }
                String string3 = Class2HTML.referenceClass(n16);
                string = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(n15, (byte)12)));
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n15, (byte)12);
                String string4 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                object = Utility.methodSignatureReturnType(string4, false);
                stringBuffer.append(string3 + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + s3 + "\" TARGET=ConstantPool>" + string + "</A>(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("):" + Class2HTML.referenceType((String)object));
                break;
            }
            case 19: 
            case 20: {
                short s4 = byteSequence.readShort();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + s4 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(s4, this.constant_pool.getConstant(s4).getTag())) + "</a>");
                break;
            }
            case 18: {
                int n19 = byteSequence.readUnsignedByte();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + n19 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(n19, this.constant_pool.getConstant(n19).getTag())) + "</a>");
                break;
            }
            case 189: {
                short s5 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s5));
                break;
            }
            case 197: {
                short s6 = byteSequence.readShort();
                byte by = byteSequence.readByte();
                stringBuffer.append(this.constant_html.referenceConstant(s6) + ":" + by + "-dimensional");
                break;
            }
            case 132: {
                short s7;
                int n20;
                if (wide) {
                    n20 = byteSequence.readShort();
                    s7 = byteSequence.readShort();
                    wide = false;
                } else {
                    n20 = byteSequence.readUnsignedByte();
                    s7 = byteSequence.readByte();
                }
                stringBuffer.append("%" + n20 + " " + s7);
                break;
            }
            default: {
                if (NO_OF_OPERANDS[s] <= 0) break;
                for (int i = 0; i < TYPE_OF_OPERANDS[s].length; ++i) {
                    switch (TYPE_OF_OPERANDS[s][i]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    stringBuffer.append("&nbsp;");
                }
            }
        }
        stringBuffer.append("</TD>");
        return stringBuffer.toString();
    }

    private final void findGotos(ByteSequence byteSequence, Method method, Code code) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.goto_set = new BitSet(byteSequence.available());
        if (code != null) {
            CodeException[] codeExceptionArray = code.getExceptionTable();
            n5 = codeExceptionArray.length;
            for (int i = 0; i < n5; ++i) {
                this.goto_set.set(codeExceptionArray[i].getStartPC());
                this.goto_set.set(codeExceptionArray[i].getEndPC());
                this.goto_set.set(codeExceptionArray[i].getHandlerPC());
            }
            Attribute[] attributeArray = code.getAttributes();
            for (n4 = 0; n4 < attributeArray.length; ++n4) {
                if (attributeArray[n4].getTag() != 5) continue;
                LocalVariable[] localVariableArray = ((LocalVariableTable)attributeArray[n4]).getLocalVariableTable();
                for (n3 = 0; n3 < localVariableArray.length; ++n3) {
                    n2 = localVariableArray[n3].getStartPC();
                    n = n2 + localVariableArray[n3].getLength();
                    this.goto_set.set(n2);
                    this.goto_set.set(n);
                }
                break;
            }
        }
        int n6 = 0;
        while (byteSequence.available() > 0) {
            int n7 = byteSequence.readUnsignedByte();
            switch (n7) {
                case 170: 
                case 171: {
                    int n8;
                    n5 = byteSequence.getIndex() % 4;
                    int n9 = n5 == 0 ? 0 : 4 - n5;
                    for (n3 = 0; n3 < n9; ++n3) {
                        byteSequence.readByte();
                    }
                    n4 = byteSequence.readInt();
                    if (n7 == 170) {
                        n3 = byteSequence.readInt();
                        n2 = byteSequence.readInt();
                        int n10 = byteSequence.getIndex() - 12 - n9 - 1;
                        this.goto_set.set(n4 += n10);
                        for (n = 0; n < n2 - n3 + 1; ++n) {
                            n8 = n10 + byteSequence.readInt();
                            this.goto_set.set(n8);
                        }
                    } else {
                        n3 = byteSequence.readInt();
                        int n11 = byteSequence.getIndex() - 8 - n9 - 1;
                        this.goto_set.set(n4 += n11);
                        for (n2 = 0; n2 < n3; ++n2) {
                            n = byteSequence.readInt();
                            n8 = n11 + byteSequence.readInt();
                            this.goto_set.set(n8);
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n8 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                    this.goto_set.set(n8);
                    break;
                }
                case 200: 
                case 201: {
                    int n8 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                    this.goto_set.set(n8);
                    break;
                }
                default: {
                    byteSequence.unreadByte();
                    this.codeToHTML(byteSequence, 0);
                }
            }
            ++n6;
        }
    }

    private void writeMethod(Method method, int n) throws IOException {
        int n2;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Class2HTML.toHTML(string3);
        String string5 = Utility.accessToString(method.getAccessFlags());
        string5 = Utility.replace(string5, " ", "&nbsp;");
        Attribute[] attributeArray = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + string5 + "</FONT>&nbsp;<A NAME=method" + n + ">" + Class2HTML.referenceType(string2) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + n + "\" TARGET=Methods>" + string4 + "</A>(");
        for (int i = 0; i < stringArray.length; ++i) {
            this.file.print(Class2HTML.referenceType(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code code = null;
        byte[] byArray = null;
        if (attributeArray.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i = 0; i < attributeArray.length; ++i) {
                n2 = attributeArray[i].getTag();
                if (n2 != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n + "@" + i + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[n2] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributeArray[i] + "</LI>");
                }
                if (n2 != 2) continue;
                code = (Code)attributeArray[i];
                Attribute[] attributeArray2 = code.getAttributes();
                byArray = code.getCode();
                this.file.print("<UL>");
                for (int j = 0; j < attributeArray2.length; ++j) {
                    n2 = attributeArray2[j].getTag();
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n + "@" + i + "@" + j + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[n2] + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (byArray != null) {
            ByteSequence byteSequence = new ByteSequence(byArray);
            byteSequence.mark(byteSequence.available());
            this.findGotos(byteSequence, method, code);
            byteSequence.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            n2 = 0;
            while (byteSequence.available() > 0) {
                int n3 = byteSequence.getIndex();
                String string6 = this.codeToHTML(byteSequence, n);
                String string7 = "";
                if (this.goto_set.get(n3)) {
                    string7 = "<A NAME=code" + n + "@" + n3 + "></A>";
                }
                String string8 = byteSequence.getIndex() == byArray.length ? "<A NAME=code" + n + "@" + byArray.length + ">" + n3 + "</A>" : "" + n3;
                this.file.println("<TR VALIGN=TOP><TD>" + string8 + "</TD><TD>" + string7 + string6 + "</TR>");
                ++n2;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

