/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.concurrent.CountedCompleter;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.AbstractTask;
import java.util.stream.Collector;
import java.util.stream.PipelineHelper;
import java.util.stream.Sink;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.TerminalOp;
import java.util.stream.TerminalSink;

final class ReduceOps {
    private ReduceOps() {
    }

    public static <T, U> TerminalOp<T, U> makeRef(final U u, final BiFunction<U, ? super T, U> biFunction, final BinaryOperator<U> binaryOperator) {
        Objects.requireNonNull(biFunction);
        Objects.requireNonNull(binaryOperator);
        return new ReduceOp<T, U, 1ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 1ReducingSink makeSink() {
                class ReducingSink
                extends Box<U>
                implements AccumulatingSink<T, U, ReducingSink> {
                    final /* synthetic */ Object val$seed;
                    final /* synthetic */ BiFunction val$reducer;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$seed = object;
                        this.val$reducer = biFunction;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$seed;
                    }

                    @Override
                    public void accept(T t) {
                        this.state = this.val$reducer.apply(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.state = this.val$combiner.apply(this.state, reducingSink.state);
                    }
                }
                return new ReducingSink(u, biFunction, binaryOperator);
            }
        };
    }

    public static <T> TerminalOp<T, Optional<T>> makeRef(final BinaryOperator<T> binaryOperator) {
        Objects.requireNonNull(binaryOperator);
        return new ReduceOp<T, Optional<T>, 2ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 2ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<T, Optional<T>, ReducingSink> {
                    private boolean empty;
                    private T state;
                    final /* synthetic */ BinaryOperator val$operator;

                    ReducingSink(BinaryOperator binaryOperator) {
                        this.val$operator = binaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = null;
                    }

                    @Override
                    public void accept(T t) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = t;
                        } else {
                            this.state = this.val$operator.apply(this.state, t);
                        }
                    }

                    @Override
                    public Optional<T> get() {
                        return this.empty ? Optional.empty() : Optional.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        if (!reducingSink.empty) {
                            this.accept(reducingSink.state);
                        }
                    }
                }
                return new ReducingSink(binaryOperator);
            }
        };
    }

    public static <T, I> TerminalOp<T, I> makeRef(final Collector<? super T, I, ?> collector) {
        final Supplier<I> supplier = Objects.requireNonNull(collector).supplier();
        final BiConsumer<I, ? super T> biConsumer = collector.accumulator();
        final BinaryOperator<I> binaryOperator = collector.combiner();
        return new ReduceOp<T, I, 3ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 3ReducingSink makeSink() {
                class ReducingSink
                extends Box<I>
                implements AccumulatingSink<T, I, ReducingSink> {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ BiConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = biConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(T t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.state = this.val$combiner.apply(this.state, reducingSink.state);
                    }
                }
                return new ReducingSink(supplier, biConsumer, binaryOperator);
            }

            @Override
            public int getOpFlags() {
                return collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? StreamOpFlag.NOT_ORDERED : 0;
            }
        };
    }

    public static <T, R> TerminalOp<T, R> makeRef(final Supplier<R> supplier, final BiConsumer<R, ? super T> biConsumer, final BiConsumer<R, R> biConsumer2) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(biConsumer);
        Objects.requireNonNull(biConsumer2);
        return new ReduceOp<T, R, 4ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 4ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<T, R, ReducingSink> {
                    final /* synthetic */ Supplier val$seedFactory;
                    final /* synthetic */ BiConsumer val$accumulator;
                    final /* synthetic */ BiConsumer val$reducer;

                    ReducingSink() {
                        this.val$seedFactory = supplier;
                        this.val$accumulator = biConsumer;
                        this.val$reducer = biConsumer2;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$seedFactory.get();
                    }

                    @Override
                    public void accept(T t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.val$reducer.accept(this.state, reducingSink.state);
                    }
                }
                return new ReducingSink(supplier, biConsumer, biConsumer2);
            }
        };
    }

    public static TerminalOp<Integer, Integer> makeInt(final int n, final IntBinaryOperator intBinaryOperator) {
        Objects.requireNonNull(intBinaryOperator);
        return new ReduceOp<Integer, Integer, 5ReducingSink>(StreamShape.INT_VALUE){

            @Override
            public 5ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Integer, Integer, ReducingSink>,
                Sink.OfInt {
                    private int state;
                    final /* synthetic */ int val$identity;
                    final /* synthetic */ IntBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = n;
                        this.val$operator = intBinaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(int n) {
                        this.state = this.val$operator.applyAsInt(this.state, n);
                    }

                    @Override
                    public Integer get() {
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.accept(reducingSink.state);
                    }
                }
                return new ReducingSink(n, intBinaryOperator);
            }
        };
    }

    public static TerminalOp<Integer, OptionalInt> makeInt(final IntBinaryOperator intBinaryOperator) {
        Objects.requireNonNull(intBinaryOperator);
        return new ReduceOp<Integer, OptionalInt, 6ReducingSink>(StreamShape.INT_VALUE){

            @Override
            public 6ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Integer, OptionalInt, ReducingSink>,
                Sink.OfInt {
                    private boolean empty;
                    private int state;
                    final /* synthetic */ IntBinaryOperator val$operator;

                    ReducingSink(IntBinaryOperator intBinaryOperator) {
                        this.val$operator = intBinaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = 0;
                    }

                    @Override
                    public void accept(int n) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = n;
                        } else {
                            this.state = this.val$operator.applyAsInt(this.state, n);
                        }
                    }

                    @Override
                    public OptionalInt get() {
                        return this.empty ? OptionalInt.empty() : OptionalInt.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        if (!reducingSink.empty) {
                            this.accept(reducingSink.state);
                        }
                    }
                }
                return new ReducingSink(intBinaryOperator);
            }
        };
    }

    public static <R> TerminalOp<Integer, R> makeInt(final Supplier<R> supplier, final ObjIntConsumer<R> objIntConsumer, final BinaryOperator<R> binaryOperator) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(objIntConsumer);
        Objects.requireNonNull(binaryOperator);
        return new ReduceOp<Integer, R, 7ReducingSink>(StreamShape.INT_VALUE){

            @Override
            public 7ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Integer, R, ReducingSink>,
                Sink.OfInt {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjIntConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objIntConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(int n) {
                        this.val$accumulator.accept(this.state, n);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.state = this.val$combiner.apply(this.state, reducingSink.state);
                    }
                }
                return new ReducingSink(supplier, objIntConsumer, binaryOperator);
            }
        };
    }

    public static TerminalOp<Long, Long> makeLong(final long l, final LongBinaryOperator longBinaryOperator) {
        Objects.requireNonNull(longBinaryOperator);
        return new ReduceOp<Long, Long, 8ReducingSink>(StreamShape.LONG_VALUE){

            @Override
            public 8ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Long, Long, ReducingSink>,
                Sink.OfLong {
                    private long state;
                    final /* synthetic */ long val$identity;
                    final /* synthetic */ LongBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = l;
                        this.val$operator = longBinaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(long l) {
                        this.state = this.val$operator.applyAsLong(this.state, l);
                    }

                    @Override
                    public Long get() {
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.accept(reducingSink.state);
                    }
                }
                return new ReducingSink(l, longBinaryOperator);
            }
        };
    }

    public static TerminalOp<Long, OptionalLong> makeLong(final LongBinaryOperator longBinaryOperator) {
        Objects.requireNonNull(longBinaryOperator);
        return new ReduceOp<Long, OptionalLong, 9ReducingSink>(StreamShape.LONG_VALUE){

            @Override
            public 9ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Long, OptionalLong, ReducingSink>,
                Sink.OfLong {
                    private boolean empty;
                    private long state;
                    final /* synthetic */ LongBinaryOperator val$operator;

                    ReducingSink(LongBinaryOperator longBinaryOperator) {
                        this.val$operator = longBinaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = 0L;
                    }

                    @Override
                    public void accept(long l) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = l;
                        } else {
                            this.state = this.val$operator.applyAsLong(this.state, l);
                        }
                    }

                    @Override
                    public OptionalLong get() {
                        return this.empty ? OptionalLong.empty() : OptionalLong.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        if (!reducingSink.empty) {
                            this.accept(reducingSink.state);
                        }
                    }
                }
                return new ReducingSink(longBinaryOperator);
            }
        };
    }

    public static <R> TerminalOp<Long, R> makeLong(final Supplier<R> supplier, final ObjLongConsumer<R> objLongConsumer, final BinaryOperator<R> binaryOperator) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(objLongConsumer);
        Objects.requireNonNull(binaryOperator);
        return new ReduceOp<Long, R, 10ReducingSink>(StreamShape.LONG_VALUE){

            @Override
            public 10ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Long, R, ReducingSink>,
                Sink.OfLong {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjLongConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objLongConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(long l) {
                        this.val$accumulator.accept(this.state, l);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.state = this.val$combiner.apply(this.state, reducingSink.state);
                    }
                }
                return new ReducingSink(supplier, objLongConsumer, binaryOperator);
            }
        };
    }

    public static TerminalOp<Double, Double> makeDouble(final double d, final DoubleBinaryOperator doubleBinaryOperator) {
        Objects.requireNonNull(doubleBinaryOperator);
        return new ReduceOp<Double, Double, 11ReducingSink>(StreamShape.DOUBLE_VALUE){

            @Override
            public 11ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Double, Double, ReducingSink>,
                Sink.OfDouble {
                    private double state;
                    final /* synthetic */ double val$identity;
                    final /* synthetic */ DoubleBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = d;
                        this.val$operator = doubleBinaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(double d) {
                        this.state = this.val$operator.applyAsDouble(this.state, d);
                    }

                    @Override
                    public Double get() {
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.accept(reducingSink.state);
                    }
                }
                return new ReducingSink(d, doubleBinaryOperator);
            }
        };
    }

    public static TerminalOp<Double, OptionalDouble> makeDouble(final DoubleBinaryOperator doubleBinaryOperator) {
        Objects.requireNonNull(doubleBinaryOperator);
        return new ReduceOp<Double, OptionalDouble, 12ReducingSink>(StreamShape.DOUBLE_VALUE){

            @Override
            public 12ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Double, OptionalDouble, ReducingSink>,
                Sink.OfDouble {
                    private boolean empty;
                    private double state;
                    final /* synthetic */ DoubleBinaryOperator val$operator;

                    ReducingSink(DoubleBinaryOperator doubleBinaryOperator) {
                        this.val$operator = doubleBinaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = 0.0;
                    }

                    @Override
                    public void accept(double d) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = d;
                        } else {
                            this.state = this.val$operator.applyAsDouble(this.state, d);
                        }
                    }

                    @Override
                    public OptionalDouble get() {
                        return this.empty ? OptionalDouble.empty() : OptionalDouble.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        if (!reducingSink.empty) {
                            this.accept(reducingSink.state);
                        }
                    }
                }
                return new ReducingSink(doubleBinaryOperator);
            }
        };
    }

    public static <R> TerminalOp<Double, R> makeDouble(final Supplier<R> supplier, final ObjDoubleConsumer<R> objDoubleConsumer, final BinaryOperator<R> binaryOperator) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(objDoubleConsumer);
        Objects.requireNonNull(binaryOperator);
        return new ReduceOp<Double, R, 13ReducingSink>(StreamShape.DOUBLE_VALUE){

            @Override
            public 13ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Double, R, ReducingSink>,
                Sink.OfDouble {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjDoubleConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objDoubleConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(double d) {
                        this.val$accumulator.accept(this.state, d);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        this.state = this.val$combiner.apply(this.state, reducingSink.state);
                    }
                }
                return new ReducingSink(supplier, objDoubleConsumer, binaryOperator);
            }
        };
    }

    private static interface AccumulatingSink<T, R, K extends AccumulatingSink<T, R, K>>
    extends TerminalSink<T, R> {
        public void combine(K var1);
    }

    private static abstract class Box<U> {
        U state;

        Box() {
        }

        public U get() {
            return this.state;
        }
    }

    private static abstract class ReduceOp<T, R, S extends AccumulatingSink<T, R, S>>
    implements TerminalOp<T, R> {
        private final StreamShape inputShape;

        ReduceOp(StreamShape streamShape) {
            this.inputShape = streamShape;
        }

        public abstract S makeSink();

        @Override
        public StreamShape inputShape() {
            return this.inputShape;
        }

        @Override
        public <P_IN> R evaluateSequential(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
            return (R)((AccumulatingSink)pipelineHelper.wrapAndCopyInto(this.makeSink(), spliterator)).get();
        }

        @Override
        public <P_IN> R evaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
            return (R)((AccumulatingSink)new ReduceTask(this, pipelineHelper, spliterator).invoke()).get();
        }
    }

    private static final class ReduceTask<P_IN, P_OUT, R, S extends AccumulatingSink<P_OUT, R, S>>
    extends AbstractTask<P_IN, P_OUT, S, ReduceTask<P_IN, P_OUT, R, S>> {
        private final ReduceOp<P_OUT, R, S> op;

        ReduceTask(ReduceOp<P_OUT, R, S> reduceOp, PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator) {
            super(pipelineHelper, spliterator);
            this.op = reduceOp;
        }

        ReduceTask(ReduceTask<P_IN, P_OUT, R, S> reduceTask, Spliterator<P_IN> spliterator) {
            super(reduceTask, spliterator);
            this.op = reduceTask.op;
        }

        @Override
        protected ReduceTask<P_IN, P_OUT, R, S> makeChild(Spliterator<P_IN> spliterator) {
            return new ReduceTask<P_IN, P_OUT, R, S>(this, spliterator);
        }

        @Override
        protected S doLeaf() {
            return (S)((AccumulatingSink)this.helper.wrapAndCopyInto(this.op.makeSink(), this.spliterator));
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            if (!this.isLeaf()) {
                AccumulatingSink accumulatingSink = (AccumulatingSink)((ReduceTask)this.leftChild).getLocalResult();
                accumulatingSink.combine((AccumulatingSink)((ReduceTask)this.rightChild).getLocalResult());
                this.setLocalResult(accumulatingSink);
            }
            super.onCompletion(countedCompleter);
        }
    }
}

