/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.provider.DSAKeyFactory;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;
import sun.security.provider.ParameterCache;
import sun.security.util.SecurityProviderConstants;

class DSAKeyPairGenerator
extends KeyPairGenerator {
    private int plen;
    private int qlen;
    boolean forceNewParameters;
    private DSAParameterSpec params;
    private SecureRandom random;

    DSAKeyPairGenerator(int n) {
        super("DSA");
        this.initialize(n, null);
    }

    private static void checkStrength(int n, int n2) {
        if ((n < 512 || n > 1024 || n % 64 != 0 || n2 != 160) && (n != 2048 || n2 != 224 && n2 != 256)) {
            throw new InvalidParameterException("Unsupported prime and subprime size combination: " + n + ", " + n2);
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.init(n, secureRandom, false);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.init((DSAParameterSpec)algorithmParameterSpec, secureRandom, false);
    }

    void init(int n, SecureRandom secureRandom, boolean bl) {
        int n2 = SecurityProviderConstants.getDefDSASubprimeSize(n);
        DSAKeyPairGenerator.checkStrength(n, n2);
        this.plen = n;
        this.qlen = n2;
        this.params = null;
        this.random = secureRandom;
        this.forceNewParameters = bl;
    }

    void init(DSAParameterSpec dSAParameterSpec, SecureRandom secureRandom, boolean bl) {
        int n = dSAParameterSpec.getP().bitLength();
        int n2 = dSAParameterSpec.getQ().bitLength();
        DSAKeyPairGenerator.checkStrength(n, n2);
        this.plen = n;
        this.qlen = n2;
        this.params = dSAParameterSpec;
        this.random = secureRandom;
        this.forceNewParameters = bl;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSAParameterSpec dSAParameterSpec;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            if (this.forceNewParameters) {
                dSAParameterSpec = ParameterCache.getNewDSAParameterSpec(this.plen, this.qlen, this.random);
            } else {
                if (this.params == null) {
                    this.params = ParameterCache.getDSAParameterSpec(this.plen, this.qlen, this.random);
                }
                dSAParameterSpec = this.params;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
        return this.generateKeyPair(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG(), this.random);
    }

    private KeyPair generateKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SecureRandom secureRandom) {
        BigInteger bigInteger4 = this.generateX(secureRandom, bigInteger2);
        BigInteger bigInteger5 = this.generateY(bigInteger4, bigInteger, bigInteger3);
        try {
            DSAPublicKey dSAPublicKey = DSAKeyFactory.SERIAL_INTEROP ? new DSAPublicKey(bigInteger5, bigInteger, bigInteger2, bigInteger3) : new DSAPublicKeyImpl(bigInteger5, bigInteger, bigInteger2, bigInteger3);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyPair keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException);
        }
    }

    private BigInteger generateX(SecureRandom secureRandom, BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        byte[] byArray = new byte[this.qlen];
        do {
            secureRandom.nextBytes(byArray);
        } while ((bigInteger2 = new BigInteger(1, byArray).mod(bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        return bigInteger2;
    }

    BigInteger generateY(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
        return bigInteger4;
    }

    public static final class Current
    extends DSAKeyPairGenerator {
        public Current() {
            super(SecurityProviderConstants.DEF_DSA_KEY_SIZE);
        }
    }

    public static final class Legacy
    extends DSAKeyPairGenerator
    implements java.security.interfaces.DSAKeyPairGenerator {
        public Legacy() {
            super(1024);
        }

        @Override
        public void initialize(int n, boolean bl, SecureRandom secureRandom) throws InvalidParameterException {
            if (bl) {
                super.init(n, secureRandom, true);
            } else {
                DSAParameterSpec dSAParameterSpec = ParameterCache.getCachedDSAParameterSpec(n, SecurityProviderConstants.getDefDSASubprimeSize(n));
                if (dSAParameterSpec == null) {
                    throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
                }
                super.init(dSAParameterSpec, secureRandom, false);
            }
        }

        @Override
        public void initialize(DSAParams dSAParams, SecureRandom secureRandom) throws InvalidParameterException {
            if (dSAParams == null) {
                throw new InvalidParameterException("Params must not be null");
            }
            DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            super.init(dSAParameterSpec, secureRandom, false);
        }
    }
}

