/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import xdman.Config;
import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Downloader;
import xdman.downloaders.Segment;
import xdman.downloaders.SegmentDetails;
import xdman.downloaders.SegmentImpl;
import xdman.downloaders.SegmentInfo;
import xdman.downloaders.SegmentListener;
import xdman.downloaders.http.HttpChannel;
import xdman.downloaders.metadata.DashMetadata;
import xdman.mediaconversion.MediaConversionListener;
import xdman.util.FormatUtilities;
import xdman.util.Logger;
import xdman.util.StringUtils;

public abstract class SegmentDownloader
extends Downloader
implements SegmentListener,
MediaConversionListener {
    private boolean init = false;
    private int MIN_CHUNK_SIZE = 262144;
    private boolean assembleFinished;
    private long totalAssembled;

    protected SegmentDownloader(String id, String folder) {
        this.id = id;
        this.folder = new File(folder, id).getAbsolutePath();
        this.length = -1L;
        this.MAX_COUNT = Config.getInstance().getMaxSegments();
        this.MIN_CHUNK_SIZE = Config.getInstance().getMinSegmentSize();
        this.lastDownloaded = this.downloaded;
        this.prevTime = System.currentTimeMillis();
        this.eta = "---";
    }

    @Override
    public void start() {
        Logger.log("creating folder " + this.folder);
        new File(this.folder).mkdirs();
        this.chunks = new ArrayList();
        try {
            SegmentImpl c1 = new SegmentImpl(this, this.folder);
            if (this.getMetadata() instanceof DashMetadata) {
                c1.setTag("T1");
            }
            c1.setLength(-1L);
            c1.setStartOffset(0L);
            c1.setDownloaded(0L);
            this.chunks.add(c1);
            c1.download(this);
        }
        catch (IOException e) {
            this.errorCode = 135;
            this.listener.downloadFailed(this.id);
        }
    }

    @Override
    public void resume() {
        block9: {
            try {
                this.stopFlag = false;
                Logger.log("Resuming");
                if (!this.restoreState()) {
                    Logger.log("Starting from beginning");
                    this.start();
                    return;
                }
                this.lastDownloaded = this.downloaded;
                this.prevTime = System.currentTimeMillis();
                Logger.log("Restore success");
                this.init = true;
                Segment c1 = this.findInactiveChunk();
                if (c1 != null) {
                    try {
                        c1.download(this);
                        break block9;
                    }
                    catch (Exception e) {
                        Logger.log(e);
                        if (!this.stopFlag) {
                            Logger.log(e);
                            this.errorCode = 135;
                            this.listener.downloadFailed(this.id);
                            return;
                        }
                        break block9;
                    }
                }
                if (this.allFinished()) {
                    this.assembleAsync();
                } else {
                    Logger.log("Internal error: no inactive/incomplete chunk found while resuming!");
                }
            }
            catch (Exception e) {
                Logger.log(e);
                this.errorCode = 135;
                this.listener.downloadFailed(this.id);
                return;
            }
        }
    }

    private synchronized void createChunk() throws IOException {
        Segment c1;
        Segment c;
        if (this.stopFlag) {
            return;
        }
        int activeCount = this.getActiveChunkCount();
        Logger.log("active count:" + activeCount);
        if (activeCount == this.MAX_COUNT) {
            return;
        }
        int rem = this.MAX_COUNT - activeCount;
        if ((rem -= this.retryFailedChunks(rem)) > 0 && (c = this.splitChunk(c1 = this.findMaxChunk())) != null) {
            Logger.log("creating chunk " + c);
            this.chunks.add(c);
            c.download(this);
        }
    }

    private Segment findMaxChunk() {
        if (this.stopFlag) {
            return null;
        }
        long size = -1L;
        String id = null;
        int i = 0;
        while (i < this.chunks.size()) {
            long rem;
            Segment c = (Segment)this.chunks.get(i);
            if (c.isActive() && (rem = c.getLength() - c.getDownloaded()) > size) {
                id = c.getId();
                size = rem;
            }
            ++i;
        }
        if (size < (long)this.MIN_CHUNK_SIZE) {
            return null;
        }
        return this.getById(id);
    }

    private void mergeChunk(Segment c1, Segment c2) {
        c1.setLength(c1.getLength() + c2.getLength());
    }

    private Segment splitChunk(Segment c) throws IOException {
        if (c == null || this.stopFlag) {
            return null;
        }
        long rem = c.getLength() - c.getDownloaded();
        long offset = c.getStartOffset() + c.getLength() - rem / 2L;
        long len = rem / 2L;
        Logger.log("Changing length from: " + c.getLength() + " to " + (c.getLength() - rem / 2L));
        c.setLength(c.getLength() - rem / 2L);
        SegmentImpl c2 = new SegmentImpl(this, this.folder);
        if (this.getMetadata() instanceof DashMetadata) {
            c2.setTag("T1");
        }
        c2.setLength(len);
        c2.setStartOffset(offset);
        return c2;
    }

    private Segment findNextNeedyChunk(Segment chunk) {
        if (this.stopFlag) {
            return null;
        }
        long offset = chunk.getStartOffset() + chunk.getLength();
        int i = 0;
        while (i < this.chunks.size()) {
            Segment c = (Segment)this.chunks.get(i);
            if (c.getDownloaded() == 0L && !c.isFinished() && c.getStartOffset() == offset) {
                return c;
            }
            ++i;
        }
        return null;
    }

    private synchronized boolean onComplete(String id) throws IOException {
        if (this.allFinished() || this.length < 0L) {
            block5: {
                this.finished = true;
                this.updateStatus();
                try {
                    this.assemble();
                    if (!this.assembleFinished) {
                        throw new IOException("Assemble failed");
                    }
                    Logger.log("********Download finished*********");
                    this.updateStatus();
                    this.listener.downloadFinished(this.id);
                }
                catch (Exception e) {
                    if (this.stopFlag) break block5;
                    Logger.log(e);
                    this.errorCode = 132;
                    this.listener.downloadFailed(this.id);
                }
            }
            this.listener = null;
            return true;
        }
        Segment chunk = this.getById(id);
        Logger.log("Complete: " + chunk + " " + chunk.getDownloaded() + " " + chunk.getLength());
        Segment nextNeedyChunk = this.findNextNeedyChunk(chunk);
        if (nextNeedyChunk != null) {
            Logger.log("****************Needy chunk found!!!");
            Logger.log("Stopping: " + nextNeedyChunk);
            nextNeedyChunk.stop();
            this.chunks.remove(nextNeedyChunk);
            nextNeedyChunk.dispose();
            this.mergeChunk(chunk, nextNeedyChunk);
            this.createChunk();
            return false;
        }
        this.clearChannel(chunk);
        this.createChunk();
        return true;
    }

    @Override
    public synchronized void chunkInitiated(String id) throws IOException {
        if (this.stopFlag) {
            return;
        }
        if (!this.init) {
            Segment c = this.getById(id);
            this.length = c.getLength();
            this.init = true;
            Logger.log("size: " + this.length);
            if (c.getChannel() instanceof HttpChannel) {
                super.getLastModifiedDate(c);
            }
            this.saveState();
            this.chunkConfirmed(c);
            this.listener.downloadConfirmed(this.id);
        }
        if (this.length > 0L) {
            this.createChunk();
        }
    }

    @Override
    public synchronized boolean chunkComplete(String id) throws IOException {
        if (this.finished) {
            return true;
        }
        if (this.stopFlag) {
            return true;
        }
        this.saveState();
        return this.onComplete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chunkUpdated(String id) {
        SegmentDownloader segmentDownloader;
        if (this.stopFlag) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSaved > 5000L) {
            segmentDownloader = this;
            synchronized (segmentDownloader) {
                this.saveState();
            }
            this.lastSaved = now;
        }
        if (now - this.lastUpdated > 1000L) {
            this.updateStatus();
            this.lastUpdated = now;
            segmentDownloader = this;
            synchronized (segmentDownloader) {
                int activeCount = this.getActiveChunkCount();
                if (activeCount < this.MAX_COUNT) {
                    int rem = this.MAX_COUNT - activeCount;
                    try {
                        this.retryFailedChunks(rem);
                    }
                    catch (Exception e) {
                        Logger.log(e);
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void assemble() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[UNCONDITIONALDOLOOP]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public abstract AbstractChannel createChannel(Segment var1);

    @Override
    public void stop() {
        this.stopFlag = true;
        this.saveState();
        int i = 0;
        while (i < this.chunks.size()) {
            ((Segment)this.chunks.get(i)).stop();
            ++i;
        }
        if (this.ffmpeg != null) {
            this.ffmpeg.stop();
        }
        this.listener.downloadStopped(this.id);
        this.listener = null;
    }

    private void saveState() {
        if (this.length < 0L) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.length) + "\n");
        sb.append(String.valueOf(this.downloaded) + "\n");
        sb.append(String.valueOf(this.chunks.size()) + "\n");
        int i = 0;
        while (i < this.chunks.size()) {
            Segment seg = (Segment)this.chunks.get(i);
            sb.append(String.valueOf(seg.getId()) + "\n");
            sb.append(String.valueOf(seg.getLength()) + "\n");
            sb.append(String.valueOf(seg.getStartOffset()) + "\n");
            sb.append(String.valueOf(seg.getDownloaded()) + "\n");
            ++i;
        }
        if (!StringUtils.isNullOrEmptyOrBlank(this.lastModified)) {
            sb.append(String.valueOf(this.lastModified) + "\n");
        }
        try {
            File tmp = new File(this.folder, String.valueOf(System.currentTimeMillis()) + ".tmp");
            File out = new File(this.folder, "state.txt");
            FileOutputStream fs = new FileOutputStream(tmp);
            fs.write(sb.toString().getBytes());
            fs.close();
            out.delete();
            tmp.renameTo(out);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private boolean restoreState() {
        BufferedReader br = null;
        this.chunks = new ArrayList();
        File file = new File(this.folder, "state.txt");
        if (!file.exists() && (file = this.getBackupFile(this.folder)) == null) {
            return false;
        }
        try {
            br = new BufferedReader(new FileReader(file));
            this.length = Long.parseLong(br.readLine());
            this.downloaded = Long.parseLong(br.readLine());
            int chunkCount = Integer.parseInt(br.readLine());
            int i = 0;
            while (i < chunkCount) {
                String cid = br.readLine();
                long len = Long.parseLong(br.readLine());
                long off = Long.parseLong(br.readLine());
                long dwn = Long.parseLong(br.readLine());
                SegmentImpl seg = new SegmentImpl(this.folder, cid, off, len, dwn);
                if (this.getMetadata() instanceof DashMetadata) {
                    seg.setTag("T1");
                }
                Logger.log("id: " + seg.getId() + "\nlength: " + seg.getLength() + "\noffset: " + seg.getStartOffset() + "\ndownload: " + seg.getDownloaded());
                this.chunks.add(seg);
                ++i;
            }
            this.lastModified = br.readLine();
            return true;
        }
        catch (Exception e) {
            Logger.log("Failed to load saved state");
            Logger.log(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    protected abstract void chunkConfirmed(Segment var1);

    @Override
    public boolean shouldCleanup() {
        return this.assembleFinished;
    }

    private void updateStatus() {
        try {
            long now = System.currentTimeMillis();
            if (this.converting) {
                this.progress = this.convertPrg;
            } else if (this.assembling) {
                long len = this.length > 0L ? this.length : this.downloaded;
                this.progress = (int)(this.totalAssembled * 100L / len);
            } else {
                long downloaded2 = 0L;
                if (this.segDet == null) {
                    this.segDet = new SegmentDetails();
                }
                if (this.segDet.getCapacity() < this.chunks.size()) {
                    this.segDet.extend(this.chunks.size() - this.segDet.getCapacity());
                }
                this.segDet.setChunkCount(this.chunks.size());
                this.downloadSpeed = 0.0f;
                int i = 0;
                while (i < this.chunks.size()) {
                    Segment s = (Segment)this.chunks.get(i);
                    downloaded2 += s.getDownloaded();
                    SegmentInfo info = this.segDet.getChunkUpdates().get(i);
                    info.setDownloaded(s.getDownloaded());
                    info.setStart(s.getStartOffset());
                    info.setLength(s.getLength());
                    this.downloadSpeed += s.getTransferRate();
                    ++i;
                }
                this.downloaded = downloaded2;
                if (this.length > 0L) {
                    this.progress = (int)(this.downloaded * 100L / this.length);
                    long diff = this.downloaded - this.lastDownloaded;
                    long timeSpend = now - this.prevTime;
                    if (timeSpend > 0L) {
                        float rate = (float)diff / (float)timeSpend * 1000.0f;
                        if (rate > this.downloadSpeed) {
                            this.downloadSpeed = rate;
                        }
                        this.eta = FormatUtilities.getETA(this.length - this.downloaded, rate);
                        if (this.eta == null) {
                            this.eta = "---";
                        }
                        this.lastDownloaded = this.downloaded;
                        this.prevTime = now;
                    }
                }
            }
            this.listener.downloadUpdated(this.id);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private void assembleAsync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    SegmentDownloader.this.finished = true;
                    try {
                        SegmentDownloader.this.assemble();
                        if (!SegmentDownloader.this.assembleFinished) {
                            throw new IOException("Assemble not finished successfully");
                        }
                        Logger.log("********Download finished*********");
                        SegmentDownloader.this.updateStatus();
                        SegmentDownloader.this.cleanup();
                        SegmentDownloader.this.listener.downloadFinished(SegmentDownloader.this.id);
                    }
                    catch (Exception e) {
                        if (SegmentDownloader.this.stopFlag) break block3;
                        Logger.log(e);
                        SegmentDownloader.this.errorCode = 132;
                        SegmentDownloader.this.listener.downloadFailed(SegmentDownloader.this.id);
                    }
                }
            }
        }).start();
    }

    @Override
    public void progress(int progress) {
        this.convertPrg = progress;
        long now = System.currentTimeMillis();
        if (now - this.lastUpdated > 1000L) {
            this.updateStatus();
            this.lastUpdated = now;
        }
    }
}

