/*
 * Decompiled with CFR 0.152.
 */
package xdman.mediaconversion;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import xdman.mediaconversion.MediaFormat;
import xdman.util.StringUtils;

public class MediaFormats {
    private static MediaFormat[] supportedFormats;

    static {
        ArrayList<MediaFormat> list = new ArrayList<MediaFormat>();
        list.add(new MediaFormat());
        BufferedReader br = null;
        try {
            String ln;
            InputStream inStream = MediaFormats.class.getResourceAsStream("/formats/list.txt");
            if (inStream == null) {
                inStream = new FileInputStream("formats/list.txt");
            }
            InputStreamReader r = new InputStreamReader(inStream, Charset.forName("utf-8"));
            br = new BufferedReader(r, 1024);
            while ((ln = br.readLine()) != null) {
                String[] arr;
                if (ln.startsWith("#") || (arr = ln.split("\\|")).length != 12) continue;
                MediaFormat format = new MediaFormat();
                String fmt = MediaFormats.getString(arr[0]);
                String resolution = MediaFormats.getString(arr[1]);
                String vcodec = MediaFormats.getString(arr[2]);
                String vbr = MediaFormats.getString(arr[3]);
                String fr = MediaFormats.getString(arr[4]);
                String vextra = MediaFormats.getString(arr[5]);
                String acodec = MediaFormats.getString(arr[6]);
                String abr = MediaFormats.getString(arr[7]);
                String asr = MediaFormats.getString(arr[8]);
                String aextra = MediaFormats.getString(arr[9]);
                String desc = MediaFormats.getString(arr[10]);
                String audioOnly = MediaFormats.getString(arr[11]);
                format.setFormat(fmt);
                format.setResolution(resolution);
                format.setVideo_codec(vcodec);
                format.setVideo_bitrate(vbr);
                format.setFramerate(fr);
                format.setVideo_param_extra(vextra);
                format.setAudio_codec(acodec);
                format.setAudio_bitrate(abr);
                format.setSamplerate(asr);
                format.setAudio_extra_param(aextra);
                format.setDescription(desc);
                format.setAudioOnly("1".equals(audioOnly));
                list.add(format);
                supportedFormats = new MediaFormat[list.size()];
                supportedFormats = list.toArray(supportedFormats);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String getString(String str) {
        if (!StringUtils.isNullOrEmptyOrBlank(str)) {
            return str;
        }
        return null;
    }

    public static final MediaFormat[] getSupportedFormats() {
        return supportedFormats;
    }

    public static final void setSupportedFormats(MediaFormat[] supportedFmts) {
        supportedFormats = supportedFmts;
    }
}

