/*
 * Decompiled with CFR 0.152.
 */
package xdman.network.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import xdman.network.FixedRangeInputStream;
import xdman.network.HostUnreachableException;
import xdman.network.KeepAliveConnectionCache;
import xdman.network.NetworkException;
import xdman.network.ParsedURL;
import xdman.network.SocketFactory;
import xdman.network.http.HttpClient;
import xdman.util.Logger;
import xdman.util.NetUtils;
import xdman.util.StringUtils;

public class XDMHttpClient
extends HttpClient {
    private ParsedURL _url;
    private Socket socket;
    private String statusLine;
    private long length;
    private FixedRangeInputStream in;
    private boolean keepAliveSupported;
    private boolean closed;

    public XDMHttpClient(String url) {
        this._url = ParsedURL.parse(url);
        this.length = -1L;
    }

    public boolean isFinished() {
        try {
            return this.in.isStreamFinished() && this.keepAliveSupported;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void dispose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.in.isStreamFinished() && this.keepAliveSupported) {
                this.releaseSocket();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public void connect() throws IOException {
        try {
            int port = this._url.getPort();
            String portStr = port == 80 || port == 443 ? "" : ":" + port;
            this.requestHeaders.setValue("host", String.valueOf(this._url.getHost()) + portStr);
            Socket sock = KeepAliveConnectionCache.getInstance().getReusableSocket(this._url.getHost(), this._url.getPort());
            boolean reusing = false;
            if (sock == null) {
                Logger.log("Creating new socket");
                this.socket = this.createSocket();
            } else {
                reusing = true;
                Logger.log("Reusing existing socket");
                this.socket = sock;
            }
            OutputStream sockOut = this.socket.getOutputStream();
            InputStream sockIn = this.socket.getInputStream();
            String reqLine = "GET " + this._url.getPathAndQuery() + " HTTP/1.1";
            StringBuffer reqBuf = new StringBuffer();
            reqBuf.append(String.valueOf(reqLine) + "\r\n");
            this.requestHeaders.appendToBuffer(reqBuf);
            reqBuf.append("\r\n");
            Logger.log("Sending request:\n" + reqBuf);
            sockOut.write(StringUtils.getBytes(reqBuf));
            sockOut.flush();
            this.statusLine = NetUtils.readLine(sockIn);
            String[] arr = this.statusLine.split(" ");
            this.statusCode = Integer.parseInt(arr[1].trim());
            this.statusMessage = arr.length > 2 ? arr[2].trim() : "";
            Logger.log(this.statusLine);
            this.responseHeaders.loadFromStream(sockIn);
            this.length = NetUtils.getContentLength(this.responseHeaders);
            StringBuffer b2 = new StringBuffer();
            this.responseHeaders.appendToBuffer(b2);
            Logger.log(b2);
            this.in = new FixedRangeInputStream(NetUtils.getInputStream(this.responseHeaders, this.socket.getInputStream()), this.length);
            if (reusing) {
                Logger.log("Socket reuse successfull");
            }
            this.keepAliveSupported = !"close".equals(this.responseHeaders.getValue("connection"));
        }
        catch (HostUnreachableException e) {
            e.printStackTrace();
            throw new NetworkException("Unable to connect to server");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NetworkException(e.getMessage());
        }
    }

    private void releaseSocket() {
        Logger.log("Releasing socket for reuse");
        KeepAliveConnectionCache.getInstance().putSocket(this.socket, this._url.getHost(), this._url.getPort());
    }

    private Socket createSocket() throws IOException {
        Socket socket = SocketFactory.createSocket(this._url.getHost(), this._url.getPort());
        if (this._url.getProtocol().equalsIgnoreCase("https")) {
            socket = SocketFactory.wrapSSL(socket, this._url.getHost(), this._url.getPort());
        }
        return socket;
    }

    @Override
    public long getContentLength() throws IOException {
        return this.length;
    }

    @Override
    public String getHost() {
        return String.valueOf(this._url.getHost()) + ":" + this._url.getPort();
    }
}

