/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.tukaani.xz.XZInputStream;
import xdman.Config;
import xdman.DownloadListener;
import xdman.downloaders.http.HttpDownloader;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.ui.components.CustomButton;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.util.FFExtractCallback;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class ComponentInstaller
extends JDialog
implements DownloadListener,
FFExtractCallback {
    private JLabel prgLabel;
    private JProgressBar prg;
    private HttpDownloader d;
    String url = "http://xdman.sourceforge.net/components/";
    String tmpFile;
    boolean stop;

    public ComponentInstaller() {
        this.initUI();
        if (XDMUtils.detectOS() == 10) {
            this.url = XDMUtils.below7() ? String.valueOf(this.url) + "xp.zip.xz" : String.valueOf(this.url) + "win.zip.xz";
        } else if (XDMUtils.detectOS() == 20) {
            this.url = String.valueOf(this.url) + "mac.zip.xz";
        } else if (XDMUtils.detectOS() == 30) {
            this.url = XDMUtils.getOsArch() == 32 ? String.valueOf(this.url) + "linux86.zip.xz" : String.valueOf(this.url) + "linux64.zip.xz";
        }
        this.tmpFile = UUID.randomUUID().toString();
        this.start();
    }

    private void start() {
        HttpMetadata metadata = new HttpMetadata();
        metadata.setUrl(this.url);
        System.out.println(this.url);
        this.d = new HttpDownloader(metadata.getId(), Config.getInstance().getTemporaryFolder(), metadata);
        this.d.registerListener(this);
        this.d.start();
    }

    @Override
    public void downloadFinished(String id) {
        this.extractFFmpeg();
        this.prgLabel.setText("Installing...");
        this.setVisible(false);
    }

    @Override
    public void downloadFailed(String id) {
        this.deleteTmpFiles(id);
        JOptionPane.showMessageDialog(this, "Failed to download components");
        this.setVisible(false);
    }

    @Override
    public void downloadStopped(String id) {
        this.deleteTmpFiles(id);
        this.setVisible(false);
    }

    @Override
    public void downloadConfirmed(String id) {
    }

    @Override
    public void downloadUpdated(String id) {
        int val = this.d.getProgress();
        this.prg.setValue(val);
    }

    @Override
    public String getOutputFolder(String id) {
        return Config.getInstance().getTemporaryFolder();
    }

    @Override
    public String getOutputFile(String id, boolean update) {
        return this.tmpFile;
    }

    private void deleteTmpFiles(String id) {
        Logger.log("Deleting metadata for " + id);
        File mf = new File(Config.getInstance().getMetadataFolder(), id);
        boolean deleted = mf.delete();
        Logger.log("Deleted manifest " + id + " " + deleted);
        File df = new File(Config.getInstance().getTemporaryFolder(), id);
        File[] files = df.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                deleted = f.delete();
                Logger.log("Deleted tmp file " + id + " " + deleted);
                ++n2;
            }
        }
        deleted = df.delete();
        Logger.log("Deleted tmp folder " + id + " " + deleted);
    }

    private void extractFFmpeg() {
        ZipInputStream zipIn = null;
        OutputStream out = null;
        try {
            try {
                ZipEntry ent;
                File input = new File(Config.getInstance().getTemporaryFolder(), this.tmpFile);
                zipIn = new ZipInputStream(new XZInputStream(new FileInputStream(input)));
                while ((ent = zipIn.getNextEntry()) != null) {
                    int x;
                    String name = ent.getName();
                    File outFile = new File(Config.getInstance().getDataFolder(), name);
                    out = new FileOutputStream(outFile);
                    byte[] buf = new byte[8192];
                    while ((x = zipIn.read(buf)) != -1) {
                        out.write(buf, 0, x);
                    }
                    out.close();
                    out = null;
                    outFile.setExecutable(true);
                }
                input.delete();
            }
            catch (Exception e) {
                Logger.log(e);
                JOptionPane.showMessageDialog(this, "Component installation failed");
                try {
                    zipIn.close();
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    Logger.log(e2);
                }
            }
        }
        finally {
            try {
                zipIn.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    @Override
    public void stop() {
        this.cancel();
    }

    private void initUI() {
        this.setSize(400, 300);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setTitle("Installing XDM");
        this.setLayout(null);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBounds(0, 0, 400, 60);
        titlePanel.setBackground(Color.WHITE);
        JLabel titleLabel = new JLabel("Installing FFmpeg multimedia library");
        titleLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titleLabel.setFont(FontResource.getBigBoldFont());
        titleLabel.setForeground(Color.BLACK);
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.prgLabel = new JLabel("Downloading...");
        this.prgLabel.setBounds(20, 80, 360, 30);
        this.add(this.prgLabel);
        this.prg = new JProgressBar();
        this.prg.setBounds(20, 110, 350, 10);
        this.add(this.prg);
        JButton btn = this.createButton2();
        btn.setBounds(this.getBounds().width - 80 - 20, this.getBounds().height - 80, 80, 30);
        this.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentInstaller.this.cancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ComponentInstaller.this.cancel();
            }
        });
    }

    private JButton createButton2() {
        CustomButton btn = new CustomButton("Cancel");
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        return btn;
    }

    private void cancel() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to cancel component downloads?", "Confirm", 0) == 0) {
            this.d.stop();
        }
    }
}

