/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import xdman.DownloadWindowListener;
import xdman.XDMApp;
import xdman.downloaders.Downloader;
import xdman.downloaders.SegmentDetails;
import xdman.ui.components.CircleProgressBar;
import xdman.ui.components.CustomButton;
import xdman.ui.components.SegmentPanel;
import xdman.ui.components.TitlePanel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.FormatUtilities;
import xdman.util.Logger;

public class DownloadWindow
extends JFrame
implements ActionListener {
    private String id;
    private CircleProgressBar prgCircle;
    private SegmentPanel segProgress;
    private int errCode;
    private int reason;
    private String errMsg;
    private JLabel titleLbl;
    private JLabel lblSpeed;
    private JLabel lblStat;
    private JLabel lblDet;
    private JLabel lblETA;
    private JPanel titlePanel;
    private JTextArea txtError;
    private JPanel panel;
    private JButton closeBtn;
    private JButton minBtn;
    private DownloadWindowListener listener;

    public DownloadWindow(String id, DownloadWindowListener listener) {
        this.id = id;
        this.listener = listener;
        this.init();
    }

    public void close(int code, int error) {
        this.errCode = error;
        this.reason = code;
        this.listener = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.reason == 140) {
                    DownloadWindow.this.createP2();
                    DownloadWindow.this.showErrorMsg(DownloadWindow.this.errCode);
                } else {
                    DownloadWindow.this.dispose();
                }
            }
        });
    }

    public void update(Downloader d, String file) {
        this.titleLbl.setText(file);
        if (d.getProgress() > 0) {
            this.setTitle("[" + d.getProgress() + "%]" + file);
        } else {
            this.setTitle(file);
        }
        String statTxt = "";
        statTxt = d.isConverting() ? StringResource.get("TITLE_CONVERT") : (d.isAssembling() ? StringResource.get("STAT_ASSEMBLING") : StringResource.get("STAT_DOWNLOADING"));
        this.lblStat.setText(statTxt);
        this.lblDet.setText(String.valueOf(d.isAssembling() ? StringResource.get("STAT_ASSEMBLING") : StringResource.get("DWN_DOWNLOAD")) + " " + FormatUtilities.formatSize(d.getDownloaded()) + " " + (d.getType() == 1000 || d.getType() == 1003 ? "/ " + FormatUtilities.formatSize(d.getSize()) : "( " + d.getProgress() + " % )"));
        this.lblSpeed.setText(String.valueOf(FormatUtilities.formatSize(d.getDownloadSpeed())) + "/s");
        this.lblETA.setText("ETA " + d.getEta());
        this.prgCircle.setValue(d.getProgress());
        SegmentDetails segDet = d.getSegmentDetails();
        long sz = d.getType() == 1000 || d.getType() == 1004 || d.getType() == 1003 ? d.getSize() : 100L;
        this.segProgress.setValues(segDet, sz);
    }

    private void createP2() {
        this.remove(this.prgCircle);
        this.remove(this.lblSpeed);
        this.remove(this.lblStat);
        this.remove(this.segProgress);
        this.remove(this.lblDet);
        this.remove(this.lblETA);
        this.remove(this.panel);
        this.titlePanel.remove(this.closeBtn);
        this.titlePanel.remove(this.minBtn);
        JPanel p2 = new JPanel(null);
        p2.setBounds(0, 60, 350, 190);
        p2.setBackground(ColorResource.getDarkestBgColor());
        this.txtError = new JTextArea(this.errMsg);
        this.txtError.setFont(FontResource.getBigFont());
        this.txtError.setEditable(false);
        this.txtError.setCaretPosition(0);
        this.txtError.setWrapStyleWord(true);
        this.txtError.setLineWrap(true);
        this.txtError.setBackground(ColorResource.getDarkestBgColor());
        this.txtError.setForeground(Color.WHITE);
        JScrollPane jsp = new JScrollPane(this.txtError);
        jsp.setBounds(25, 20, 300, 100);
        jsp.setBorder(null);
        CustomButton exitBtn = new CustomButton();
        exitBtn.setText(StringResource.get("MSG_OK"));
        this.applyStyle(exitBtn);
        exitBtn.setBounds(0, 1, 350, 50);
        exitBtn.setName("EXIT");
        JPanel panel2 = new JPanel(null);
        panel2.setBounds(0, 140, 350, 50);
        panel2.setBackground(Color.DARK_GRAY);
        panel2.add(exitBtn);
        p2.add(jsp);
        p2.add(panel2);
        this.add(p2);
        this.titleLbl.setText(StringResource.get("MSG_FAILED"));
        this.invalidate();
        this.repaint();
    }

    private void init() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setTitle("Downloading...");
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(350, 250);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        this.titlePanel = new TitlePanel(null, this);
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBounds(0, 0, 350, 50);
        this.closeBtn = new CustomButton();
        this.closeBtn.setBounds(320, 5, 24, 24);
        this.closeBtn.setIcon(ImageResource.get("close_btn.png"));
        this.closeBtn.setBackground(ColorResource.getDarkestBgColor());
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.setName("PAUSE");
        this.closeBtn.addActionListener(this);
        this.minBtn = new CustomButton();
        this.minBtn.setBounds(296, 5, 24, 24);
        this.minBtn.setIcon(ImageResource.get("min_btn.png"));
        this.minBtn.setBackground(ColorResource.getDarkestBgColor());
        this.minBtn.setBorderPainted(false);
        this.minBtn.setFocusPainted(false);
        this.minBtn.setName("MIN");
        this.minBtn.addActionListener(this);
        this.titleLbl = new JLabel(StringResource.get("DWN_TITLE"));
        this.titleLbl.setFont(FontResource.getBiggerFont());
        this.titleLbl.setForeground(ColorResource.getSelectionColor());
        this.titleLbl.setBounds(25, 15, 250, 30);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, 400, 2);
        lineLbl.setOpaque(true);
        this.prgCircle = new CircleProgressBar();
        this.prgCircle.setValue(0);
        this.prgCircle.setBounds(20, 80, 72, 72);
        this.titlePanel.add(this.titleLbl);
        this.titlePanel.add(this.minBtn);
        this.titlePanel.add(this.closeBtn);
        this.lblSpeed = new JLabel("---");
        this.lblSpeed.setHorizontalAlignment(0);
        this.lblSpeed.setBounds(15, 160, 80, 25);
        this.lblSpeed.setForeground(Color.WHITE);
        this.lblStat = new JLabel(StringResource.get("DWN_TITLE"));
        this.lblStat.setBounds(120, 85, 200, 25);
        this.lblStat.setForeground(Color.WHITE);
        this.segProgress = new SegmentPanel();
        this.segProgress.setBounds(120, 115, 200, 5);
        this.lblDet = new JLabel(StringResource.get("DWN_PLACEHOLDER"));
        this.lblDet.setBounds(120, 125, 200, 25);
        this.lblDet.setForeground(Color.WHITE);
        this.lblETA = new JLabel("---");
        this.lblETA.setBounds(120, 150, 200, 25);
        this.lblETA.setForeground(Color.WHITE);
        this.panel = new JPanel(null);
        this.panel.setBounds(0, 200, 350, 50);
        this.panel.setBackground(Color.DARK_GRAY);
        CustomButton btnMore = new CustomButton(StringResource.get("DWN_HIDE"));
        CustomButton btnDN = new CustomButton(StringResource.get("DWN_PREVIEW"));
        CustomButton btnCN = new CustomButton(StringResource.get("MENU_PAUSE"));
        btnMore.setBounds(0, 1, 100, 50);
        btnMore.setName("BACKGROUND");
        this.applyStyle(btnMore);
        btnDN.setBounds(101, 1, 144, 50);
        btnDN.setName("PREVIEW");
        this.applyStyle(btnDN);
        btnCN.setBounds(246, 1, 104, 50);
        btnCN.setName("PAUSE");
        this.applyStyle(btnCN);
        this.add(this.titlePanel);
        this.add(lineLbl);
        this.add(this.prgCircle);
        this.add(this.lblSpeed);
        this.add(this.lblStat);
        this.add(this.segProgress);
        this.add(this.lblDet);
        this.add(this.lblETA);
        this.panel.add(btnMore);
        this.panel.add(btnDN);
        this.panel.add(btnCN);
        this.add(this.panel);
    }

    void applyStyle(CustomButton btn) {
        btn.addActionListener(this);
        btn.setBackground(ColorResource.getDarkestBgColor());
        btn.setForeground(Color.WHITE);
        btn.setPressedBackground(ColorResource.getDarkerBgColor());
        btn.setFont(FontResource.getBigFont());
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setFocusPainted(false);
        btn.setFocusPainted(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JComponent)e.getSource()).getName();
        if ("PAUSE".equals(name)) {
            this.pause();
        } else if ("BACKGROUND".equals(name)) {
            this.hideWnd();
        } else if ("PREVIEW".equals(name)) {
            this.openPreviewFolder();
        } else if ("MIN".equals(name)) {
            this.setExtendedState(this.getExtendedState() | 1);
        } else if ("EXIT".equals(name)) {
            this.dispose();
        }
    }

    private void pause() {
        if (this.listener != null) {
            this.listener.pauseDownload(this.id);
        }
    }

    private void hideWnd() {
        if (this.listener != null) {
            this.listener.hidePrgWnd(this.id);
        }
    }

    private void openPreviewFolder() {
        XDMApp.getInstance().openPreview(this.id);
    }

    private void showErrorMsg(int code) {
        switch (code) {
            case 101: {
                this.txtError.setText(StringResource.get("ERR_CONN_FAILED"));
                return;
            }
            case 102: {
                this.txtError.setText(StringResource.get("ERR_SESSION_FAILED"));
                return;
            }
            case 103: {
                this.txtError.setText(StringResource.get("ERR_NO_RESUME"));
                return;
            }
            case 100: {
                this.txtError.setText(StringResource.get("ERR_INVALID_RESP"));
                return;
            }
            case 132: {
                this.txtError.setText(StringResource.get("ERR_ASM_FAILED"));
                return;
            }
            case 135: {
                this.txtError.setText(StringResource.get("RESUME_FAILED"));
                return;
            }
            case 133: {
                this.txtError.setText(StringResource.get("ERR_DISK_FAILED"));
                return;
            }
        }
        this.txtError.setText(StringResource.get("ERR_INTERNAL"));
    }
}

