/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import xdman.ui.components.CustomButton;
import xdman.ui.components.TitlePanel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.FFExtractCallback;
import xdman.util.FormatUtilities;
import xdman.util.Logger;

public class FFmpegExtractorWnd
extends JFrame
implements ActionListener {
    private JPanel titlePanel;
    private JPanel panel;
    private JButton closeBtn;
    private JButton minBtn;
    private JLabel titleLbl;
    private JProgressBar prg;
    private JLabel statLbl;
    private int lastProgress;
    private long prevTime;
    private CustomButton btnCN;
    private FFExtractCallback callback;

    public FFmpegExtractorWnd(FFExtractCallback callback) {
        this.init();
        this.callback = callback;
    }

    public void progress(int progress) {
        if (progress >= this.prg.getMinimum() && progress <= this.prg.getMaximum()) {
            this.prg.setValue(progress);
        }
        int prgDiff = progress - this.lastProgress;
        long now = System.currentTimeMillis();
        long timeSpend = now - this.prevTime;
        if (timeSpend > 0L) {
            if (prgDiff > 0) {
                long eta = timeSpend * (long)(100 - progress) / 1000L * (long)prgDiff;
                this.lastProgress = progress;
                this.statLbl.setText("ETA: " + FormatUtilities.hms((int)eta));
            }
            this.prevTime = now;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComponent) {
            String name = ((JComponent)e.getSource()).getName();
            if (name == null) {
                return;
            }
            if (name.equals("CLOSE")) {
                this.stop();
            }
            if (name.equals("MIN")) {
                this.setExtendedState(this.getExtendedState() | 1);
            }
        }
    }

    private void init() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(350, 200);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        this.titlePanel = new TitlePanel(null, this);
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBounds(0, 0, 350, 50);
        this.closeBtn = new CustomButton();
        this.closeBtn.setBounds(320, 5, 24, 24);
        this.closeBtn.setIcon(ImageResource.get("close_btn.png"));
        this.closeBtn.setBackground(ColorResource.getDarkestBgColor());
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.setName("CLOSE");
        this.closeBtn.addActionListener(this);
        this.minBtn = new CustomButton();
        this.minBtn.setBounds(296, 5, 24, 24);
        this.minBtn.setIcon(ImageResource.get("min_btn.png"));
        this.minBtn.setBackground(ColorResource.getDarkestBgColor());
        this.minBtn.setBorderPainted(false);
        this.minBtn.setFocusPainted(false);
        this.minBtn.setName("MIN");
        this.minBtn.addActionListener(this);
        this.titleLbl = new JLabel(StringResource.get("TITLE_CONVERT"));
        this.titleLbl.setFont(FontResource.getBiggerFont());
        this.titleLbl.setForeground(ColorResource.getSelectionColor());
        this.titleLbl.setBounds(25, 15, 250, 30);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, 400, 2);
        lineLbl.setOpaque(true);
        this.prg = new JProgressBar();
        this.prg.setBounds(20, 85, 310, 5);
        this.statLbl = new JLabel();
        this.statLbl.setForeground(Color.WHITE);
        this.statLbl.setBounds(20, 100, 310, 25);
        this.titlePanel.add(this.titleLbl);
        this.titlePanel.add(this.minBtn);
        this.titlePanel.add(this.closeBtn);
        this.add(lineLbl);
        this.add(this.titlePanel);
        this.add(this.prg);
        this.add(this.statLbl);
        this.panel = new JPanel(null);
        this.panel.setBounds(0, 150, 350, 50);
        this.panel.setBackground(Color.DARK_GRAY);
        this.btnCN = new CustomButton(StringResource.get("MENU_PAUSE"));
        this.btnCN.setBounds(0, 1, 350, 50);
        this.btnCN.setName("CLOSE");
        this.applyStyle(this.btnCN);
        this.panel.add(this.btnCN);
        this.add(this.panel);
    }

    private void applyStyle(CustomButton btn) {
        btn.addActionListener(this);
        btn.setBackground(ColorResource.getDarkestBgColor());
        btn.setForeground(Color.WHITE);
        btn.setPressedBackground(ColorResource.getDarkerBgColor());
        btn.setFont(FontResource.getBigFont());
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setFocusPainted(false);
        btn.setFocusPainted(false);
    }

    public void finished(int ret) {
        this.dispose();
    }

    private void stop() {
        try {
            if (this.callback != null) {
                this.callback.stop();
                this.callback = null;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.dispose();
    }
}

