/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import xdman.ui.components.MediaImageSource;
import xdman.ui.components.VideoItemWrapper;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;

public class VideoItemEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JPanel panel;
    private JLabel lbl;
    private JComboBox<String> cmb;
    private DefaultComboBoxModel<String> cmbModel;
    private VideoItemWrapper obj;
    private JLabel lblIcon;
    private JPanel component = new JPanel(new BorderLayout(5, 5));
    private JLabel lblBorder;
    private JCheckBox chk;
    private ImageIcon ico;
    private MediaImageSource imgSource;

    public VideoItemEditor(MediaImageSource imgSource) {
        this.component.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.panel = new JPanel(new BorderLayout());
        this.lbl = new JLabel();
        this.lbl.setFont(FontResource.getBigFont());
        this.lblIcon = new JLabel();
        this.lblIcon.setMinimumSize(new Dimension(64, 64));
        this.lblIcon.setMaximumSize(new Dimension(64, 64));
        this.ico = ImageResource.get("video.png");
        this.lblIcon.setIcon(this.ico);
        this.lblIcon.setVerticalAlignment(0);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setOpaque(false);
        p1.add(this.lblIcon);
        this.chk = new JCheckBox("");
        this.chk.setOpaque(false);
        this.chk.setIcon(ImageResource.get("unchecked.png"));
        this.chk.setSelectedIcon(ImageResource.get("checked.png"));
        p1.add((Component)this.chk, "West");
        p1.setBorder(new EmptyBorder(12, 5, 5, 5));
        this.component.add((Component)p1, "West");
        this.cmbModel = new DefaultComboBoxModel();
        this.cmb = new JComboBox<String>(this.cmbModel);
        this.cmb.setPreferredSize(new Dimension(200, 20));
        this.cmb.setOpaque(false);
        this.cmb.setBorder(null);
        this.panel.add(this.lbl);
        this.panel.add(this.cmb, "South");
        this.panel.setOpaque(false);
        this.panel.setBorder(new EmptyBorder(5, 0, 7, 5));
        this.component.add(this.panel);
        this.lblBorder = new JLabel();
        this.lblBorder.setPreferredSize(new Dimension(100, 1));
        this.lblBorder.setMaximumSize(new Dimension(100, 1));
        this.lblBorder.setBackground(ColorResource.getDarkerBgColor());
        this.component.add((Component)this.lblBorder, "North");
        this.component.setOpaque(false);
        this.imgSource = imgSource;
    }

    public void select(boolean flag) {
        this.chk.setSelected(flag);
    }

    @Override
    public Object getCellEditorValue() {
        this.obj.videoItem.index = this.cmb.getSelectedIndex();
        this.obj.checked = this.chk.isSelected();
        System.out.println("value " + this.obj.videoItem.title + " " + this.obj.videoItem.index);
        return this.obj;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        System.out.println("requesting stop");
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.obj = (VideoItemWrapper)value;
        this.lbl.setText(this.obj.videoItem.title);
        this.cmbModel.removeAllElements();
        int i = 0;
        while (i < this.obj.videoItem.mediaFormats.size()) {
            this.cmbModel.addElement("" + this.obj.videoItem.mediaFormats.get(i));
            ++i;
        }
        this.cmb.setSelectedIndex(this.obj.videoItem.index);
        if (row == 0) {
            this.lblBorder.setOpaque(false);
        } else {
            this.lblBorder.setOpaque(true);
        }
        this.chk.setSelected(this.obj.checked);
        this.lblIcon.setIcon(this.ico);
        if (this.obj.videoItem.thumbnail != null && this.imgSource != null) {
            ImageIcon icon = this.imgSource.getImage(this.obj.videoItem.thumbnail);
            if (icon != null) {
                this.lblIcon.setIcon(icon);
            } else {
                System.out.println("null");
            }
        }
        return this.component;
    }
}

