/*
 * Decompiled with CFR 0.152.
 */
package xdman.videoparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import xdman.Config;
import xdman.util.Logger;
import xdman.util.XDMUtils;
import xdman.videoparser.YdlResponse;

public class YoutubeDLHandler {
    private Process proc;
    private int exitCode;
    private String url;
    private String ydlLocation;
    private boolean stop;
    private ArrayList<YdlResponse.YdlVideo> videos;

    public YoutubeDLHandler(String url) {
        this.url = url;
        this.videos = new ArrayList();
        File ydlFile = new File(Config.getInstance().getDataFolder(), System.getProperty("os.name").toLowerCase().contains("windows") ? "youtube-dl.exe" : "youtube-dl");
        if (!ydlFile.exists()) {
            ydlFile = new File(XDMUtils.getJarFile().getParentFile(), System.getProperty("os.name").toLowerCase().contains("windows") ? "youtube-dl.exe" : "youtube-dl");
        }
        this.ydlLocation = ydlFile.getAbsolutePath();
    }

    public void start() {
        File tmpError = new File(Config.getInstance().getTemporaryFolder(), UUID.randomUUID().toString());
        File tmpOutput = new File(Config.getInstance().getTemporaryFolder(), UUID.randomUUID().toString());
        InputStream in = null;
        try {
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add(this.ydlLocation);
                args.add("--no-warnings");
                args.add("-q");
                args.add("-i");
                args.add("-J");
                args.add(this.url);
                ProcessBuilder pb = new ProcessBuilder(args);
                Logger.log("Writing JSON to: " + tmpOutput);
                pb.redirectError(tmpError);
                pb.redirectOutput(tmpOutput);
                this.proc = pb.start();
                this.exitCode = this.proc.waitFor();
                if (!this.stop) {
                    in = new FileInputStream(tmpOutput);
                    this.videos.addAll(YdlResponse.parse(in));
                    Logger.log("video found: " + this.videos.size());
                }
            }
            catch (Exception e) {
                Logger.log(e);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tmpError.delete();
                tmpOutput.delete();
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            tmpError.delete();
            tmpOutput.delete();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public ArrayList<YdlResponse.YdlVideo> getVideos() {
        return this.videos;
    }

    public void stop() {
        try {
            this.proc.destroy();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }
}

