/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class Config {
    private boolean monitoring = true;
    private String metadataFolder;
    private String temporaryFolder;
    private String downloadFolder;
    private String dataFolder;
    private int sortField;
    private boolean sortAsc;
    private int categoryFilter;
    private int stateFilter;
    private String searchText;
    private int maxSegments;
    private int minSegmentSize;
    private int speedLimit;
    private boolean showDownloadWindow;
    private boolean showDownloadCompleteWindow;
    private int parallalDownloads;
    private boolean autoShutdown;
    private int duplicateAction;
    private String[] blockedHosts;
    private String[] vidUrls;
    private String[] fileExts;
    private String[] vidExts;
    private String[] defaultFileTypes;
    private String[] defaultVideoTypes;
    private int networkTimeout;
    private int tcpWindowSize;
    private int proxyMode;
    private String proxyPac;
    private String proxyHost;
    private String socksHost;
    private int proxyPort;
    private int socksPort;
    private String proxyUser;
    private String proxyPass;
    private boolean showVideoNotification;
    private int minVidSize;
    private boolean keepAwake;
    private boolean execCmd;
    private boolean execAntivir;
    private boolean autoStart;
    private String customCmd;
    private String antivirCmd;
    private String antivirExe;
    private boolean firstRun;
    private String language;
    private boolean monitorClipboard;
    private String categoryOther;
    private String categoryDocuments;
    private String categoryMusic;
    private String categoryVideos;
    private String categoryPrograms;
    private String categoryCompressed;
    private boolean downloadAutoStart;
    private boolean fetchTs;
    private boolean noTransparency;
    private static Config _config;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void save() {
        OutputStreamWriter fw = null;
        try {
            File file = new File(System.getProperty("user.home"), ".xdman/config.txt");
            fw = new FileWriter(file);
            String newLine = "\n";
            fw.write("monitoring:" + this.monitoring + newLine);
            fw.write("downloadFolder:" + this.downloadFolder + newLine);
            fw.write("temporaryFolder:" + this.temporaryFolder + newLine);
            fw.write("parallalDownloads:" + this.parallalDownloads + newLine);
            fw.write("maxSegments:" + this.maxSegments + newLine);
            fw.write("networkTimeout:" + this.networkTimeout + newLine);
            fw.write("tcpWindowSize2:" + this.tcpWindowSize + newLine);
            fw.write("minSegmentSize2:" + this.minSegmentSize + newLine);
            fw.write("minVidSize:" + this.minVidSize + newLine);
            fw.write("duplicateAction:" + this.duplicateAction + newLine);
            fw.write("speedLimit:" + this.speedLimit + newLine);
            fw.write("showDownloadWindow:" + this.showDownloadWindow + newLine);
            fw.write("showDownloadCompleteWindow:" + this.showDownloadCompleteWindow + newLine);
            fw.write("blockedHosts:" + XDMUtils.appendArray2Str(this.blockedHosts) + newLine);
            fw.write("vidUrls:" + XDMUtils.appendArray2Str(this.vidUrls) + newLine);
            fw.write("fileExts:" + XDMUtils.appendArray2Str(this.fileExts) + newLine);
            fw.write("vidExts:" + XDMUtils.appendArray2Str(this.vidExts) + newLine);
            fw.write("proxyMode:" + this.proxyMode + newLine);
            fw.write("proxyPac:" + this.proxyPac + newLine);
            fw.write("proxyHost:" + this.proxyHost + newLine);
            fw.write("proxyPort:" + this.proxyPort + newLine);
            fw.write("socksHost:" + this.socksHost + newLine);
            fw.write("socksPort:" + this.socksPort + newLine);
            fw.write("proxyUser:" + this.proxyUser + newLine);
            fw.write("proxyPass:" + this.proxyPass + newLine);
            fw.write("autoShutdown:" + this.autoShutdown + newLine);
            fw.write("keepAwake:" + this.keepAwake + newLine);
            fw.write("execCmd:" + this.execCmd + newLine);
            fw.write("execAntivir:" + this.execAntivir + newLine);
            fw.write("version:7.1.2" + newLine);
            fw.write("autoStart:" + this.autoStart + newLine);
            fw.write("language:" + this.language + newLine);
            fw.write("downloadAutoStart:" + this.downloadAutoStart + newLine);
            if (!StringUtils.isNullOrEmptyOrBlank(this.antivirExe)) {
                fw.write("antivirExe:" + this.antivirExe + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.antivirCmd)) {
                fw.write("antivirCmd:" + this.antivirCmd + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.customCmd)) {
                fw.write("customCmd:" + this.customCmd + newLine);
            }
            fw.write("showVideoNotification:" + this.showVideoNotification + newLine);
            fw.write("monitorClipboard:" + this.monitorClipboard + newLine);
            if (!StringUtils.isNullOrEmptyOrBlank(this.categoryOther)) {
                fw.write("categoryOther:" + this.categoryOther + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.categoryCompressed)) {
                fw.write("categoryCompressed:" + this.categoryCompressed + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.categoryDocuments)) {
                fw.write("categoryDocuments:" + this.categoryDocuments + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.categoryMusic)) {
                fw.write("categoryMusic:" + this.categoryMusic + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.categoryVideos)) {
                fw.write("categoryVideos:" + this.categoryVideos + newLine);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(this.categoryPrograms)) {
                fw.write("categoryPrograms:" + this.categoryPrograms + newLine);
            }
            fw.write("fetchTs:" + this.fetchTs + newLine);
            fw.write("noTransparency:" + this.noTransparency + newLine);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        Logger.log("Loading config...");
        BufferedReader br = null;
        try {
            String ln;
            File file = new File(System.getProperty("user.home"), ".xdman/config.txt");
            if (!file.exists()) {
                return;
            }
            FileReader r = new FileReader(file);
            br = new BufferedReader(r);
            while ((ln = br.readLine()) != null) {
                int index;
                if (ln.startsWith("#") || (index = ln.indexOf(":")) < 1) continue;
                String key = ln.substring(0, index);
                String val = ln.substring(index + 1);
                if (key.equals("monitoring")) {
                    this.monitoring = val.equals("true");
                    continue;
                }
                if (key.equals("downloadFolder")) {
                    this.downloadFolder = val;
                    continue;
                }
                if (key.equals("temporaryFolder")) {
                    this.temporaryFolder = val;
                    continue;
                }
                if (key.equals("maxSegments")) {
                    this.maxSegments = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("minSegmentSize2")) {
                    this.minSegmentSize = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("networkTimeout")) {
                    this.networkTimeout = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("tcpWindowSize2")) {
                    this.tcpWindowSize = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("duplicateAction")) {
                    this.duplicateAction = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("speedLimit")) {
                    this.speedLimit = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("showDownloadWindow")) {
                    this.showDownloadWindow = val.equals("true");
                    continue;
                }
                if (key.equals("showDownloadCompleteWindow")) {
                    this.showDownloadCompleteWindow = val.equals("true");
                    continue;
                }
                if (key.equals("downloadAutoStart")) {
                    this.downloadAutoStart = val.equals("true");
                    continue;
                }
                if (key.equals("minVidSize")) {
                    this.minVidSize = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("parallalDownloads")) {
                    this.parallalDownloads = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("blockedHosts")) {
                    this.blockedHosts = val.split(",");
                    continue;
                }
                if (key.equals("vidUrls")) {
                    this.vidUrls = val.split(",");
                    continue;
                }
                if (key.equals("fileExts")) {
                    this.fileExts = val.split(",");
                    continue;
                }
                if (key.equals("vidExts")) {
                    this.vidExts = val.split(",");
                    continue;
                }
                if (key.equals("proxyMode")) {
                    this.proxyMode = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("proxyPort")) {
                    this.proxyPort = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("socksPort")) {
                    this.socksPort = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("proxyPac")) {
                    this.proxyPac = val;
                    continue;
                }
                if (key.equals("proxyHost")) {
                    this.proxyHost = val;
                    continue;
                }
                if (key.equals("socksHost")) {
                    this.socksHost = val;
                    continue;
                }
                if (key.equals("proxyUser")) {
                    this.proxyUser = val;
                    continue;
                }
                if (key.equals("proxyPass")) {
                    this.proxyPass = val;
                    continue;
                }
                if (key.equals("showVideoNotification")) {
                    this.showVideoNotification = "true".equals(val);
                    continue;
                }
                if (key.equals("keepAwake")) {
                    this.keepAwake = "true".equals(val);
                    continue;
                }
                if (key.equals("autoStart")) {
                    this.autoStart = "true".equals(val);
                    continue;
                }
                if (key.equals("execAntivir")) {
                    this.execAntivir = "true".equals(val);
                    continue;
                }
                if (key.equals("execCmd")) {
                    this.execCmd = "true".equals(val);
                    continue;
                }
                if (key.equals("antivirExe")) {
                    this.antivirExe = val;
                    continue;
                }
                if (key.equals("antivirCmd")) {
                    this.antivirCmd = val;
                    continue;
                }
                if (key.equals("customCmd")) {
                    this.customCmd = val;
                    continue;
                }
                if (key.equals("autoShutdown")) {
                    this.autoShutdown = "true".equals(val);
                    continue;
                }
                if (key.equals("version")) {
                    this.firstRun = !"7.1.2".equals(val);
                    continue;
                }
                if (key.equals("language")) {
                    this.language = val;
                    continue;
                }
                if (key.equals("monitorClipboard")) {
                    this.monitorClipboard = "true".equals(val);
                    continue;
                }
                if (key.equals("categoryOther")) {
                    this.categoryOther = val;
                    continue;
                }
                if (key.equals("categoryDocuments")) {
                    this.categoryDocuments = val;
                    continue;
                }
                if (key.equals("categoryCompressed")) {
                    this.categoryCompressed = val;
                    continue;
                }
                if (key.equals("categoryMusic")) {
                    this.categoryMusic = val;
                    continue;
                }
                if (key.equals("categoryVideos")) {
                    this.categoryVideos = val;
                    continue;
                }
                if (key.equals("categoryPrograms")) {
                    this.categoryPrograms = val;
                    continue;
                }
                if (key.equals("fetchTs")) {
                    this.fetchTs = "true".equals(val);
                    continue;
                }
                if (!key.equals("noTransparency")) continue;
                this.noTransparency = "true".equals(val);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        try {
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Config() {
        File f = new File(System.getProperty("user.home"), ".xdman");
        if (!f.exists()) {
            f.mkdirs();
        }
        this.dataFolder = f.getAbsolutePath();
        f = new File(this.dataFolder, "metadata");
        if (!f.exists()) {
            f.mkdir();
        }
        this.metadataFolder = f.getAbsolutePath();
        f = new File(this.dataFolder, "temp");
        if (!f.exists()) {
            f.mkdir();
        }
        this.temporaryFolder = f.getAbsolutePath();
        this.downloadFolder = XDMUtils.getDownloadsFolder();
        if (!new File(this.downloadFolder).exists()) {
            File file = new File(System.getProperty("user.home"), "Downloads");
            file.mkdirs();
            this.downloadFolder = file.getAbsolutePath();
        }
        f = new File(this.downloadFolder, "Compressed");
        this.categoryCompressed = f.getAbsolutePath();
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(this.downloadFolder, "Documents");
        this.categoryDocuments = f.getAbsolutePath();
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(this.downloadFolder, "Music");
        this.categoryMusic = f.getAbsolutePath();
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(this.downloadFolder, "Videos");
        this.categoryVideos = f.getAbsolutePath();
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(this.downloadFolder, "Programs");
        this.categoryPrograms = f.getAbsolutePath();
        if (!f.exists()) {
            f.mkdirs();
        }
        this.monitoring = true;
        this.showDownloadWindow = true;
        this.setMaxSegments(8);
        this.setMinSegmentSize(262144);
        this.parallalDownloads = 100;
        this.minVidSize = 0x100000;
        this.defaultFileTypes = new String[]{"3GP", "7Z", "AVI", "BZ2", "DEB", "DOC", "DOCX", "EXE", "GZ", "ISO", "MSI", "PDF", "PPT", "PPTX", "RAR", "RPM", "XLS", "XLSX", "SIT", "SITX", "TAR", "JAR", "ZIP", "XZ"};
        this.fileExts = this.defaultFileTypes;
        this.autoShutdown = false;
        this.blockedHosts = new String[]{"update.microsoft.com", "windowsupdate.com", "thwawte.com"};
        this.defaultVideoTypes = new String[]{"MP4", "M3U8", "F4M", "WEBM", "OGG", "MP3", "AAC", "FLV", "MKV", "DIVX", "MOV", "MPG", "MPEG", "OPUS"};
        this.vidExts = this.defaultVideoTypes;
        this.vidUrls = new String[]{".facebook.com|pagelet", "player.vimeo.com/", "instagram.com/p/"};
        this.networkTimeout = 60;
        this.tcpWindowSize = 0;
        this.speedLimit = 0;
        this.proxyMode = 0;
        this.proxyPort = 0;
        this.socksPort = 0;
        this.socksHost = "";
        this.proxyPass = "";
        this.proxyUser = "";
        this.proxyHost = "";
        this.proxyPac = "";
        this.showVideoNotification = true;
        this.showDownloadCompleteWindow = true;
        this.firstRun = true;
        this.language = "en";
        this.monitorClipboard = false;
        this.noTransparency = false;
    }

    public static Config getInstance() {
        if (_config == null) {
            _config = new Config();
        }
        return _config;
    }

    public final String getMetadataFolder() {
        return this.metadataFolder;
    }

    public final String getTemporaryFolder() {
        return this.temporaryFolder;
    }

    public final String getDataFolder() {
        return this.dataFolder;
    }

    public int getX() {
        return -1;
    }

    public int getY() {
        return -1;
    }

    public int getWidth() {
        return -1;
    }

    public int getHeight() {
        return -1;
    }

    public boolean getSortAsc() {
        return this.sortAsc;
    }

    public void setSortAsc(boolean sortAsc) {
        this.sortAsc = sortAsc;
    }

    public boolean isBrowserMonitoringEnabled() {
        return this.monitoring;
    }

    public void enableMonitoring(boolean enable) {
        this.monitoring = enable;
    }

    public int getSortField() {
        return this.sortField;
    }

    public void setSortField(int sortField) {
        this.sortField = sortField;
    }

    public int getCategoryFilter() {
        return this.categoryFilter;
    }

    public void setCategoryFilter(int categoryFilter) {
        this.categoryFilter = categoryFilter;
    }

    public int getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getDownloadFolder() {
        return this.downloadFolder;
    }

    public void setDownloadFolder(String downloadFolder) {
        this.downloadFolder = downloadFolder;
    }

    public int getMaxSegments() {
        return this.maxSegments;
    }

    public void setMaxSegments(int maxSegments) {
        this.maxSegments = maxSegments;
    }

    public int getMinSegmentSize() {
        return this.minSegmentSize;
    }

    public void setMinSegmentSize(int minSegmentSize) {
        this.minSegmentSize = minSegmentSize;
    }

    public final int getSpeedLimit() {
        return this.speedLimit;
    }

    public final void setSpeedLimit(int speedLimit) {
        this.speedLimit = speedLimit;
    }

    public final boolean showDownloadWindow() {
        return this.showDownloadWindow;
    }

    public final void setShowDownloadWindow(boolean show) {
        this.showDownloadWindow = show;
    }

    public final int getMaxDownloads() {
        return this.parallalDownloads;
    }

    public final void setMaxDownloads(int maxDownloads) {
        this.parallalDownloads = maxDownloads;
    }

    public final boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    public final void setAutoShutdown(boolean autoShutdown) {
        this.autoShutdown = autoShutdown;
    }

    public String[] getBlockedHosts() {
        return this.blockedHosts;
    }

    public void setBlockedHosts(String[] blockedHosts) {
        this.blockedHosts = blockedHosts;
    }

    public String[] getVidUrls() {
        return this.vidUrls;
    }

    public void setVidUrls(String[] vidUrls) {
        this.vidUrls = vidUrls;
    }

    public String[] getFileExts() {
        return this.fileExts;
    }

    public void setFileExts(String[] fileExts) {
        this.fileExts = fileExts;
    }

    public String[] getVidExts() {
        return this.vidExts;
    }

    public void setVidExts(String[] vidExts) {
        this.vidExts = vidExts;
    }

    public final boolean showDownloadCompleteWindow() {
        return this.showDownloadCompleteWindow;
    }

    public final int getDuplicateAction() {
        return this.duplicateAction;
    }

    public final void setDuplicateAction(int duplicateAction) {
        this.duplicateAction = duplicateAction;
    }

    public final void setShowDownloadCompleteWindow(boolean show) {
        this.showDownloadCompleteWindow = show;
    }

    public final String[] getDefaultFileTypes() {
        return this.defaultFileTypes;
    }

    public final void setDefaultFileTypes(String[] defaultFileTypes) {
        this.defaultFileTypes = defaultFileTypes;
    }

    public final String[] getDefaultVideoTypes() {
        return this.defaultVideoTypes;
    }

    public final void setDefaultVideoTypes(String[] defaultVideoTypes) {
        this.defaultVideoTypes = defaultVideoTypes;
    }

    public final int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public final void setNetworkTimeout(int networkTimeout) {
        this.networkTimeout = networkTimeout;
    }

    public final int getTcpWindowSize() {
        return this.tcpWindowSize;
    }

    public final void setTcpWindowSize(int tcpWindowSize) {
        this.tcpWindowSize = tcpWindowSize;
    }

    public final int getProxyMode() {
        return this.proxyMode;
    }

    public final void setProxyMode(int proxyMode) {
        this.proxyMode = proxyMode;
    }

    public final String getProxyUser() {
        return this.proxyUser;
    }

    public final void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public final String getProxyPass() {
        return this.proxyPass;
    }

    public final void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public final String getProxyPac() {
        return this.proxyPac;
    }

    public final void setProxyPac(String proxyPac) {
        this.proxyPac = proxyPac;
    }

    public final String getProxyHost() {
        return this.proxyHost;
    }

    public final void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public final int getProxyPort() {
        return this.proxyPort;
    }

    public final void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isShowVideoNotification() {
        return this.showVideoNotification;
    }

    public void setShowVideoNotification(boolean showVideoNotification) {
        this.showVideoNotification = showVideoNotification;
    }

    public int getMinVidSize() {
        return this.minVidSize;
    }

    public void setMinVidSize(int minVidSize) {
        this.minVidSize = minVidSize;
    }

    public String getSocksHost() {
        return this.socksHost;
    }

    public void setSocksHost(String socksHost) {
        this.socksHost = socksHost;
    }

    public int getSocksPort() {
        return this.socksPort;
    }

    public void setSocksPort(int socksPort) {
        this.socksPort = socksPort;
    }

    public boolean isKeepAwake() {
        return this.keepAwake;
    }

    public void setKeepAwake(boolean keepAwake) {
        this.keepAwake = keepAwake;
    }

    public boolean isExecCmd() {
        return this.execCmd;
    }

    public void setExecCmd(boolean execCmd) {
        this.execCmd = execCmd;
    }

    public boolean isExecAntivir() {
        return this.execAntivir;
    }

    public void setExecAntivir(boolean execAntivir) {
        this.execAntivir = execAntivir;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public String getCustomCmd() {
        return this.customCmd;
    }

    public void setCustomCmd(String customCmd) {
        this.customCmd = customCmd;
    }

    public String getAntivirCmd() {
        return this.antivirCmd;
    }

    public void setAntivirCmd(String antivirCmd) {
        this.antivirCmd = antivirCmd;
    }

    public String getAntivirExe() {
        return this.antivirExe;
    }

    public void setAntivirExe(String antivirExe) {
        this.antivirExe = antivirExe;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isMonitorClipboard() {
        return this.monitorClipboard;
    }

    public void setMonitorClipboard(boolean monitorClipboard) {
        this.monitorClipboard = monitorClipboard;
    }

    public void addBlockedHosts(String host) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.blockedHosts));
        if (list.contains(host)) {
            return;
        }
        list.add(host);
        this.blockedHosts = list.toArray(new String[list.size()]);
    }

    public String getCategoryOther() {
        if (this.categoryOther == null) {
            this.categoryOther = this.getDownloadFolder();
        }
        return this.categoryOther;
    }

    public void setCategoryOther(String categoryOther) {
        this.categoryOther = categoryOther;
    }

    public String getCategoryDocuments() {
        if (this.categoryDocuments == null) {
            File folder = new File(this.getDownloadFolder(), "Documents");
            folder.mkdirs();
            this.categoryDocuments = folder.getAbsolutePath();
        }
        return this.categoryDocuments;
    }

    public void setCategoryDocuments(String categoryDocuments) {
        this.categoryDocuments = categoryDocuments;
    }

    public String getCategoryMusic() {
        if (this.categoryMusic == null) {
            File folder = new File(this.getDownloadFolder(), "Music");
            folder.mkdirs();
            this.categoryMusic = folder.getAbsolutePath();
        }
        return this.categoryMusic;
    }

    public void setCategoryMusic(String categoryMusic) {
        this.categoryMusic = categoryMusic;
    }

    public String getCategoryVideos() {
        if (this.categoryVideos == null) {
            File folder = new File(this.getDownloadFolder(), "Video");
            folder.mkdirs();
            this.categoryVideos = folder.getAbsolutePath();
        }
        return this.categoryVideos;
    }

    public void setTemporaryFolder(String folder) {
        this.temporaryFolder = folder;
    }

    public void setCategoryVideos(String categoryVideos) {
        this.categoryVideos = categoryVideos;
    }

    public String getCategoryPrograms() {
        if (this.categoryPrograms == null) {
            File folder = new File(this.getDownloadFolder(), "Programs");
            folder.mkdirs();
            this.categoryPrograms = folder.getAbsolutePath();
        }
        return this.categoryPrograms;
    }

    public void setCategoryPrograms(String categoryPrograms) {
        this.categoryPrograms = categoryPrograms;
    }

    public String getCategoryCompressed() {
        if (this.categoryCompressed == null) {
            File folder = new File(this.getDownloadFolder(), "Compressed");
            folder.mkdirs();
            this.categoryCompressed = folder.getAbsolutePath();
        }
        return this.categoryCompressed;
    }

    public void setCategoryCompressed(String categoryCompressed) {
        this.categoryCompressed = categoryCompressed;
    }

    public boolean isDownloadAutoStart() {
        return this.downloadAutoStart;
    }

    public void setDownloadAutoStart(boolean downloadAutoStart) {
        this.downloadAutoStart = downloadAutoStart;
    }

    public boolean isFetchTs() {
        return this.fetchTs;
    }

    public void setFetchTs(boolean fetchTs) {
        this.fetchTs = fetchTs;
    }

    public boolean isNoTransparency() {
        return this.noTransparency;
    }

    public void setNoTransparency(boolean noTransparency) {
        this.noTransparency = noTransparency;
    }
}

