/*
 * Decompiled with CFR 0.152.
 */
package xdman.preview;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import xdman.Config;
import xdman.util.XDMUtils;

public class FFmpegStream
extends InputStream
implements Runnable {
    String input1;
    String input2;
    Process proc;
    InputStream in;
    long read;
    Thread t;

    public FFmpegStream(String input1, String input2) throws IOException {
        this.input1 = input1;
        this.input2 = input2;
        this.init();
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("closing");
            this.proc.destroyForcibly();
            this.t.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        File ffFile = new File(Config.getInstance().getDataFolder(), System.getProperty("os.name").toLowerCase().contains("windows") ? "ffmpeg.exe" : "ffmpeg");
        if (!ffFile.exists() && !(ffFile = new File(XDMUtils.getJarFile().getParentFile(), System.getProperty("os.name").toLowerCase().contains("windows") ? "ffmpeg.exe" : "ffmpeg")).exists()) {
            return;
        }
        args.add(ffFile.getAbsolutePath());
        args.add("-err_detect");
        args.add("ignore_err");
        args.add("-i");
        args.add(this.input1);
        if (this.input2 != null) {
            args.add("-i");
            args.add(this.input2);
        }
        args.add("-f");
        args.add("webm");
        args.add("-vcodec");
        args.add("vp8");
        args.add("-cpu-used");
        args.add("5");
        args.add("-deadline");
        args.add("realtime");
        args.add("-q:v");
        args.add("1");
        args.add("-acodec");
        args.add("libvorbis");
        args.add("pipe:1");
        args.add("-blocksize");
        args.add("8192");
        args.add("-nostdin");
        ProcessBuilder pb = new ProcessBuilder(args);
        this.proc = pb.start();
        this.in = this.proc.getInputStream();
    }

    @Override
    public void run() {
        long last;
        do {
            last = this.read;
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                System.out.println("interrupted returing");
                return;
            }
        } while (this.read - last >= 1L);
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("closing hanged ffmpeg");
        this.proc.destroyForcibly();
    }

    @Override
    public int read() throws IOException {
        int x = this.in.read();
        if (x != -1) {
            ++this.read;
        }
        return x;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int x = this.in.read(b, off, len);
        if (x != -1) {
            this.read += (long)x;
        } else {
            System.out.println("stream ended after " + this.read + " bytes");
        }
        return x;
    }
}

