/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import xdman.LinkRefreshCallback;
import xdman.XDMApp;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HdsMetadata;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.ui.components.CustomButton;
import xdman.ui.components.MediaDownloaderWnd;
import xdman.ui.components.MessageBox;
import xdman.ui.components.Page;
import xdman.ui.components.XDMFrame;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class RefreshUrlPage
extends Page
implements LinkRefreshCallback {
    private static RefreshUrlPage page;
    private HttpMetadata md;
    private JButton btnOpenPage;
    private JTextArea lblMonitoringTitle;
    private JTextField txtUrl;
    private JLabel lblUrl;
    private JButton btnSave;

    private RefreshUrlPage(XDMFrame xframe) {
        super(StringResource.get("REF_TITLE"), 350, xframe);
        this.initUI();
    }

    public void setDetails(HttpMetadata md) {
        this.md = md;
        if (StringUtils.isNullOrEmptyOrBlank(md.getYdlUrl())) {
            this.btnOpenPage.setVisible(md.getHeaders().containsHeader("referer"));
        } else {
            this.btnOpenPage.setVisible(true);
        }
        System.out.println("ydlurl: " + md.getYdlUrl());
        this.lblMonitoringTitle.setText(StringUtils.isNullOrEmptyOrBlank(md.getYdlUrl()) ? StringResource.get("REF_DESC1") : StringResource.get("REF_DESC2"));
    }

    private void initUI() {
        int y = 0;
        int h = 0;
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setOpaque(false);
        h = 40;
        JLabel lblMaxTitle = new JLabel(StringResource.get("REF_WAITING_FOR_LINK"));
        lblMaxTitle.setForeground(Color.WHITE);
        lblMaxTitle.setFont(FontResource.getItemFont());
        lblMaxTitle.setBounds(15, y += 10, 320, h);
        panel.add(lblMaxTitle);
        y += h;
        y += 10;
        h = 80;
        this.lblMonitoringTitle = new JTextArea();
        this.lblMonitoringTitle.setOpaque(false);
        this.lblMonitoringTitle.setWrapStyleWord(true);
        this.lblMonitoringTitle.setLineWrap(true);
        this.lblMonitoringTitle.setEditable(false);
        this.lblMonitoringTitle.setForeground(Color.WHITE);
        this.lblMonitoringTitle.setFont(FontResource.getNormalFont());
        this.lblMonitoringTitle.setBounds(15, y, 320, h);
        panel.add(this.lblMonitoringTitle);
        this.btnOpenPage = this.createButton1("REF_OPEN_PAGE", 15, y += h);
        this.btnOpenPage.setName("REF_OPEN_PAGE");
        panel.add(this.btnOpenPage);
        y += this.btnOpenPage.getHeight();
        this.btnOpenPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringUtils.isNullOrEmptyOrBlank(RefreshUrlPage.this.md.getYdlUrl()) || RefreshUrlPage.this.md.getHeaders().containsHeader("referer")) {
                    RefreshUrlPage.this.openLink();
                }
            }
        });
        y += 30;
        final JCheckBox chk = new JCheckBox(StringResource.get("SETTINGS_ADV"));
        chk.setName("SETTINGS_ADV");
        chk.setIcon(ImageResource.get("unchecked.png"));
        chk.setSelectedIcon(ImageResource.get("checked.png"));
        chk.setOpaque(false);
        chk.setFocusPainted(false);
        chk.setForeground(Color.WHITE);
        chk.setFont(FontResource.getNormalFont());
        chk.setBounds(15, y, 320, 30);
        panel.add(chk);
        chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RefreshUrlPage.this.showUrlTextBox(chk.isSelected());
            }
        });
        h = 30;
        this.lblUrl = new JLabel(StringResource.get("ND_ADDRESS"));
        this.lblUrl.setBounds(15, y += 30, 80, 30);
        this.lblUrl.setFont(FontResource.getNormalFont());
        this.lblUrl.setVisible(false);
        panel.add(this.lblUrl);
        this.txtUrl = new JTextField();
        this.txtUrl.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtUrl.setForeground(Color.WHITE);
        this.txtUrl.setOpaque(false);
        this.txtUrl.setBounds(95, y + 5, 240, 20);
        this.txtUrl.setVisible(false);
        panel.add(this.txtUrl);
        this.btnSave = this.createButton1("DESC_SAVE_Q", 15, y += h);
        this.btnSave.setName("DESC_SAVE_Q");
        this.btnSave.setVisible(false);
        panel.add(this.btnSave);
        y += this.btnSave.getHeight();
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringUtils.isNullOrEmptyOrBlank(RefreshUrlPage.this.txtUrl.getText())) {
                    try {
                        new URL(RefreshUrlPage.this.txtUrl.getText());
                        if (RefreshUrlPage.this.md != null) {
                            RefreshUrlPage.this.md.setUrl(RefreshUrlPage.this.txtUrl.getText());
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show(RefreshUrlPage.this.getParentFrame(), StringResource.get("MSG_REF_LINK_CONFIRM"), StringResource.get("MSG_INVALID_URL"), 10, 10);
                        Logger.log(ex);
                    }
                } else {
                    MessageBox.show(RefreshUrlPage.this.getParentFrame(), StringResource.get("REF_TITLE"), StringResource.get("MSG_NO_URL"), 10, 10);
                }
            }
        });
        panel.setPreferredSize(new Dimension(350, y += 30));
        panel.setBounds(0, 0, 350, y);
        this.jsp.setViewportView(panel);
    }

    private void showUrlTextBox(boolean show) {
        this.lblUrl.setVisible(show);
        this.txtUrl.setVisible(show);
        this.btnSave.setVisible(show);
    }

    public static RefreshUrlPage getPage(XDMFrame xframe) {
        if (page == null) {
            page = new RefreshUrlPage(xframe);
        }
        return page;
    }

    private JButton createButton1(String name, int x, int y) {
        CustomButton btn = new CustomButton(StringResource.get(name));
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        Dimension d = btn.getPreferredSize();
        btn.setBounds(x, y, d.width, d.height);
        return btn;
    }

    @Override
    public String getId() {
        return this.md.getId();
    }

    @Override
    public boolean isValidLink(HttpMetadata metadata) {
        Logger.log("Checking refresh link with checking size " + this.md.getSize());
        if (this.md.getType() == metadata.getType()) {
            if (this.md instanceof DashMetadata) {
                DashMetadata dm1 = (DashMetadata)this.md;
                DashMetadata dm2 = (DashMetadata)metadata;
                if (dm1.getLen1() == dm2.getLen1() && dm1.getLen2() == dm2.getLen2()) {
                    dm1.setUrl(dm2.getUrl());
                    dm1.setUrl2(dm2.getUrl2());
                    dm1.setHeaders(dm2.getHeaders());
                    dm1.setLen1(dm2.getLen1());
                    dm1.setLen2(dm2.getLen2());
                    dm1.save();
                    this.showOkMsgAndClose();
                    return true;
                }
            } else if (this.md instanceof HlsMetadata) {
                HlsMetadata hm1 = (HlsMetadata)this.md;
                HlsMetadata hm2 = (HlsMetadata)metadata;
                if (this.confirmUrl("")) {
                    hm1.setUrl(hm2.getUrl());
                    hm1.setHeaders(hm2.getHeaders());
                    hm1.save();
                    this.showOkMsgAndClose();
                    return true;
                }
            } else if (this.md instanceof HdsMetadata) {
                HdsMetadata hm1 = (HdsMetadata)this.md;
                HdsMetadata hm2 = (HdsMetadata)metadata;
                if (this.confirmUrl("")) {
                    hm1.setUrl(hm2.getUrl());
                    hm1.setHeaders(hm2.getHeaders());
                    hm1.save();
                    this.showOkMsgAndClose();
                    return true;
                }
            } else {
                boolean confirmed = false;
                confirmed = this.md.getSize() > 0L ? this.md.getSize() == metadata.getSize() : this.confirmUrl(StringResource.get("MSG_REF_LINK_QUESTION"));
                if (confirmed) {
                    this.md.setUrl(metadata.getUrl());
                    this.md.setHeaders(metadata.getHeaders());
                    this.md.save();
                    this.showOkMsgAndClose();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean confirmUrl(String msg) {
        return MessageBox.show(super.getParentFrame(), StringResource.get("MSG_REF_LINK_CONFIRM"), msg, 20, 20) == 20;
    }

    private void showOkMsgAndClose() {
        MessageBox.show(this.getParentFrame(), StringResource.get("MSG_REF_LINK_CONFIRM"), StringResource.get("MSG_REF_LINK_MSG"), 10, 10);
    }

    @Override
    public void showPanel() {
        super.showPanel();
        XDMApp.getInstance().registerRefreshCallback(this);
    }

    @Override
    public void close() {
        XDMApp.getInstance().unregisterRefreshCallback();
        super.close();
    }

    private void openLink() {
        if (!StringUtils.isNullOrEmptyOrBlank(this.md.getYdlUrl())) {
            MediaDownloaderWnd wnd = new MediaDownloaderWnd();
            wnd.launchWithUrl(this.md.getYdlUrl());
        } else if (this.md.getHeaders().containsHeader("referer")) {
            XDMUtils.browseURL(this.md.getHeaders().getValue("referer"));
        }
    }
}

