/*
 * Decompiled with CFR 0.152.
 */
package xdman.videoparser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import xdman.network.http.HttpHeader;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class YdlResponse {
    public static final int DASH_HTTP = 99;
    public static final int HTTP = 98;
    public static final int HLS = 97;
    public static final int HDS = 96;
    private static int DASH_VIDEO_ONLY = 23;
    private static int DASH_AUDIO_ONLY = 24;

    public static ArrayList<YdlVideo> parse(InputStream in) throws Exception {
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(new InputStreamReader(in, "utf-8"));
        JSONArray entries = (JSONArray)obj.get("entries");
        if (entries == null) {
            Logger.log("no playlist entry");
            entries = new JSONArray();
            entries.add(obj);
        }
        ArrayList<YdlVideo> playList = new ArrayList<YdlVideo>();
        int i = 0;
        while (i < entries.size()) {
            JSONObject jsobj = (JSONObject)entries.get(i);
            if (jsobj != null) {
                YdlVideo v = YdlResponse.getPlaylistEntry(jsobj);
                if (v != null) {
                    playList.add(v);
                } else {
                    Logger.log("Parsing failed");
                }
            }
            ++i;
        }
        Logger.log("Playlist size: " + playList.size());
        return playList;
    }

    /*
     * Unable to fully structure code
     */
    public static YdlVideo getPlaylistEntry(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        formatList = new ArrayList<YdlFormat>();
        formats = (JSONArray)obj.get("formats");
        if (formats != null) {
            i = 0;
            while (i < formats.size()) {
                Logger.log("Parsing format info");
                formatObj = (JSONObject)formats.get(i);
                protocol = YdlResponse.getString(formatObj.get("protocol"));
                format = new YdlFormat();
                format.protocol = protocol;
                format.url = YdlResponse.getString(formatObj.get("url"));
                format.acodec = YdlResponse.getString(formatObj.get("acodec"));
                format.vcodec = YdlResponse.getString(formatObj.get("vcodec"));
                format.width = YdlResponse.getInt(formatObj.get("width"));
                format.height = YdlResponse.getInt(formatObj.get("height"));
                format.ext = YdlResponse.getString(formatObj.get("ext"));
                if (!"mpd".equalsIgnoreCase(format.ext)) {
                    format.formatNote = YdlResponse.getString(formatObj.get("format_note"));
                    format.format = YdlResponse.getString(formatObj.get("format"));
                    sabr = "" + formatObj.get("abr");
                    try {
                        format.abr = Integer.parseInt(sabr);
                    }
                    catch (Exception e) {
                        format.abr = -1;
                    }
                    jsHeaders = (JSONObject)formatObj.get("http_headers");
                    if (jsHeaders != null) {
                        format.headers = new ArrayList<E>();
                        for (String key : jsHeaders.keySet()) {
                            value = (String)jsHeaders.get(key);
                            format.headers.add(new HttpHeader(key, value));
                        }
                    }
                    if (protocol.equals("http_dash_segments")) {
                        baseUrl = (String)formatObj.get("fragment_base_url");
                        fragmentArr = (JSONArray)formatObj.get("fragments");
                        fragments = new String[fragmentArr.size()];
                        j = 0;
                        while (j < fragmentArr.size()) {
                            frag = (JSONObject)fragmentArr.get(j);
                            url = (String)frag.get("url");
                            fragments[j] = url != null ? url : String.valueOf(baseUrl) + (String)frag.get("path");
                            ++j;
                        }
                        format.fragments = fragments;
                    }
                    formatList.add(format);
                }
                ++i;
            }
        } else {
            url = YdlResponse.getString(obj.get("url"));
            if (url != null) {
                format = new YdlFormat();
                format.protocol = YdlResponse.getString(obj.get("protocol"));
                format.url = url;
                format.acodec = YdlResponse.getString(obj.get("acodec"));
                format.vcodec = YdlResponse.getString(obj.get("vcodec"));
                try {
                    format.width = YdlResponse.getInt(obj.get("width"));
                }
                catch (Exception e) {
                    format.width = -1;
                }
                try {
                    format.height = YdlResponse.getInt(obj.get("height"));
                }
                catch (Exception e) {
                    format.width = -1;
                }
                format.ext = YdlResponse.getString(obj.get("ext"));
                format.formatNote = YdlResponse.getString(obj.get("format_note"));
                format.format = YdlResponse.getString(obj.get("format"));
                sabr = "" + obj.get("abr");
                try {
                    format.abr = Integer.parseInt(sabr);
                }
                catch (Exception e) {
                    format.abr = -1;
                }
                formatList.add(format);
            }
        }
        Logger.log("Format list count: " + formatList.size());
        mediaList = new ArrayList<YdlMediaFormat>();
        i = 0;
        while (i < formatList.size()) {
            block36: {
                block39: {
                    block38: {
                        block37: {
                            fmt = (YdlFormat)formatList.get(i);
                            if (fmt.protocol.equals("http_dash_segments")) break block36;
                            type = YdlResponse.getVideoType(fmt);
                            if (type != YdlResponse.DASH_VIDEO_ONLY) break block37;
                            j = 0;
                            while (j < formatList.size()) {
                                fmt2 = (YdlFormat)formatList.get(j);
                                type2 = YdlResponse.getVideoType(fmt2);
                                if (type2 == YdlResponse.DASH_AUDIO_ONLY) {
                                    media = new YdlMediaFormat();
                                    media.type = 99;
                                    if (fmt.protocol.equals(fmt2.protocol)) {
                                        media.audioSegments = new String[1];
                                        media.audioSegments[0] = fmt2.url;
                                        media.abr = fmt2.abr;
                                        media.videoSegments = new String[1];
                                        media.videoSegments[0] = fmt.url;
                                        if (fmt.headers != null) {
                                            media.headers.addAll(fmt.headers);
                                        }
                                        if (fmt2.headers != null) {
                                            media.headers2.addAll(fmt2.headers);
                                        }
                                        media.ext = String.valueOf(fmt.ext).equals(String.valueOf(fmt2.ext)) != false || String.valueOf(fmt.ext).equals("mp4") != false && String.valueOf(fmt2.ext).equals("m4a") != false ? fmt.ext : "mkv";
                                        media.width = fmt.width;
                                        media.height = fmt.height;
                                        media.format = YdlResponse.createFormat(media.ext, fmt.format, fmt2.format, fmt2.acodec, fmt.vcodec, fmt.width, fmt.height, fmt2.abr);
                                        System.out.println(String.valueOf(media.format) + " " + media.url);
                                        YdlResponse.checkAndAddMedia(media, mediaList);
                                    }
                                }
                                ++j;
                            }
                            break block36;
                        }
                        if (type == YdlResponse.DASH_AUDIO_ONLY) break block36;
                        media = new YdlMediaFormat();
                        if (!"m3u8".equals(fmt.protocol) && !"m3u8_native".equals(fmt.protocol)) break block38;
                        media.type = 97;
                        ** GOTO lbl132
                    }
                    if (!"f4m".equals(fmt.protocol)) break block39;
                    media.type = 96;
                    ** GOTO lbl132
                }
                if (!"http".equals(fmt.protocol) && !"https".equals(fmt.protocol)) {
                    Logger.log("unsupported protocol: " + fmt.protocol);
                } else {
                    media.type = 98;
lbl132:
                    // 3 sources

                    media.url = fmt.url;
                    media.ext = fmt.ext;
                    media.width = fmt.width;
                    media.height = fmt.height;
                    media.format = YdlResponse.createFormat(media.ext, fmt.format, null, fmt.acodec, fmt.vcodec, fmt.width, fmt.height, -1);
                    System.out.println(String.valueOf(media.format) + " " + media.url);
                    if (fmt.headers != null) {
                        media.headers.addAll(fmt.headers);
                    }
                    YdlResponse.checkAndAddMedia(media, mediaList);
                }
            }
            ++i;
        }
        Logger.log("VIDEO----" + obj.get("title"));
        i = 0;
        while (i < mediaList.size()) {
            Logger.log(String.valueOf(((YdlMediaFormat)mediaList.get((int)i)).type) + " " + ((YdlMediaFormat)mediaList.get((int)i)).format);
            ++i;
        }
        pl = new YdlVideo();
        pl.mediaFormats.addAll(mediaList);
        Collections.sort(pl.mediaFormats, new Comparator<YdlMediaFormat>(){

            @Override
            public int compare(YdlMediaFormat o1, YdlMediaFormat o2) {
                if (o1.width > o2.width) {
                    return -1;
                }
                if (o1.width < o2.width) {
                    return 1;
                }
                if (o1.abr > o2.abr) {
                    return -1;
                }
                if (o1.abr < o2.abr) {
                    return 1;
                }
                return 0;
            }
        });
        stitle = (String)obj.get("title");
        if (!StringUtils.isNullOrEmptyOrBlank(stitle)) {
            pl.title = stitle;
        }
        if ((thumbnail = (String)obj.get("thumbnail")) != null && !thumbnail.equals("none") && !thumbnail.equals("null")) {
            pl.thumbnail = thumbnail;
        }
        if (pl.thumbnail == null && (thumbnails = (JSONArray)obj.get("thumbnails")) != null) {
            i = 0;
            while (i < thumbnails.size()) {
                Logger.log("Parsing thumbnails info");
                thumbnailObj = (JSONObject)thumbnails.get(i);
                thumbnail = (String)thumbnailObj.get("url");
                if (thumbnail != null && !thumbnail.equals("none") && !thumbnail.equals("null")) {
                    pl.thumbnail = thumbnail;
                    break;
                }
                ++i;
            }
        }
        if ((sdur = "" + obj.get("duration")) != null && !sdur.equals("none") && !sdur.equals("null")) {
            try {
                pl.duration = Long.parseLong(sdur);
            }
            catch (Exception e) {
                pl.duration = -1L;
            }
        }
        return pl;
    }

    private static void checkAndAddMedia(YdlMediaFormat fmt, ArrayList<YdlMediaFormat> mediaList) {
        int i = 0;
        while (i < mediaList.size()) {
            YdlMediaFormat m = mediaList.get(i);
            if (fmt.type == m.type) {
                if (fmt.type == 99) {
                    int j;
                    boolean sameAudio = false;
                    boolean sameVideo = false;
                    if (fmt.audioSegments == null) {
                        if (m.audioSegments == null) {
                            sameAudio = true;
                        }
                    } else if (m.audioSegments != null && fmt.audioSegments.length == m.audioSegments.length) {
                        sameAudio = true;
                        j = 0;
                        while (j < fmt.audioSegments.length) {
                            if (!fmt.audioSegments[j].equals(m.audioSegments[j])) {
                                sameAudio = false;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (fmt.videoSegments == null) {
                        if (m.videoSegments == null) {
                            sameVideo = true;
                        }
                    } else if (m.videoSegments != null && fmt.videoSegments.length == m.videoSegments.length) {
                        sameVideo = true;
                        j = 0;
                        while (j < fmt.videoSegments.length) {
                            if (!fmt.videoSegments[j].equals(m.videoSegments[j])) {
                                sameVideo = false;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (sameAudio && sameVideo) {
                        return;
                    }
                } else if (m.url.equals(fmt.url)) {
                    return;
                }
            }
            ++i;
        }
        mediaList.add(fmt);
    }

    private static int getVideoType(YdlFormat fmt) {
        String fmtNote = null;
        String acodec = null;
        String vcodec = null;
        if (fmt.formatNote != null && ((fmtNote = fmt.formatNote.toLowerCase()).equals("none") || fmtNote.length() < 1)) {
            fmtNote = null;
        }
        if (fmtNote == null) {
            fmtNote = "";
        }
        if (fmt.acodec != null && ((acodec = fmt.acodec.toLowerCase()).equals("none") || acodec.length() < 1)) {
            acodec = null;
        }
        if (fmt.vcodec != null && ((vcodec = fmt.vcodec.toLowerCase()).equals("none") || vcodec.length() < 1)) {
            vcodec = null;
        }
        if (fmtNote.contains("dash audio")) {
            return DASH_AUDIO_ONLY;
        }
        if (fmtNote.contains("dash video")) {
            return DASH_VIDEO_ONLY;
        }
        if (acodec == null && vcodec == null) {
            return -1;
        }
        if (acodec != null && vcodec != null) {
            return -1;
        }
        if (acodec != null && vcodec == null) {
            return DASH_AUDIO_ONLY;
        }
        if (vcodec != null && acodec == null) {
            return DASH_VIDEO_ONLY;
        }
        return -1;
    }

    private static int getInt(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (obj.toString().contains("none")) {
            return -1;
        }
        return Integer.parseInt("" + obj);
    }

    private static String getString(Object obj) {
        return (String)obj;
    }

    public static String nvl(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String createFormat(String ext, String fmt1, String fmt2, String acodec, String vcodec, int width, int height, int abr) {
        StringBuffer sb = new StringBuffer();
        if ((ext = YdlResponse.nvl(ext)).length() > 0) {
            sb.append(ext.toUpperCase());
        }
        if (height > 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(String.valueOf(height) + "p");
        }
        if (abr > 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(String.valueOf(abr) + "kbps");
        }
        if ((acodec = YdlResponse.nvl(acodec)).contains("none")) {
            acodec = "";
        }
        if ((vcodec = YdlResponse.nvl(vcodec)).contains("none")) {
            vcodec = "";
        }
        if (acodec.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(acodec);
        }
        if (vcodec.length() > 0) {
            if (sb.length() > 0) {
                if (acodec.length() > 0) {
                    sb.append("+");
                } else {
                    sb.append(" ");
                }
            }
            sb.append(vcodec);
        }
        return sb.toString();
    }

    static class YdlFormat {
        String url;
        String format;
        String[] fragments;
        String formatNote;
        int width;
        int height;
        String protocol;
        String ext;
        String acodec;
        String vcodec;
        int abr;
        ArrayList<HttpHeader> headers;

        YdlFormat() {
        }
    }

    public static class YdlMediaFormat {
        public int type;
        public String url;
        public String[] audioSegments;
        public String[] videoSegments;
        public String format;
        public String ext;
        public ArrayList<HttpHeader> headers = new ArrayList();
        public ArrayList<HttpHeader> headers2 = new ArrayList();
        public int width;
        public int height;
        public int abr;

        public String toString() {
            return this.format;
        }
    }

    public static class YdlVideo {
        public String title;
        public ArrayList<YdlMediaFormat> mediaFormats = new ArrayList();
        public int index;
        public String thumbnail;
        public long duration;
    }
}

