/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import xdman.Config;
import xdman.util.Base64;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class CredentialManager {
    private Map<String, PasswordAuthentication> savedCredentials = new HashMap<String, PasswordAuthentication>();
    private Map<String, PasswordAuthentication> cachedCredentials = new HashMap<String, PasswordAuthentication>();
    private static CredentialManager _this;

    public static CredentialManager getInstance() {
        if (_this == null) {
            _this = new CredentialManager();
        }
        return _this;
    }

    public Set<Map.Entry<String, PasswordAuthentication>> getCredentials() {
        return this.savedCredentials.entrySet();
    }

    public PasswordAuthentication getCredentialForHost(String host) {
        PasswordAuthentication pauth = this.savedCredentials.get(host);
        if (pauth == null) {
            return this.cachedCredentials.get(host);
        }
        return null;
    }

    public PasswordAuthentication getCredentialForProxy() {
        if (!StringUtils.isNullOrEmptyOrBlank(Config.getInstance().getProxyUser())) {
            return new PasswordAuthentication(Config.getInstance().getProxyUser(), Config.getInstance().getProxyPass() == null ? null : Config.getInstance().getProxyPass().toCharArray());
        }
        return null;
    }

    private CredentialManager() {
        this.load();
    }

    public void addCredentialForHost(String host, PasswordAuthentication pauth, boolean save) {
        if (save) {
            this.savedCredentials.put(host, pauth);
        } else {
            this.cachedCredentials.put(host, pauth);
        }
    }

    public void addCredentialForHost(String host, String user, String pass, boolean save) {
        this.addCredentialForHost(host, new PasswordAuthentication(user, pass.toCharArray()), save);
    }

    public void addCredentialForHost(String host, String user, String pass) {
        this.addCredentialForHost(host, new PasswordAuthentication(user, pass.toCharArray()), false);
    }

    public void addCredentialForHost(String host, PasswordAuthentication pauth) {
        this.addCredentialForHost(host, pauth, false);
    }

    private void load() {
        BufferedReader br = null;
        try {
            File f = new File(Config.getInstance().getDataFolder(), ".credentials");
            if (!f.exists()) {
                Logger.log("No saved credentials");
                return;
            }
            try {
                String ln;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                if (!this.savedCredentials.isEmpty()) {
                    this.savedCredentials.clear();
                }
                while ((ln = br.readLine()) != null) {
                    String str = new String(Base64.decode(ln));
                    String[] arr = str.split("\n");
                    if (arr.length < 2) continue;
                    this.savedCredentials.put(arr[0], new PasswordAuthentication(arr[1], arr.length == 3 ? arr[2].toCharArray() : new char[]{}));
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        StringBuilder buf = new StringBuilder();
        for (String key : this.savedCredentials.keySet()) {
            PasswordAuthentication pauth = this.savedCredentials.get(key);
            String str = String.valueOf(key) + "\n" + pauth.getUserName() + "\n" + new String(pauth.getPassword());
            String str64 = Base64.encode(str.getBytes());
            buf.append(String.valueOf(str64) + "\n");
        }
        OutputStream out = null;
        try {
            try {
                File f = new File(Config.getInstance().getDataFolder(), ".credentials");
                out = new FileOutputStream(f);
                out.write(buf.toString().getBytes());
            }
            catch (Exception e) {
                Logger.log(e);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void removeSavedCredential(String host) {
        this.savedCredentials.remove(host);
        this.save();
    }
}

