/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import xdman.Config;
import xdman.DownloadEntry;
import xdman.DownloadQueue;
import xdman.XDMApp;
import xdman.ui.res.StringResource;
import xdman.util.Logger;

public class QueueManager {
    private static QueueManager _this;
    private ArrayList<DownloadQueue> queueList = new ArrayList();

    private QueueManager() {
        this.loadQueues();
    }

    public static QueueManager getInstance() {
        if (_this == null) {
            _this = new QueueManager();
        }
        return _this;
    }

    public DownloadQueue getQueueById(String queueId) {
        if (queueId == null) {
            return null;
        }
        if (queueId.length() < 1) {
            return this.queueList.get(0);
        }
        int i = 0;
        while (i < this.queueList.size()) {
            DownloadQueue q = this.queueList.get(i);
            if (q.getQueueId().equals(queueId)) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<DownloadQueue> getQueueList() {
        return this.queueList;
    }

    public DownloadQueue getDefaultQueue() {
        return this.queueList.get(0);
    }

    private void loadQueues() {
        File file = new File(Config.getInstance().getDataFolder(), "queues.txt");
        DownloadQueue defaultQ = new DownloadQueue("", StringResource.get("DEF_QUEUE"));
        this.queueList.add(defaultQ);
        if (!file.exists()) {
            return;
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
            int count = Integer.parseInt(reader.readLine().trim());
            int i = 0;
            while (i < count) {
                boolean hasStartTime;
                String id = reader.readLine().trim();
                String name = reader.readLine().trim();
                DownloadQueue queue = null;
                queue = "".equals(id) ? defaultQ : new DownloadQueue(id, name);
                int c = Integer.parseInt(reader.readLine().trim());
                int j = 0;
                while (j < c) {
                    queue.getQueuedItems().add(reader.readLine().trim());
                    ++j;
                }
                boolean bl = hasStartTime = Integer.parseInt(reader.readLine()) == 1;
                if (hasStartTime) {
                    boolean hasEndTime;
                    queue.setStartTime(Long.parseLong(reader.readLine()));
                    boolean bl2 = hasEndTime = Integer.parseInt(reader.readLine()) == 1;
                    if (hasEndTime) {
                        queue.setEndTime(Long.parseLong(reader.readLine()));
                    }
                    boolean isPeriodic = Integer.parseInt(reader.readLine()) == 1;
                    queue.setPeriodic(isPeriodic);
                    if (isPeriodic) {
                        queue.setDayMask(Integer.parseInt(reader.readLine()));
                    } else if (Integer.parseInt(reader.readLine()) == 1) {
                        String ln = reader.readLine();
                        queue.setExecDate(dateFormatter.parse(ln));
                    }
                }
                if (queue.getQueueId().length() > 0) {
                    this.queueList.add(queue);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveQueues() {
        int count = this.queueList.size();
        File file = new File(Config.getInstance().getDataFolder(), "queues.txt");
        BufferedWriter writer = null;
        String newLine = System.getProperty("line.separator");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
            writer.write(String.valueOf(count) + newLine);
            int i = 0;
            while (i < count) {
                DownloadQueue queue = this.queueList.get(i);
                writer.write(String.valueOf(queue.getQueueId()) + newLine);
                writer.write(String.valueOf(queue.getName()) + newLine);
                ArrayList<String> queuedItems = queue.getQueuedItems();
                writer.write(String.valueOf(queuedItems.size()) + newLine);
                int j = 0;
                while (j < queuedItems.size()) {
                    writer.write(String.valueOf(queuedItems.get(j)) + newLine);
                    ++j;
                }
                if (queue.getStartTime() != -1L) {
                    writer.write("1" + newLine);
                    writer.write(String.valueOf(queue.getStartTime()) + newLine);
                    if (queue.getEndTime() != -1L) {
                        writer.write("1" + newLine);
                        writer.write(String.valueOf(queue.getEndTime()) + newLine);
                    } else {
                        writer.write("0" + newLine);
                    }
                    writer.write(String.valueOf(queue.isPeriodic() ? 1 : 0) + newLine);
                    if (queue.isPeriodic()) {
                        writer.write(String.valueOf(queue.getDayMask()) + newLine);
                    } else if (queue.getExecDate() != null) {
                        writer.write("1" + newLine);
                        writer.write(String.valueOf(dateFormatter.format(queue.getExecDate())) + newLine);
                    } else {
                        writer.write("0" + newLine);
                    }
                } else {
                    writer.write("0" + newLine);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
    }

    public void removeQueue(String queueId) {
        DownloadQueue q = this.getQueueById(queueId);
        if (q == null) {
            return;
        }
        if (q.isRunning()) {
            q.stop();
        }
        int i = 0;
        while (i < q.getQueuedItems().size()) {
            String id = q.getQueuedItems().get(i);
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent != null) {
                ent.setQueueId("");
            }
            ++i;
        }
        this.queueList.remove(q);
    }

    public DownloadQueue createNewQueue() {
        boolean found;
        int counter = 1;
        String name = "";
        String qw = StringResource.get("Q_WORD");
        block0: do {
            found = false;
            ++counter;
            for (DownloadQueue qi : this.queueList) {
                if ("".equals(qi.getQueueId()) || !(String.valueOf(qw) + " " + counter).equals(qi.getName())) continue;
                found = true;
                continue block0;
            }
        } while (found);
        name = String.valueOf(qw) + " " + counter;
        DownloadQueue q = new DownloadQueue(UUID.randomUUID().toString(), name);
        this.queueList.add(q);
        this.saveQueues();
        return q;
    }

    public void fixCorruptEntries(Iterator<String> ids, XDMApp app) {
        DownloadQueue dfq = this.getDefaultQueue();
        while (ids.hasNext()) {
            String id = ids.next();
            DownloadEntry ent = app.getEntry(id);
            String qId = ent.getQueueId();
            if (qId != null && this.getQueueById(qId) != null) continue;
            dfq.getQueuedItems().add(id);
            ent.setQueueId("");
        }
        int i = 0;
        while (i < this.queueList.size()) {
            DownloadQueue q = this.queueList.get(i);
            ArrayList<String> corruptIds = new ArrayList<String>();
            int k = 0;
            while (k < q.getQueuedItems().size()) {
                String id = q.getQueuedItems().get(k);
                if (app.getEntry(id) == null) {
                    corruptIds.add(id);
                }
                ++k;
            }
            q.getQueuedItems().removeAll(corruptIds);
            ++i;
        }
    }
}

