/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders;

import java.io.InputStream;
import xdman.downloaders.Segment;
import xdman.downloaders.http.HttpChannel;
import xdman.util.Logger;

public abstract class AbstractChannel
implements Runnable {
    protected Segment chunk;
    private InputStream in;
    private byte[] buf;
    protected volatile boolean stop;
    protected String errorMessage;
    private boolean closed;
    private Thread t;
    protected int errorCode;

    protected AbstractChannel(Segment chunk) {
        this.chunk = chunk;
        this.buf = new byte[65536];
    }

    public void open() {
        this.t = new Thread(this);
        this.t.setName(this.chunk.getId());
        this.t.start();
    }

    protected abstract boolean connectImpl();

    protected abstract InputStream getInputStreamImpl();

    protected abstract long getLengthImpl();

    protected abstract void closeImpl();

    private boolean connect() {
        try {
            this.chunk.getChunkListener().synchronize();
        }
        catch (NullPointerException e) {
            Logger.log("stopped chunk " + this.chunk);
            return false;
        }
        if (this.connectImpl()) {
            this.in = this.getInputStreamImpl();
            long length = this.getLengthImpl();
            if (this.chunk.getLength() < 0L) {
                Logger.log("Setting length of " + this.chunk.getId() + " to: " + length);
                this.chunk.setLength(length);
            }
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            try {
                while (!this.stop) {
                    if (!this.connect()) {
                        if (!this.stop) {
                            this.chunk.transferFailed(this.errorMessage);
                        }
                        this.close();
                        break;
                    }
                    this.chunk.transferInitiated();
                    if (this.chunk == null) continue;
                    if (this.chunk.getLength() > 0L ? this.copyStream1() : this.copyStream2()) {
                        Logger.log("Copy Stream finished");
                        break;
                    }
                    Logger.log("Copy Stream not finished");
                }
            }
            catch (Exception e) {
                Logger.log("Internal problem: " + e);
                Logger.log(e);
                if (!this.stop) {
                    this.chunk.transferFailed(this.errorMessage);
                }
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    private void close() {
        if (this.closed) {
            return;
        }
        this.closeImpl();
        this.closed = true;
    }

    public void stop() {
        this.stop = true;
        this.chunk = null;
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    private boolean copyStream1() {
        Logger.log("Receiving by copyStream1");
        try {
            while (!this.stop) {
                this.chunk.getChunkListener().synchronize();
                long rem = this.chunk.getLength() - this.chunk.getDownloaded();
                if (rem == 0L) {
                    if (this instanceof HttpChannel) {
                        if (((HttpChannel)this).isFinished()) {
                            this.close();
                        }
                    } else {
                        this.close();
                    }
                    if (this.chunk.transferComplete()) {
                        Logger.log(this.chunk + " complete and closing " + this.chunk.getDownloaded() + " " + this.chunk.getLength());
                        return true;
                    }
                }
                if (this.stop) {
                    return false;
                }
                int diff = (int)(rem > (long)this.buf.length ? (long)this.buf.length : rem);
                int x = this.in.read(this.buf, 0, diff);
                if (this.stop) {
                    return false;
                }
                if (x == -1) {
                    Logger.log("Unexpected eof");
                    throw new Exception("Unexpected eof - downloaded: " + this.chunk.getDownloaded() + " expected: " + this.chunk.getLength());
                }
                this.chunk.getOutStream().write(this.buf, 0, x);
                if (this.stop) {
                    return false;
                }
                this.chunk.setDownloaded(this.chunk.getDownloaded() + (long)x);
                this.chunk.transferring();
            }
            return false;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
        finally {
            this.close();
        }
    }

    private boolean copyStream2() {
        Logger.log("Receiving by copyStream2");
        try {
            while (!this.stop) {
                this.chunk.getChunkListener().synchronize();
                int x = this.in.read(this.buf, 0, this.buf.length);
                if (this.stop) {
                    return false;
                }
                if (x == -1) {
                    this.chunk.transferComplete();
                    return true;
                }
                this.chunk.getOutStream().write(this.buf, 0, x);
                if (this.stop) {
                    return false;
                }
                this.chunk.setDownloaded(this.chunk.getDownloaded() + (long)x);
                this.chunk.transferring();
            }
            return false;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
        finally {
            this.close();
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

