/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.ftp;

import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Segment;
import xdman.downloaders.SegmentDownloader;
import xdman.downloaders.ftp.FtpChannel;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.util.Logger;

public class FtpDownloader
extends SegmentDownloader {
    private HttpMetadata metadata;
    private String newFileName;

    public FtpDownloader(String id, String folder, HttpMetadata metadata) {
        super(id, folder);
        this.metadata = metadata;
    }

    @Override
    public AbstractChannel createChannel(Segment segment) {
        FtpChannel hc = new FtpChannel(segment, this.metadata.getUrl());
        return hc;
    }

    @Override
    public int getType() {
        return 1004;
    }

    @Override
    public boolean isFileNameChanged() {
        Logger.log("Checking for filename change " + (this.newFileName != null));
        return this.newFileName != null;
    }

    @Override
    public String getNewFile() {
        return this.newFileName;
    }

    @Override
    protected void chunkConfirmed(Segment c) {
    }

    @Override
    public HttpMetadata getMetadata() {
        return this.metadata;
    }
}

